!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     polymers restart runs
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine restart_polymers_atom_MPI( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vux, vuy, vuz, pux, puy, puz, fictmass, ux, uy, uz, qmass, &
     &   xbath, ybath, zbath, xbath_cent, ybath_cent, zbath_cent, &
     &   qmass_cent, vxbath, vybath, vzbath, vxbath_cent, vybath_cent, &
     &   vzbath_cent, iounit, ncolor, nnhc, natom, nbead, mbox, &
     &   istep_end, myrank

!      use polymers_variables, only : xc_poly, yc_poly, zc_poly, jpoly
      use polymers_variables, only : jpoly, istep_poly, npoly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: pxbath, pybath, pzbath, pxbath_cent
      real(8) :: pybath_cent, pzbath_cent

      integer :: ioption, i, j, k, m
      integer :: ierr = 0

      character(len=3) :: char_num

!-----------------------------------------------------------------------
!     /*   read data from geometry.ini                                */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

!        /*   master rank   */
         if ( myrank .eq. 0 ) then

!           /*   polymer number  */
            call int3_to_char( jpoly, char_num )

!           /*   open file   */
            open ( iounit, &
     &         file = 'poly.' // char_num // '/geometry.ini' )

!           /*   read position and momentum   */

            do j = 1, nbead
            do i = 1, natom
               read( iounit, *, iostat=ierr ) &
     &            k,  ux(i,j),  uy(i,j), uz(i,j), &
     &               pux(i,j), puy(i,j), puz(i,j), mbox(1:3,i,j)
               if ( ierr .ne. 0 ) go to 100
            end do
            end do

!           /*   close file   */
            close( iounit )

!           /*   convert momentum to velocity   */

            do j = 1, nbead
            do i = 1, natom
               vux(i,j) = pux(i,j) / sqrt(fictmass(i,j))
               vuy(i,j) = puy(i,j) / sqrt(fictmass(i,j))
               vuz(i,j) = puz(i,j) / sqrt(fictmass(i,j))
            end do
            end do

!           /*   open file   */
            open ( iounit, &
     &         file = 'poly.' // char_num // '/bath.ini' )

!           /*   read non-centroid thermostat position and velocity  */

            do i = 2, nbead
            do j = 1, nnhc
            do k = 1, natom
               read( iounit, * ) &
     &            xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
               read( iounit, * ) &
     &            pxbath,       pybath,       pzbath
               if ( ierr .ne. 0 ) go to 100
               vxbath(k,j,i) = pxbath / sqrt(qmass(i))
               vybath(k,j,i) = pybath / sqrt(qmass(i))
               vzbath(k,j,i) = pzbath / sqrt(qmass(i))
            end do
            end do
            end do

!           /*   read centroid thermostat position and velocity  */

            do j = 1, natom
            do m = 1, ncolor
            do i = 1, nnhc
               read( iounit, * ) xbath_cent(j,i,m), ybath_cent(j,i,m), &
     &                           zbath_cent(j,i,m)
               read( iounit, * ) &
     &            pxbath_cent, pybath_cent, pzbath_cent
               if ( ierr .ne. 0 ) go to 100
               vxbath_cent(j,i,m) = pxbath_cent / sqrt(qmass_cent(i,m))
               vybath_cent(j,i,m) = pybath_cent / sqrt(qmass_cent(i,m))
               vzbath_cent(j,i,m) = pzbath_cent / sqrt(qmass_cent(i,m))
            end do
            end do
            end do

!           /*   close file   */
            close( iounit )

!           /*   read step   */
            call int3_to_char( jpoly, char_num )
            open ( iounit, file = 'poly.' //char_num// '/step.ini' )
            read ( iounit, *, iostat=ierr ) istep_poly(jpoly)
            close( iounit )
            if ( ierr .ne. 0 ) istep_poly(jpoly) = 0
            ierr = 0

!        /*   master rank   */
         end if

!        /*   on error   */
  100    continue

         call my_mpi_bcast_int_0 ( ierr )

         call error_handling_MPI &
     &      ( ierr, 'subroutine restart_polymers_atom_MPI', 36 )

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_MPI( 0 )

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_MPI( 0 )

!        /*   mpi communication   */

         call my_mpi_bcast_real_2 ( ux, natom, nbead )
         call my_mpi_bcast_real_2 ( uy, natom, nbead )
         call my_mpi_bcast_real_2 ( uz, natom, nbead )

         call my_mpi_bcast_real_2 ( vux, natom, nbead )
         call my_mpi_bcast_real_2 ( vuy, natom, nbead )
         call my_mpi_bcast_real_2 ( vuz, natom, nbead )

         call my_mpi_bcast_int_3  ( mbox, 3, natom, nbead )

         call my_mpi_bcast_real_3 ( xbath, natom, nnhc, nbead )
         call my_mpi_bcast_real_3 ( ybath, natom, nnhc, nbead )
         call my_mpi_bcast_real_3 ( zbath, natom, nnhc, nbead )

         call my_mpi_bcast_real_3 ( vxbath, natom, nnhc, nbead )
         call my_mpi_bcast_real_3 ( vybath, natom, nnhc, nbead )
         call my_mpi_bcast_real_3 ( vzbath, natom, nnhc, nbead )

         call my_mpi_bcast_real_3 ( xbath_cent, natom, nnhc, ncolor )
         call my_mpi_bcast_real_3 ( ybath_cent, natom, nnhc, ncolor )
         call my_mpi_bcast_real_3 ( zbath_cent, natom, nnhc, ncolor )

         call my_mpi_bcast_real_3 ( vxbath_cent, natom, nnhc, ncolor )
         call my_mpi_bcast_real_3 ( vybath_cent, natom, nnhc, ncolor )
         call my_mpi_bcast_real_3 ( vzbath_cent, natom, nnhc, ncolor )

         call my_mpi_bcast_int_1 ( istep_poly, npoly )

!-----------------------------------------------------------------------
!     /*   write data to geometry.ini                                 */
!-----------------------------------------------------------------------

      else if ( ioption .eq. 2 ) then

!        /*   master rank   */
         if ( myrank .eq. 0 ) then

!           /*   polymer number  */
            call int3_to_char( jpoly, char_num )

!           /*   convert velocity to momentum   */

            do j = 1, nbead
            do i = 1, natom
               pux(i,j) = vux(i,j) * sqrt(fictmass(i,j))
               puy(i,j) = vuy(i,j) * sqrt(fictmass(i,j))
               puz(i,j) = vuz(i,j) * sqrt(fictmass(i,j))
            end do
            end do

!           /*   current step   */
            k = istep_end

!c           /*   last step -> zeroth step   */
!            if ( istep_end .ge. nstep ) k = 0

!           /*   open file   */
            open ( iounit, &
     &         file = 'poly.' // char_num // '/geometry.ini' )

!           /*   write position and momentum   */

            do j = 1, nbead
            do i = 1, natom
               write( iounit, '(i8,6e24.16,3i4)' ) &
     &            k,  ux(i,j),  uy(i,j),  uz(i,j), &
     &               pux(i,j), puy(i,j), puz(i,j), mbox(1:3,i,j)
            end do
            end do

!            do i = 1, natom
!               write( iounit, '(i8,6e24.16,3i4)' )
!     &            k,  xc_poly(i,jpoly), yc_poly(i,jpoly),
!     &                zc_poly(i,jpoly),
!     &                pux(i,1), puy(i,1), puz(i,1), 0, 0, 0
!            end do
!            do j = 2, nbead
!            do i = 1, natom
!               write( iounit, '(i8,6e24.16,3i4)' )
!     &            k,  ux(i,j),  uy(i,j),  uz(i,j),
!     &               pux(i,j), puy(i,j), puz(i,j), 0, 0, 0
!            end do
!            end do

!           /*   close file   */
            close( iounit )

            open ( iounit, &
     &         file = 'poly.' // char_num // '/bath.ini' )

!           /*   write non-centroid thermostat position and velocity  */

            do i = 2, nbead
            do j = 1, nnhc
            do k = 1, natom
               pxbath = sqrt(qmass(i)) * vxbath(k,j,i)
               pybath = sqrt(qmass(i)) * vybath(k,j,i)
               pzbath = sqrt(qmass(i)) * vzbath(k,j,i)
               write( iounit, '(3e24.16)' ) &
     &            xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
               write( iounit, '(3e24.16)' ) &
     &            pxbath, pybath, pzbath
            end do
            end do
            end do

!           /*   write centroid thermostat position and velocity  */

            do j = 1, natom
            do m = 1, ncolor
            do i = 1, nnhc
               pxbath_cent = sqrt(qmass_cent(i,m)) * vxbath_cent(j,i,m)
               pybath_cent = sqrt(qmass_cent(i,m)) * vybath_cent(j,i,m)
               pzbath_cent = sqrt(qmass_cent(i,m)) * vzbath_cent(j,i,m)
               write( iounit, '(3e24.16)' ) &
     &            xbath_cent(j,i,m), ybath_cent(j,i,m), &
     &            zbath_cent(j,i,m)
               write( iounit, '(3e24.16)' ) &
     &            pxbath_cent, pybath_cent, pzbath_cent
            end do
            end do
            end do

!           /*   close file   */
            close( iounit )

!           /*   write step   */
            call int3_to_char( jpoly, char_num )
            open ( iounit, file = 'poly.' //char_num// '/step.ini' )
            write( iounit, '(i8)' ) istep_poly(jpoly)
            close( iounit )

!        /*   master rank   */
         end if

!     /*   end of if statement   */
      end if

      return
      end





!***********************************************************************
      subroutine restart_polymers_cons_MPI( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : iounit, myrank_world

      use cons_variables, only : ncons

      use polymers_variables, only : rcons_poly, npoly, istep_poly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, i, j, ierr

      character(len=3) :: char_num

!-----------------------------------------------------------------------
!     /*   read rcons_poly                                            */
!-----------------------------------------------------------------------

!     /*   option   */
      if ( ioption .eq. 1 ) then

!        /*   grand master rank   */
         if ( myrank_world .eq. 0 ) then

!           /*   open file   */
            open ( iounit, file = 'cons.ini' )

!           /*   read cv positions   */
            do i = 1, npoly
            do j = 1, ncons
               read ( iounit, *, iostat=ierr ) rcons_poly(j,i)
            end do
            end do

!           /*   close file   */
            close( iounit )

!           /*   read step   */
            do i = 1, npoly
               call int3_to_char( i, char_num )
               open ( iounit, file = 'poly.' //char_num// '/step.ini' )
               read ( iounit, *, iostat=ierr ) istep_poly(i)
               close( iounit )
               if ( ierr .ne. 0 ) istep_poly(i) = 0
            end do

!        /*   grand master rank   */
         end if

!        /*   communication   */
         call my_mpi_bcast_int_0_world( ierr )

!        /*   error handling   */
         call error_handling_MPI &
     &      ( ierr, 'subroutine restart_polymers_cons_MPI', 36 )

!        /*   communication   */
         call my_mpi_bcast_real_2_world( rcons_poly, ncons, npoly )

!        /*   communication   */
         call my_mpi_bcast_int_1_world( istep_poly, npoly )

!-----------------------------------------------------------------------
!     /*   write rcons_poly                                           */
!-----------------------------------------------------------------------

!     /*   option   */
      else if ( ioption .eq. 2 ) then

!        /*   grand master rank   */
         if ( myrank_world .eq. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'cons.ini' )

!           /*   write cv positions   */
            do i = 1, npoly
            do j = 1, ncons
               write( iounit, '(e24.16)' ) rcons_poly(j,i)
            end do
            end do

!           /*   file close   */
            close( iounit )

!           /*   write step   */
            do i = 1, npoly
               call int3_to_char( i, char_num )
               open ( iounit, file = 'poly.' //char_num// '/step.ini' )
               write( iounit, '(i8)' ) istep_poly(i)
               close( iounit )
            end do

!        /*   grand master rank   */
         end if

!     /*   option   */
      end if

      return
      end
