!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     restart thermostats in multiscale simulations
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine restart_bath_multi_me_MPI( irw )
!***********************************************************************
!=======================================================================
!
!     read/write restart file    irw = 1 :   read position and momentum
!                                irw = 2 :   write
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath, ybath, zbath, vxbath, vybath, vzbath, &
     &   xbath_cent, ybath_cent, zbath_cent, vxbath_cent, vybath_cent, &
     &   vzbath_cent, iounit, ncolor, natom, nbead, nnhc, myrank

      use qmmm_variables, only : &
     &   qmass_multi_a, qmass_multi_b, qmass_cent_multi_a, &
     &   qmass_cent_multi_b, natom_p, natom_s

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: irw, i, j, k, m

      real(8) :: pxbath, pybath, pzbath, pxbath_cent, pybath_cent, &
     &           pzbath_cent

!-----------------------------------------------------------------------
!     /*   read position and momentum                                 */
!-----------------------------------------------------------------------

      if ( irw .eq. 1 ) then

         if ( myrank .eq. 0 ) then

            open ( iounit, file = 'bath.ini', status = 'unknown' )

!              /*   non-centroid   */

               do i = 2, nbead
               do j = 1, nnhc

                  do k = 1, natom_p
                     read(iounit,*) &
     &               xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
                     read(iounit,*) &
     &               pxbath,       pybath,       pzbath
                     vxbath(k,j,i) = pxbath/sqrt(qmass_multi_a(i))
                     vybath(k,j,i) = pybath/sqrt(qmass_multi_a(i))
                     vzbath(k,j,i) = pzbath/sqrt(qmass_multi_a(i))
                  end do

                  do k = natom_p+1, natom_p+natom_s
                     read(iounit,*) &
     &               xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
                     read(iounit,*) &
     &               pxbath,       pybath,       pzbath
                     vxbath(k,j,i) = pxbath/sqrt(qmass_multi_b(i))
                     vybath(k,j,i) = pybath/sqrt(qmass_multi_b(i))
                     vzbath(k,j,i) = pzbath/sqrt(qmass_multi_b(i))
                  end do

               end do
               end do

!              /*   centroid   */

               do j = 1, natom_p
               do m = 1, ncolor
               do i = 1, nnhc
                  read(iounit,*)  xbath_cent(j,i,m), ybath_cent(j,i,m), &
     &                            zbath_cent(j,i,m)
                  read(iounit,*) &
     &            pxbath_cent,       pybath_cent,       pzbath_cent
                  vxbath_cent(j,i,m) &
     &               = pxbath_cent/sqrt(qmass_cent_multi_a(i,m))
                  vybath_cent(j,i,m) &
     &               = pybath_cent/sqrt(qmass_cent_multi_a(i,m))
                  vzbath_cent(j,i,m) &
     &               = pzbath_cent/sqrt(qmass_cent_multi_a(i,m))
               end do
               end do
               end do

               do j = natom_p+1, natom_p+natom_s
               do m = 1, ncolor
               do i = 1, nnhc
                  read(iounit,*)  xbath_cent(j,i,m), ybath_cent(j,i,m), &
     &                            zbath_cent(j,i,m)
                  read(iounit,*) &
     &            pxbath_cent,       pybath_cent,       pzbath_cent
                  vxbath_cent(j,i,m) &
     &               = pxbath_cent/sqrt(qmass_cent_multi_b(i,m))
                  vybath_cent(j,i,m) &
     &               = pybath_cent/sqrt(qmass_cent_multi_b(i,m))
                  vzbath_cent(j,i,m) &
     &               = pzbath_cent/sqrt(qmass_cent_multi_b(i,m))
               end do
               end do
               end do

            close( iounit )

         end if

         call my_mpi_bcast_real_3 ( vxbath, natom, nnhc, nbead )
         call my_mpi_bcast_real_3 ( vybath, natom, nnhc, nbead )
         call my_mpi_bcast_real_3 ( vzbath, natom, nnhc, nbead )
         call my_mpi_bcast_real_3 ( vxbath_cent, natom, nnhc, ncolor )
         call my_mpi_bcast_real_3 ( vybath_cent, natom, nnhc, ncolor )
         call my_mpi_bcast_real_3 ( vzbath_cent, natom, nnhc, ncolor )

!-----------------------------------------------------------------------
!     /*   write                                                      */
!-----------------------------------------------------------------------

      else if ( irw .eq. 2 ) then

!        /*   only myrank = 0   */
         if ( myrank .ne. 0 ) return

         open ( iounit, file = 'bath.ini', status = 'unknown' )

!           /*   non-centroid   */

            do i = 2, nbead
            do j = 1, nnhc

               do k = 1, natom_p
                  pxbath = sqrt(qmass_multi_a(i))*vxbath(k,j,i)
                  pybath = sqrt(qmass_multi_a(i))*vybath(k,j,i)
                  pzbath = sqrt(qmass_multi_a(i))*vzbath(k,j,i)
                  write(iounit,'(3e24.16)') &
     &            xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
                  write(iounit,'(3e24.16)') &
     &            pxbath,       pybath,       pzbath
               end do

               do k = natom_p+1, natom_p+natom_s
                  pxbath = sqrt(qmass_multi_b(i))*vxbath(k,j,i)
                  pybath = sqrt(qmass_multi_b(i))*vybath(k,j,i)
                  pzbath = sqrt(qmass_multi_b(i))*vzbath(k,j,i)
                  write(iounit,'(3e24.16)') &
     &            xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
                  write(iounit,'(3e24.16)') &
     &            pxbath,       pybath,       pzbath
               end do

            end do
            end do

!           /*   centroid   */

            do j = 1, natom_p
            do m = 1, ncolor
            do i = 1, nnhc
               pxbath_cent &
     &            = sqrt(qmass_cent_multi_a(i,m))*vxbath_cent(j,i,m)
               pybath_cent &
     &            = sqrt(qmass_cent_multi_a(i,m))*vybath_cent(j,i,m)
               pzbath_cent &
     &            = sqrt(qmass_cent_multi_a(i,m))*vzbath_cent(j,i,m)
               write(iounit,'(3e24.16)') &
     &         xbath_cent(j,i,m), ybath_cent(j,i,m), zbath_cent(j,i,m)
               write(iounit,'(3e24.16)') &
     &         pxbath_cent,       pybath_cent,       pzbath_cent
            end do
            end do
            end do

            do j = natom_p+1, natom_p+natom_s
            do m = 1, ncolor
            do i = 1, nnhc
               pxbath_cent &
     &            = sqrt(qmass_cent_multi_b(i,m))*vxbath_cent(j,i,m)
               pybath_cent &
     &            = sqrt(qmass_cent_multi_b(i,m))*vybath_cent(j,i,m)
               pzbath_cent &
     &            = sqrt(qmass_cent_multi_b(i,m))*vzbath_cent(j,i,m)
               write(iounit,'(3e24.16)') &
     &         xbath_cent(j,i,m), ybath_cent(j,i,m), zbath_cent(j,i,m)
               write(iounit,'(3e24.16)') &
     &         pxbath_cent,       pybath_cent,       pzbath_cent
            end do
            end do
            end do

         close( iounit )

      else

!        /*   error handling   */
         call error_handling_MPI &
     &      ( 1, 'subroutine restart_bath_multi_me_MPI', 36 )

      end if

      return
      end
