!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     restart thermostats in multiscale simulations
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine restart_bath_multi_me( irw )
!***********************************************************************
!=======================================================================
!
!     read/write restart file    irw = 1 :   read position and momentum
!                                irw = 2 :   write
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath, ybath, zbath, vxbath, vybath, vzbath, &
     &   xbath_cent, ybath_cent, zbath_cent, vxbath_cent, vybath_cent, &
     &   vzbath_cent, iounit, ncolor, nbead, nnhc, natom

      use qmmm_variables, only : &
     &   qmass_multi_a, qmass_multi_b, qmass_cent_multi_a, &
     &   qmass_cent_multi_b, layer

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: irw, i, j, k, m

      real(8) :: pxbath, pybath, pzbath, pxbath_cent, pybath_cent, &
     &           pzbath_cent, sqrt_qmass

!-----------------------------------------------------------------------
!     /*   read position and momentum                                 */
!-----------------------------------------------------------------------

      sqrt_qmass = 1.d0

      if ( irw .eq. 1 ) then

         open ( iounit, file = 'bath.ini', status = 'unknown' )

!           /*   non-centroid   */

            do i = 2, nbead
            do j = 1, nnhc

               do k = 1, natom

                  if      ( layer(k)(1:1) .eq. 'A' ) then
                     sqrt_qmass = sqrt(qmass_multi_a(i))
                  else if ( layer(k)(1:1) .eq. 'B' ) then
                     sqrt_qmass = sqrt(qmass_multi_b(i))
                  end if

                  read(iounit,*) &
     &            xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
                  read(iounit,*) &
     &            pxbath,       pybath,       pzbath

                  vxbath(k,j,i) = pxbath/sqrt_qmass
                  vybath(k,j,i) = pybath/sqrt_qmass
                  vzbath(k,j,i) = pzbath/sqrt_qmass

               end do

            end do
            end do

!           /*   centroid   */

            do j = 1, natom
            do m = 1, ncolor
            do i = 1, nnhc

               if      ( layer(j)(1:1) .eq. 'A' ) then
                  sqrt_qmass = sqrt(qmass_cent_multi_a(i,m))
               else if ( layer(j)(1:1) .eq. 'B' ) then
                  sqrt_qmass = sqrt(qmass_cent_multi_b(i,m))
               end if

               read(iounit,*) &
     &         xbath_cent(j,i,m), ybath_cent(j,i,m), zbath_cent(j,i,m)
               read(iounit,*) &
     &         pxbath_cent,       pybath_cent,       pzbath_cent

               vxbath_cent(j,i,m) = pxbath_cent/sqrt_qmass
               vybath_cent(j,i,m) = pybath_cent/sqrt_qmass
               vzbath_cent(j,i,m) = pzbath_cent/sqrt_qmass

            end do
            end do
            end do

         close( iounit )

!-----------------------------------------------------------------------
!     /*   write                                                      */
!-----------------------------------------------------------------------

      else if ( irw .eq. 2 ) then

         open ( iounit, file = 'bath.ini', status = 'unknown' )

!           /*   non-centroid   */

            do i = 2, nbead
            do j = 1, nnhc

               do k = 1, natom

                  if      ( layer(k)(1:1) .eq. 'A' ) then
                     sqrt_qmass = sqrt(qmass_multi_a(i))
                  else if ( layer(k)(1:1) .eq. 'B' ) then
                     sqrt_qmass = sqrt(qmass_multi_b(i))
                  end if

                  pxbath = sqrt_qmass*vxbath(k,j,i)
                  pybath = sqrt_qmass*vybath(k,j,i)
                  pzbath = sqrt_qmass*vzbath(k,j,i)

                  write(iounit,'(3e24.16)') &
     &            xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
                  write(iounit,'(3e24.16)') &
     &            pxbath,       pybath,       pzbath

               end do

            end do
            end do

!           /*   centroid   */

            do j = 1, natom
            do m = 1, ncolor
            do i = 1, nnhc

               if      ( layer(j)(1:1) .eq. 'A' ) then
                  sqrt_qmass = sqrt(qmass_cent_multi_a(i,m))
               else if ( layer(j)(1:1) .eq. 'B' ) then
                  sqrt_qmass = sqrt(qmass_cent_multi_b(i,m))
               end if

               pxbath_cent = sqrt_qmass*vxbath_cent(j,i,m)
               pybath_cent = sqrt_qmass*vybath_cent(j,i,m)
               pzbath_cent = sqrt_qmass*vzbath_cent(j,i,m)

               write(iounit,'(3e24.16)') &
     &         xbath_cent(j,i,m), ybath_cent(j,i,m), zbath_cent(j,i,m)
               write(iounit,'(3e24.16)') &
     &         pxbath_cent,       pybath_cent,       pzbath_cent

            end do
            end do
            end do

         close( iounit )

      else

         call error_handling &
     &      ( 1, 'subroutine restart_bath_multi_me', 32 )

      end if

      return
      end
