!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     restart thermostats in molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine restart_bath_cart( irw )
!***********************************************************************
!=======================================================================
!
!     read/write restart file    irw = 1 :   read position and momentum
!                                irw = 2 :   write
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   xbath, ybath, zbath, vxbath, vybath, vzbath, qmass, &
     &   natom, nbead, nnhc, iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: irw, i, j, k

      real(8):: pxbath, pybath, pzbath

!-----------------------------------------------------------------------
!     /*   read position and momentum                                 */
!-----------------------------------------------------------------------

      if ( irw .eq. 1 ) then

         open ( iounit, file = 'bath.ini', status = 'unknown' )

!           /*   thermostat attached to system   */

            do i = 1, nbead
            do j = 1, nnhc
            do k = 1, natom
               read(iounit,*) &
     &         xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
               read(iounit,*) &
     &         pxbath,       pybath,       pzbath
               vxbath(k,j,i) = pxbath/sqrt(qmass(i))
               vybath(k,j,i) = pybath/sqrt(qmass(i))
               vzbath(k,j,i) = pzbath/sqrt(qmass(i))
            end do
            end do
            end do

         close( iounit )

!-----------------------------------------------------------------------
!     /*   write                                                      */
!-----------------------------------------------------------------------

      else if ( irw .eq. 2 ) then

         open ( iounit, file = 'bath.ini', status = 'unknown' )

!           /*   thermostat attached to system   */

            do i = 1, nbead
            do j = 1, nnhc
            do k = 1, natom
               pxbath = sqrt(qmass(i))*vxbath(k,j,i)
               pybath = sqrt(qmass(i))*vybath(k,j,i)
               pzbath = sqrt(qmass(i))*vzbath(k,j,i)
               write(iounit,'(3e24.16)') &
     &         xbath(k,j,i), ybath(k,j,i), zbath(k,j,i)
               write(iounit,'(3e24.16)') &
     &         pxbath,       pybath,       pzbath
            end do
            end do
            end do

         close( iounit )

      else

         call error_handling( 1, 'subroutine restart_bath_cart', 28 )

      end if

      return
      end





!***********************************************************************
      subroutine restart_bath_cart_revised( irw )
!***********************************************************************
!=======================================================================
!
!     read/write restart file    irw = 1 :   read position and momentum
!                                irw = 2 :   write
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   qmass_cart, xbath_cart, ybath_cart, zbath_cart, &
     &   vxbath_cart, vybath_cart, vzbath_cart, &
     &   natom, nbead, nnhc, iounit, ncolor

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: irw, i, j, k, m

      real(8) :: pxbath_cart, pybath_cart, pzbath_cart

!-----------------------------------------------------------------------
!     /*   read position and momentum                                 */
!-----------------------------------------------------------------------

      if ( irw .eq. 1 ) then

         open ( iounit, file = 'bath.ini', status = 'unknown' )

!           /*   thermostat attached to system   */

            do k = 1, nbead
            do m = 1, ncolor
            do i = 1, nnhc
            do j = 1, natom
               read(iounit,*) &
     &         xbath_cart(j,i,m,k), ybath_cart(j,i,m,k), &
     &         zbath_cart(j,i,m,k)
               read(iounit,*) &
     &         pxbath_cart, pybath_cart, pzbath_cart
               vxbath_cart(j,i,m,k) = pxbath_cart/sqrt(qmass_cart(i,m))
               vybath_cart(j,i,m,k) = pybath_cart/sqrt(qmass_cart(i,m))
               vzbath_cart(j,i,m,k) = pzbath_cart/sqrt(qmass_cart(i,m))
            end do
            end do
            end do
            end do

         close( iounit )

!-----------------------------------------------------------------------
!     /*   write                                                      */
!-----------------------------------------------------------------------

      else if ( irw .eq. 2 ) then

         open ( iounit, file = 'bath.ini', status = 'unknown' )

!           /*   thermostat attached to system   */

            do k = 1, nbead
            do m = 1, ncolor
            do i = 1, nnhc
            do j = 1, natom
               pxbath_cart = sqrt(qmass_cart(i,m))*vxbath_cart(j,i,m,k)
               pybath_cart = sqrt(qmass_cart(i,m))*vybath_cart(j,i,m,k)
               pzbath_cart = sqrt(qmass_cart(i,m))*vzbath_cart(j,i,m,k)
               write(iounit,'(3e24.16)') &
     &         xbath_cart(j,i,m,k), ybath_cart(j,i,m,k), &
     &         zbath_cart(j,i,m,k)
               write(iounit,'(3e24.16)') &
     &         pxbath_cart, pybath_cart, pzbath_cart
            end do
            end do
            end do
            end do

         close( iounit )

      else

         call error_handling &
     &      ( 1, 'subroutine restart_bath_cart_revised', 36 )

      end if

      return
      end
