!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine rehmccycle_t_MPI
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     no exchange between parallel temperatures.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc_MPI

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_t_MPI

!     /*   do some analysis   */
      call analysis_rehmc_MPI( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce_MPI

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc_MPI

!        /*   end of molecular dynamics cycle   */
         end do

!c        /*   energy   */
!         call getenergy_rehmc_MPI

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc_MPI

!        /*   adjust HMC step   */
         call adjust_step_rehmc_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_t_MPI

!        /*   atom exchange   */
         call exchange_rehmc_MPI

!        /*   do some analysis   */
         call analysis_rehmc_MPI( 2 )

!        /*   output restart   */
         call backup_rehmc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_tx_MPI
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     temperature exchange.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc_MPI

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_tx_MPI

!     /*   do some analysis   */
      call analysis_rehmc_MPI( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce_MPI

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc_MPI

!        /*   end of molecular dynamics cycle   */
         end do

!c        /*   energy   */
!         call getenergy_rehmc_MPI

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc_MPI

!        /*   judge accept or reject: rem   */
         call judge_rem_rehmc_MPI

!        /*   adjust HMC step   */
         call adjust_step_rehmc_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_tx_MPI

!        /*   atom exchange   */
         call exchange_rehmc_MPI

!        /*   do some analysis   */
         call analysis_rehmc_MPI( 2 )

!        /*   output restart   */
         call backup_rehmc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_hx_MPI
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     hamiltonian exchange of alchemical mixture.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_alchem_MPI

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc_MPI

!     /*   save data   */
      call save_rex_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_hx_MPI

!     /*   do some analysis   */
      call analysis_rehmc_MPI( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce_alchem_MPI

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc_MPI

!        /*   end of molecular dynamics cycle   */
         end do

!c        /*   energy   */
!         call getenergy_rehmc_MPI

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rex_rehmc_MPI

!        /*   judge accept or reject: rex   */
         call judge_rex_rehmc_MPI

!        /*   adjust HMC step   */
         call adjust_step_rehmc_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_hx_MPI

!        /*   atom exchange   */
         call exchange_rehmc_MPI

!        /*   do some analysis   */
         call analysis_rehmc_MPI( 2 )

!        /*   output restart   */
         call backup_rehmc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_t_dual_MPI
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     no exchange between parallel temperatures.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_dual_lo_MPI

!     /*   get interatomic forces   */
      call getforce_dual_hi_MPI

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc_MPI

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_t_MPI

!     /*   do some analysis   */
      call analysis_rehmc_MPI( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   get interatomic forces   */
         call getforce_dual_lo_MPI

!        /*   force multiplied by nbead   */
         call nm_trans_force_rehmc

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce_dual_lo_MPI

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc_MPI

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   get interatomic forces   */
         call getforce_dual_hi_MPI

!        /*   energy   */
         call getenergy_rehmc_MPI

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc_MPI

!        /*   adjust HMC step   */
         call adjust_step_rehmc_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_t_MPI

!        /*   atom exchange   */
         call exchange_rehmc_dual_MPI

!        /*   do some analysis   */
         call analysis_rehmc_MPI( 2 )

!        /*   output restart   */
         call backup_rehmc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_tx_dual_MPI
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     temperature exchange.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_dual_lo_MPI

!     /*   get interatomic forces   */
      call getforce_dual_hi_MPI

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc_MPI

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_tx_MPI

!     /*   do some analysis   */
      call analysis_rehmc_MPI( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   get interatomic forces   */
         call getforce_dual_lo_MPI

!        /*   force multiplied by nbead   */
         call nm_trans_force_rehmc

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce_dual_lo_MPI

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc_MPI

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   get interatomic forces   */
         call getforce_dual_hi_MPI

!        /*   energy   */
         call getenergy_rehmc_MPI

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc_MPI

!        /*   judge accept or reject: rem   */
         call judge_rem_rehmc_MPI

!        /*   adjust HMC step   */
         call adjust_step_rehmc_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_tx_MPI

!        /*   atom exchange   */
         call exchange_rehmc_dual_MPI

!        /*   do some analysis   */
         call analysis_rehmc_MPI( 2 )

!        /*   output restart   */
         call backup_rehmc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end
