!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine rehmccycle_t
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     no exchange between parallel temperatures.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_t

!     /*   do some analysis   */
      call analysis_rehmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc

!        /*   end of molecular dynamics cycle   */
         end do

!c        /*   energy   */
!         call getenergy_rehmc

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc

!        /*   adjust HMC step   */
         call adjust_step_rehmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_t

!        /*   atom exchange   */
         call exchange_rehmc

!        /*   do some analysis   */
         call analysis_rehmc( 2 )

!        /*   output restart   */
         call backup_rehmc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_tx
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     temperature exchange.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_tx

!     /*   do some analysis   */
      call analysis_rehmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc

!        /*   end of molecular dynamics cycle   */
         end do

!c        /*   energy   */
!         call getenergy_rehmc

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc

!        /*   judge accept or reject: rem   */
         call judge_rem_rehmc

!        /*   adjust HMC step   */
         call adjust_step_rehmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_tx

!        /*   atom exchange   */
         call exchange_rehmc

!        /*   do some analysis   */
         call analysis_rehmc( 2 )

!        /*   output restart   */
         call backup_rehmc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_hx
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     hamiltonian exchange of alchemical mixture.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_alchem

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc

!     /*   save data   */
      call save_rex_rehmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_hx

!     /*   adjust HMC step   */
      call adjust_step_rehmc

!     /*   do some analysis   */
      call analysis_rehmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce_alchem

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc

!        /*   end of molecular dynamics cycle   */
         end do

!c        /*   energy   */
!         call getenergy_rehmc

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rex_rehmc

!        /*   judge accept or reject: rex   */
         call judge_rex_rehmc

!        /*   adjust HMC step   */
         call adjust_step_rehmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_hx

!        /*   atom exchange   */
         call exchange_rehmc

!        /*   do some analysis   */
         call analysis_rehmc( 2 )

!        /*   output restart   */
         call backup_rehmc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_t_dual
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     no exchange between parallel temperatures.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_dual_lo

!     /*   get interatomic forces   */
      call getforce_dual_hi

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_t

!     /*   do some analysis   */
      call analysis_rehmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   get interatomic forces   */
         call getforce_dual_lo

!        /*   force multiplied by nbead   */
         call nm_trans_force_rehmc

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce_dual_lo

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   get interatomic forces   */
         call getforce_dual_hi

!        /*   energy   */
         call getenergy_rehmc

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc

!        /*   adjust HMC step   */
         call adjust_step_rehmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_t

!        /*   atom exchange   */
         call exchange_rehmc_dual

!        /*   do some analysis   */
         call analysis_rehmc( 2 )

!        /*   output restart   */
         call backup_rehmc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine rehmccycle_tx_dual
!***********************************************************************
!=======================================================================
!
!     replica exchange hybrid monte carlo:
!     temperature exchange.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_end, istep_start, nstep, iexit, istep_hmc

      use rehmc_variables, only : &
     &   jstep

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   get interatomic forces   */
      call getforce_dual_lo

!     /*   get interatomic forces   */
      call getforce_dual_hi

!     /*   force multiplied by nbead   */
      call nm_trans_force_rehmc

!     /*   energy   */
      call getenergy_rehmc

!     /*   save data   */
      call save_rehmc

!     /*   adjust HMC step   */
      call adjust_step_rehmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_rehmc_tx

!     /*   do some analysis   */
      call analysis_rehmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   get interatomic forces   */
         call getforce_dual_lo

!        /*   force multiplied by nbead   */
         call nm_trans_force_rehmc

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   update the coordinates   */
            call update_pos_xyz_rehmc

!           /*   get interatomic forces   */
            call getforce

!           /*   get interatomic forces   */
            call getforce_dual_lo

!           /*   force multiplied by nbead   */
            call nm_trans_force_rehmc

!           /*   update the velocities by interatomic forces   */
            call update_vel_xyz_rehmc

!           /*   energy   */
            call getenergy_rehmc

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   get interatomic forces   */
         call getforce_dual_hi

!        /*   energy   */
         call getenergy_rehmc

!        /*   judge accept or reject: hmc   */
         call judge_hmc_rehmc

!        /*   judge accept or reject: rem   */
         call judge_rem_rehmc

!        /*   adjust HMC step   */
         call adjust_step_rehmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_rehmc_tx

!        /*   atom exchange   */
         call exchange_rehmc_dual

!        /*   do some analysis   */
         call analysis_rehmc( 2 )

!        /*   output restart   */
         call backup_rehmc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end
