!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     recover configuration in hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine recover_rehmc( i )
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, ux, uy, uz, vx, vy, vz, pot, fx, fy, fz, natom, mbox

      use rehmc_variables, only : &
     &   pot_save, x_save, y_save, z_save, ux_save, uy_save, uz_save, &
     &   vx_save, vy_save, vz_save, fx_save, fy_save, fz_save, &
     &   hamiltonian_bead_save, hamiltonian_bead, mbox_save

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      pot(i)                = pot_save(i)

      hamiltonian_bead(i)   = hamiltonian_bead_save(i)

      do j = 1, natom

         x(j,i)                = x_save(j,i)
         y(j,i)                = y_save(j,i)
         z(j,i)                = z_save(j,i)

         ux(j,i)               = ux_save(j,i)
         uy(j,i)               = uy_save(j,i)
         uz(j,i)               = uz_save(j,i)

         vx(j,i)               = vx_save(j,i)
         vy(j,i)               = vy_save(j,i)
         vz(j,i)               = vz_save(j,i)

         fx(j,i)               = fx_save(j,i)
         fy(j,i)               = fy_save(j,i)
         fz(j,i)               = fz_save(j,i)

      end do

      mbox(:,:,i)              = mbox_save(:,:,i)

      return
      end





!***********************************************************************
      subroutine recover_rex_rehmc( i )
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, vx, vy, vz, fx, fy, fz, ux, uy, uz, pot, natom, nbead, &
     &   mbox

      use rehmc_variables, only : &
     &   x_save, y_save, z_save, ux_save, uy_save, uz_save, &
     &   vx_save, vy_save, vz_save, fx_save, fy_save, fz_save, &
     &   hamiltonian_bead, hamiltonian_bead_save, pot_save, &
     &   fx_alchem_save, fy_alchem_save, fz_alchem_save, &
     &   pot_alchem_save, mbox_save

      use alchem_variables, only : &
     &   fx_alchem, fy_alchem, fz_alchem, pot_alchem

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      pot(i)                = pot_save(i)

      hamiltonian_bead(i)   = hamiltonian_bead_save(i)

      do j = 1, natom

         x(j,i)                = x_save(j,i)
         y(j,i)                = y_save(j,i)
         z(j,i)                = z_save(j,i)

         ux(j,i)               = ux_save(j,i)
         uy(j,i)               = uy_save(j,i)
         uz(j,i)               = uz_save(j,i)

         vx(j,i)               = vx_save(j,i)
         vy(j,i)               = vy_save(j,i)
         vz(j,i)               = vz_save(j,i)

         fx(j,i)               = fx_save(j,i)
         fy(j,i)               = fy_save(j,i)
         fz(j,i)               = fz_save(j,i)

      end do

      do j = 1, nbead

         pot_alchem(j,i)       = pot_alchem_save(j,i)

         do k = 1, natom

            fx_alchem(k,j,i)   = fx_alchem_save(k,j,i)
            fy_alchem(k,j,i)   = fy_alchem_save(k,j,i)
            fz_alchem(k,j,i)   = fz_alchem_save(k,j,i)

         end do

      end do

      mbox(:,:,i)              = mbox_save(:,:,i)

      return
      end





!***********************************************************************
      subroutine recover_rehmc_npt( i )
!***********************************************************************
!=======================================================================
!
!     save data before trial move
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, ux, uy, uz, vx, vy, vz, pot, fx, fy, fz, box_bead, &
     &   vbox_bead, vir_bead, boxinv_bead, volume_bead, natom, mbox

      use rehmc_variables, only : &
     &   pot_save, x_save, y_save, z_save, ux_save, uy_save, uz_save, &
     &   vx_save, vy_save, vz_save, fx_save, fy_save, fz_save, &
     &   hamiltonian_bead_save, hamiltonian_bead, box_bead_save, &
     &   boxinv_bead_save, volume_bead_save, vbox_bead_save, &
     &   vir_bead_save, mbox_save

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   save data                                                  */
!-----------------------------------------------------------------------

      pot(i)                = pot_save(i)

      hamiltonian_bead(i)   = hamiltonian_bead_save(i)

      do j = 1, natom

         x(j,i)                = x_save(j,i)
         y(j,i)                = y_save(j,i)
         z(j,i)                = z_save(j,i)

         ux(j,i)               = ux_save(j,i)
         uy(j,i)               = uy_save(j,i)
         uz(j,i)               = uz_save(j,i)

         vx(j,i)               = vx_save(j,i)
         vy(j,i)               = vy_save(j,i)
         vz(j,i)               = vz_save(j,i)

         fx(j,i)               = fx_save(j,i)
         fy(j,i)               = fy_save(j,i)
         fz(j,i)               = fz_save(j,i)

      end do

      mbox(:,:,i)              = mbox_save(:,:,i)

      box_bead(:,:,i)          = box_bead_save(:,:,i)
      boxinv_bead(:,:,i)       = boxinv_bead_save(:,:,i)
      volume_bead(i)           = volume_bead_save(i)
      vbox_bead(:,:,i)         = vbox_bead_save(:,:,i)
      vir_bead(:,:,i)          = vir_bead_save(:,:,i)

      return
      end





!***********************************************************************
      subroutine recover_remc( m )
!***********************************************************************
!-----------------------------------------------------------------------
!     //   shared variables
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, pot, fx, fy, fz, vir_bead, ipotential

      use rehmc_variables, only : &
     &   x_save, y_save, z_save, fx_save, fy_save, fz_save, pot_save, &
     &   vir_bead_save, pot_low_save

      use dual_variables, only : &
     &   pot_low

!-----------------------------------------------------------------------
!     //   local variables
!-----------------------------------------------------------------------

      implicit none

      integer :: m

!-----------------------------------------------------------------------
!     //   recover
!-----------------------------------------------------------------------

!     //   saved coordinates
      x(:,m) = x_save(:,m)
      y(:,m) = y_save(:,m)
      z(:,m) = z_save(:,m)

!     //   saved potential
      pot(m) = pot_save(m)

!     //   saved forces
      fx(:,m) = fx_save(:,m)
      fy(:,m) = fy_save(:,m)
      fz(:,m) = fz_save(:,m)

!     //   saved virial
      vir_bead(:,:,m) = vir_bead_save(:,:,m)

!-----------------------------------------------------------------------
!     //   for dual only
!-----------------------------------------------------------------------

      if ( ipotential(1:5) .eq. 'DUAL ' ) then

         pot_low(m) = pot_low_save(m)

      end if

      return
      end
