!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     recover configuration in hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine recover_fourth_hmc_nvt
!***********************************************************************
!=======================================================================
!
!     recover data before trial move
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, fux, fuy, fuz, pot, potential, &
     &   fux_ref, fuy_ref, fuz_ref, ekin, hamiltonian, qkin, mbox, &
     &   ipotential

!     /*   shared variables   */
      use hmc_variables, only : &
     &   ux_save, uy_save, uz_save, vux_save, vuy_save, vuz_save, &
     &   fux_save, fuy_save, fuz_save, fux_ref_save, fuy_ref_save, &
     &   fuz_ref_save, pot_save, pot_hmc_save, potential_save, &
     &   potential_hmc_save, potential_second_save, ekin_save, &
     &   qkin_save, hamiltonian_save, hamiltonian_hmc_save, pot_hmc, &
     &   pot_second, potential_hmc, potential_second, hamiltonian_hmc, &
     &   pot_second_save, potential_fourth_save, pot_fourth, &
     &   potential_fourth, pot_fourth_save, mbox_save

!     /*   shared variables   */
      use dual_variables, only : &
     &   potential_high, potential_low, potential_high_save, &
     &   potential_low_save

!-----------------------------------------------------------------------
!     /*   recover data                                               */
!-----------------------------------------------------------------------

      ux(:,:)          = ux_save(:,:)
      uy(:,:)          = uy_save(:,:)
      uz(:,:)          = uz_save(:,:)

      vux(:,:)         = vux_save(:,:)
      vuy(:,:)         = vuy_save(:,:)
      vuz(:,:)         = vuz_save(:,:)

      fux(:,:)         = fux_save(:,:)
      fuy(:,:)         = fuy_save(:,:)
      fuz(:,:)         = fuz_save(:,:)

      fux_ref(:,:)     = fux_ref_save(:,:)
      fuy_ref(:,:)     = fuy_ref_save(:,:)
      fuz_ref(:,:)     = fuz_ref_save(:,:)

      pot(:)           = pot_save(:)
      pot_hmc(:)       = pot_hmc_save(:)
      pot_second(:)    = pot_second_save(:)
      pot_fourth(:)    = pot_fourth_save(:)

      potential        = potential_save
      potential_hmc    = potential_hmc_save
      potential_second = potential_second_save
      potential_fourth = potential_fourth_save

      ekin             = ekin_save
      qkin             = qkin_save

      hamiltonian      = hamiltonian_save
      hamiltonian_hmc  = hamiltonian_hmc_save

      mbox(:,:,:)      = mbox_save(:,:,:)

      if ( ipotential(1:5) .eq. 'DUAL ' ) then
         potential_high   = potential_high_save
         potential_low    = potential_low_save
      end if

!-----------------------------------------------------------------------
!     /*   normal mode to cartesian                                   */
!-----------------------------------------------------------------------

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   normal mode velocity -> cartesian velocity   */
      call nm_trans_velocity( 0 )

!     /*   normal mode force -> cartesian force   */
      call nm_trans_force( 0 )

      return
      end





!***********************************************************************
      subroutine recover_fourth_hmc_npt
!***********************************************************************
!=======================================================================
!
!     recover data before trial move
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, fux, fuy, fuz, pot, potential, &
     &   fux_ref, fuy_ref, fuz_ref, ekin, hamiltonian, qkin, vvol, &
     &   vlog, vbox, box, vir, pres, pres_iso, boxinv, volume, mbox, &
     &   ipotential

!     /*   shared variables   */
      use hmc_variables, only : &
     &   ux_save, uy_save, uz_save, vux_save, vuy_save, vuz_save, &
     &   fux_save, fuy_save, fuz_save, fux_ref_save, fuy_ref_save, &
     &   fuz_ref_save, pot_save, pot_hmc_save, potential_save, &
     &   potential_hmc_save, potential_second_save, ekin_save, &
     &   qkin_save, hamiltonian_save, hamiltonian_hmc_save, pot_hmc, &
     &   pot_second, potential_hmc, potential_second, hamiltonian_hmc, &
     &   pot_second_save, vvol_save, vlog_save, vbox_save, box_save, &
     &   vir_save, pres_save, pres_iso_save, potential_fourth_save, &
     &   pot_fourth_save, potential_fourth, pot_fourth, mbox_save

!     /*   shared variables   */
      use dual_variables, only : &
     &   potential_high, potential_low, potential_high_save, &
     &   potential_low_save

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      real(8) :: det3

!-----------------------------------------------------------------------
!     /*   recover data                                               */
!-----------------------------------------------------------------------

      ux(:,:)          = ux_save(:,:)
      uy(:,:)          = uy_save(:,:)
      uz(:,:)          = uz_save(:,:)

      vux(:,:)         = vux_save(:,:)
      vuy(:,:)         = vuy_save(:,:)
      vuz(:,:)         = vuz_save(:,:)

      fux(:,:)         = fux_save(:,:)
      fuy(:,:)         = fuy_save(:,:)
      fuz(:,:)         = fuz_save(:,:)

      fux_ref(:,:)     = fux_ref_save(:,:)
      fuy_ref(:,:)     = fuy_ref_save(:,:)
      fuz_ref(:,:)     = fuz_ref_save(:,:)

      pot(:)           = pot_save(:)
      pot_hmc(:)       = pot_hmc_save(:)
      pot_second(:)    = pot_second_save(:)
      pot_fourth(:)    = pot_fourth_save(:)

      potential        = potential_save
      potential_hmc    = potential_hmc_save
      potential_second = potential_second_save
      potential_fourth = potential_fourth_save

      ekin             = ekin_save
      qkin             = qkin_save

      hamiltonian      = hamiltonian_save
      hamiltonian_hmc  = hamiltonian_hmc_save

      vvol             = vvol_save
      vlog             = vlog_save
      vbox(:,:)        = vbox_save(:,:)

      box(:,:)         = box_save(:,:)

      vir(:,:)         = vir_save(:,:)

      pres(:,:)        = pres_save(:,:)
      pres_iso         = pres_iso_save

      mbox(:,:,:)      = mbox_save(:,:,:)

      if ( ipotential(1:5) .eq. 'DUAL ' ) then
         potential_high   = potential_high_save
         potential_low    = potential_low_save
      end if

!-----------------------------------------------------------------------
!     /*   normal mode to cartesian                                   */
!-----------------------------------------------------------------------

!     /*   volume   */
      volume = det3( box )

!     /*   inverse matrix   */
      call inv3 ( box, boxinv )

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   normal mode velocity -> cartesian velocity   */
      call nm_trans_velocity( 0 )

!     /*   normal mode force -> cartesian force   */
      call nm_trans_force( 0 )

      return
      end





!***********************************************************************
      subroutine recover_fourth_hmc_ntt
!***********************************************************************
!=======================================================================
!
!     recover data before trial move
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   ux, uy, uz, vux, vuy, vuz, fux, fuy, fuz, pot, potential, &
     &   fux_ref, fuy_ref, fuz_ref, ekin, hamiltonian, qkin, volume, &
     &   vvol, vlog, vbox, box, vir, pres, pres_iso, strain, stress, &
     &   boxinv, mbox, ipotential

!     /*   shared variables   */
      use hmc_variables, only : &
     &   ux_save, uy_save, uz_save, vux_save, vuy_save, vuz_save, &
     &   fux_save, fuy_save, fuz_save, fux_ref_save, fuy_ref_save, &
     &   fuz_ref_save, pot_save, pot_hmc_save, potential_save, &
     &   potential_hmc_save, potential_second_save, ekin_save, &
     &   qkin_save, hamiltonian_save, hamiltonian_hmc_save, pot_hmc, &
     &   pot_second, potential_hmc, potential_second, hamiltonian_hmc, &
     &   pot_second_save, vvol_save, vlog_save, vbox_save, box_save, &
     &   vir_save, pres_save, pres_iso_save, strain_save, stress_save, &
     &   pot_fourth, potential_fourth, pot_fourth_save, &
     &   potential_fourth_save, mbox_save

!     /*   shared variables   */
      use dual_variables, only : &
     &   potential_high, potential_low, potential_high_save, &
     &   potential_low_save

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      real(8) :: det3

!-----------------------------------------------------------------------
!     /*   recover data                                               */
!-----------------------------------------------------------------------

      ux(:,:)          = ux_save(:,:)
      uy(:,:)          = uy_save(:,:)
      uz(:,:)          = uz_save(:,:)

      vux(:,:)         = vux_save(:,:)
      vuy(:,:)         = vuy_save(:,:)
      vuz(:,:)         = vuz_save(:,:)

      fux(:,:)         = fux_save(:,:)
      fuy(:,:)         = fuy_save(:,:)
      fuz(:,:)         = fuz_save(:,:)

      fux_ref(:,:)     = fux_ref_save(:,:)
      fuy_ref(:,:)     = fuy_ref_save(:,:)
      fuz_ref(:,:)     = fuz_ref_save(:,:)

      pot(:)           = pot_save(:)
      pot_hmc(:)       = pot_hmc_save(:)
      pot_second(:)    = pot_second_save(:)
      pot_fourth(:)    = pot_fourth_save(:)

      potential        = potential_save
      potential_hmc    = potential_hmc_save
      potential_second = potential_second_save
      potential_fourth = potential_fourth_save

      ekin             = ekin_save
      qkin             = qkin_save

      hamiltonian      = hamiltonian_save
      hamiltonian_hmc  = hamiltonian_hmc_save

      vvol             = vvol_save
      vlog             = vlog_save
      vbox(:,:)        = vbox_save(:,:)

      box(:,:)         = box_save(:,:)

      vir(:,:)         = vir_save(:,:)

      pres(:,:)        = pres_save(:,:)
      pres_iso         = pres_iso_save

      strain(:,:)      = strain_save(:,:)
      stress(:,:)      = stress_save(:,:)

      mbox(:,:,:)      = mbox_save(:,:,:)

      if ( ipotential(1:5) .eq. 'DUAL ' ) then
         potential_high   = potential_high_save
         potential_low    = potential_low_save
      end if

!-----------------------------------------------------------------------
!     /*   normal mode to cartesian                                   */
!-----------------------------------------------------------------------

!     /*   volume   */
      volume = det3( box )

!     /*   inverse matrix   */
      call inv3 ( box, boxinv )

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   normal mode velocity -> cartesian velocity   */
      call nm_trans_velocity( 0 )

!     /*   normal mode force -> cartesian force   */
      call nm_trans_force( 0 )

      return
      end

