!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     read input file in post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine read_char_calc ( char, length_char, char_tag, &
     &                            length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: length_tag, length_char, iounit, ierr

      character(len=length_tag) :: char_tag

      character(len=length_char) :: char

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) char

!     /*   file close   */
      close( iounit )

!     /*   on error, read default value   */
      if ( ierr .ne. 0 ) then
         call default_char_calc ( char, length_char, char_tag, &
     &                            length_tag, iounit )
      end if

      return
      end





!***********************************************************************
      subroutine read_int1_calc ( k, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: k, length_tag, iounit, ierr

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) k

!     /*   file close   */
      close( iounit )

!     /*   on error, read default value   */
      if ( ierr .ne. 0 ) then
         call default_int1_calc ( k, char_tag, length_tag, iounit )
      end if

      return
      end





!***********************************************************************
      subroutine read_real1_calc ( a, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: length_tag, iounit, ierr

      real(8):: a

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) a

!     /*   file close   */
      close( iounit )

!     /*   on error, read default value   */
      if ( ierr .ne. 0 ) then
         call default_real1_calc ( a, char_tag, length_tag, iounit )
      end if

      return
      end





!***********************************************************************
      subroutine read_intn_calc ( k, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, length_tag, iounit, ierr, j

      integer:: k(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) ( k(j), j = 1, n )

!     /*   file close   */
      close( iounit )

!     /*   on error, read default value   */
      if ( ierr .ne. 0 ) then
         call default_intn_calc ( k, n, char_tag, length_tag, iounit )
      end if

      return
      end





!***********************************************************************
      subroutine read_realn_calc ( a, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, length_tag, iounit, ierr, j

      real(8):: a(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) ( a(j), j = 1, n )

!     /*   file close   */
      close( iounit )

!     /*   on error, read default value   */
      if ( ierr .ne. 0 ) then
         call default_realn_calc ( a, n, char_tag, length_tag, iounit )
      end if

      return
      end





!***********************************************************************
      subroutine default_char_calc ( char, length_char, char_tag, &
     &                               length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: length_tag, length_char, iounit, ierr

      character(len=length_tag) :: char_tag

      character(len=length_char) :: char

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc_default.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) char

!     /*   stop if error is found   */
      call error_handling_calc( ierr, char_tag, length_tag )

!     /*   file close   */
      close( iounit )

      return
      end





!***********************************************************************
      subroutine default_int1_calc ( k, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: k, length_tag, iounit, ierr

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc_default.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) k

!     /*   stop if error is found   */
      call error_handling_calc( ierr, char_tag, length_tag )

!     /*   file close   */
      close( iounit )

      return
      end





!***********************************************************************
      subroutine default_real1_calc ( a, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: length_tag, iounit, ierr

      real(8):: a

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc_default.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) a

!     /*   stop if error is found   */
      call error_handling_calc( ierr, char_tag, length_tag )

!     /*   file close   */
      close( iounit )

      return
      end





!***********************************************************************
      subroutine default_intn_calc( k, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, length_tag, iounit, ierr, j

      integer:: k(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc_default.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) ( k(j), j = 1, n )

!     /*   stop if error is found   */
      call error_handling_calc( ierr, char_tag, length_tag )

!     /*   file close   */
      close( iounit )

      return
      end





!***********************************************************************
      subroutine default_realn_calc &
     &   ( a, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, length_tag, iounit, ierr, j

      real(8):: a(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'calc_default.dat' )

!     /*   search for tag    */
      call search_tag ( char_tag, length_tag, iounit, ierr )

!     /*   read integers   */
      read ( iounit, *, iostat=ierr ) ( a(j), j = 1, n )

!     /*   stop if error is found   */
      call error_handling_calc( ierr, char_tag, length_tag )

!     /*   file close   */
      close( iounit )

      return
      end
