!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     read input file
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine read_char_MPI ( char, length_char, char_tag, &
     &                           length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: length_tag, length_char, iounit, ierr

      character(len=length_tag) :: char_tag

      character(len=length_char) :: char

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) char

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )

!-----------------------------------------------------------------------
!     /*   on error, read default value                               */
!-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         call default_char_MPI ( char, length_char, char_tag, &
     &                           length_tag, iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_char_0_world ( char, length_char )

      return
      end





!***********************************************************************
      subroutine read_int1_MPI ( k, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: k, length_tag, iounit, ierr

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) k

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )

!-----------------------------------------------------------------------
!     /*   on error, read default value                               */
!-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         call default_int1_MPI ( k, char_tag, length_tag, iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( k )

      return
      end





!***********************************************************************
      subroutine read_real1_MPI ( a, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: length_tag, iounit, ierr

      real(8):: a

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) a

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )

!-----------------------------------------------------------------------
!     /*   on error, read default value                               */
!-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         call default_real1_MPI ( a, char_tag, length_tag, iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_0_world ( a )

      return
      end





!***********************************************************************
      subroutine read_intn_MPI ( k, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

      implicit none

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      integer:: n, length_tag, iounit, ierr, j

      integer:: k(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) ( k(j), j = 1, n )

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )

!-----------------------------------------------------------------------
!     /*   on error, read default value                               */
!-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         call default_intn_MPI ( k, n, char_tag, length_tag, iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_1_world ( k, n )

      return
      end





!***********************************************************************
      subroutine read_realn_MPI ( a, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, length_tag, iounit, ierr, j

      real(8):: a(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) ( a(j), j = 1, n )

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )

!-----------------------------------------------------------------------
!     /*   on error, read default value                               */
!-----------------------------------------------------------------------

      if ( ierr .ne. 0 ) then

         call default_realn_MPI ( a, n, char_tag, length_tag, iounit )

      end if

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_1_world ( a, n )

      return
      end





!***********************************************************************
      subroutine default_char_MPI ( char, length_char, char_tag, &
     &                              length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: length_tag, length_char, iounit, ierr

      character(len=length_tag) :: char_tag

      character(len=length_char) :: char

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input_default.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) char

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )
      call error_handling_MPI ( ierr, char_tag, length_tag )

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_char_0_world ( char, length_char )

      return
      end





!***********************************************************************
      subroutine default_int1_MPI ( k, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: k, length_tag, iounit, ierr

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input_default.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) k

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )
      call error_handling_MPI ( ierr, char_tag, length_tag )

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( k )

      return
      end





!***********************************************************************
      subroutine default_real1_MPI ( a, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: length_tag, iounit, ierr

      real(8):: a

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input_default.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) a

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )
      call error_handling_MPI ( ierr, char_tag, length_tag )

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_0_world ( a )

      return
      end





!***********************************************************************
      subroutine default_intn_MPI ( k, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, length_tag, iounit, ierr, j

      integer:: k(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input_default.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) ( k(j), j = 1, n )

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )
      call error_handling_MPI ( ierr, char_tag, length_tag )

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_1_world ( k, n )

      return
      end





!***********************************************************************
      subroutine default_realn_MPI( a, n, char_tag, length_tag, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  myrank_world

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer:: n, length_tag, iounit, ierr, j

      real(8):: a(n)

      character(len=length_tag) :: char_tag

!-----------------------------------------------------------------------
!     /*   read values                                                */
!-----------------------------------------------------------------------

      if ( myrank_world .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input_default.dat' )

!        /*   search for tag    */
         call search_tag ( char_tag, length_tag, iounit, ierr )

!        /*   read integers   */
         read ( iounit, *, iostat=ierr ) ( a(j), j = 1, n )

!        /*   file close   */
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call my_mpi_bcast_int_0_world ( ierr )
      call error_handling_MPI ( ierr, char_tag, length_tag )

!-----------------------------------------------------------------------
!     /*   communication                                              */
!-----------------------------------------------------------------------

      call my_mpi_bcast_real_1_world ( a, n )

      return
      end
