!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     read thermodynamic tension
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine read_tension_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   tension, au_energy, au_length, boxinv_ref, sigma_ref, iounit, &
     &   myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr, i, j, k, l

!-----------------------------------------------------------------------
!     /*   new version                                                */
!-----------------------------------------------------------------------

      ierr = 0

      if ( myrank .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( '<tension>', 9, iounit, ierr )

!     /*   read tension   */
         read ( iounit, *, iostat=ierr ) &
     &      tension(1,1), tension(1,2), tension(1,3)
         read ( iounit, *, iostat=ierr ) &
     &      tension(2,1), tension(2,2), tension(2,3)
         read ( iounit, *, iostat=ierr ) &
     &      tension(3,1), tension(3,2), tension(3,3)

!        /*   file close   */
         close( iounit )

         if ( ierr .ne. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'input_default.dat' )

!           /*   search for tag    */
            call search_tag ( '<tension>', 9, iounit, ierr )

!           /*   read tension   */
            read ( iounit, *, iostat=ierr ) &
     &         tension(1,1), tension(1,2), tension(1,3)
            read ( iounit, *, iostat=ierr ) &
     &         tension(2,1), tension(2,2), tension(2,3)
            read ( iounit, *, iostat=ierr ) &
     &         tension(3,1), tension(3,2), tension(3,3)

!           /*   file close   */
            close( iounit )

         end if

!        /*   [mpa] -> [a.u.]   */
         tension(:,:) = tension(:,:) / (au_energy/au_length**3/10**6)

      end if

!     /*   error handling   */
      call error_handling_MPI( ierr, 'subroutine read_tension_MPI', 27 )

      call my_mpi_bcast_real_2 ( tension, 3, 3 )

!-----------------------------------------------------------------------
!     /*   sigma matrix                                               */
!-----------------------------------------------------------------------

      sigma_ref(:,:) = 0.d0

      do l = 1, 3
      do k = 1, 3
      do j = 1, 3
      do i = 1, 3
         sigma_ref(i,j) = sigma_ref(i,j) &
     &                  - boxinv_ref(i,k)*tension(k,l)*boxinv_ref(j,l)
      end do
      end do
      end do
      end do

      return
      end
