!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     read starting condition
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine read_start_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   irot_start, itrans_start, istep_start, ipos_start, &
     &   ivel_start, ibath_start, ibox_start, iounit, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr, itest

!-----------------------------------------------------------------------
!     /*                                                              */
!     /*   read two integers after the tag `<corrections>'            */
!     /*                                                              */
!     /*   itrans_start =  0 ... no translational correction          */
!     /*                =  1 ... subtract at initial step             */
!     /*                =  2 ... correct each time step               */
!     /*   irot_start   =  0 ... no rotational correction             */
!     /*                =  1 ... subtract at initial step             */
!     /*                =  2 ... correct each time step               */
!     /*                                                              */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input.dat' )

!        /*   search for tag    */
         call search_tag ( '<corrections>', 13, iounit, ierr )

!        /*   read integer   */
         read ( iounit, *, iostat=ierr ) itrans_start, irot_start

!        /*   file close   */
         close ( iounit )

         if ( ierr .ne. 0 ) then

!           /*   file open   */
            open ( iounit, file = 'input_default.dat' )

!           /*   search for tag    */
            call search_tag ( '<corrections>', 13, iounit, ierr )

!           /*   read integer   */
            read ( iounit, *, iostat=ierr ) itrans_start, irot_start

!           /*   file close   */
            close ( iounit )

         end if

      end if

      call my_mpi_bcast_int_0 ( itrans_start )
      call my_mpi_bcast_int_0 ( irot_start )

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  default                       */
!-----------------------------------------------------------------------

!     /*   default:  step number is 0.                                */
      istep_start  =  0
!     /*   default:  read centroid.dat and create bead conformation   */
      ipos_start   =  0
!     /*   default:  new velocities with random numbers               */
      ivel_start   =  0
!     /*   default:  new bath values with random numbers              */
      ibath_start  =  0
!     /*   default:  read box from input.dat                          */
      ibox_start   =  0

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  step                          */
!-----------------------------------------------------------------------

!     /*   check if file called `step.ini' exists   */
      if ( myrank .eq. 0 ) call testfile( 'step.ini', 8, itest )

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( itest )

!     /*   if the file exists,   */
      if ( itest .eq. 0 ) then

         if ( myrank .eq. 0 ) then

!            /*   open that file, read the step number for restart   */
             open ( iounit, file = 'step.ini' )
                read ( iounit, * ) istep_start
             close( iounit )

          end if

!        /*   mpi communication   */
         call my_mpi_bcast_int_0 ( istep_start )

      end if

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  geometry                      */
!-----------------------------------------------------------------------

!     /*   check if file called `geometry.ini' exists   */
      if ( myrank .eq. 0 ) then
         call testfile( 'geometry.ini', 12, itest )
      end if

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( itest )

!     /*   if the file exists, restart    */
      if ( itest .eq. 0 )  ipos_start = 1
      if ( itest .eq. 0 )  ivel_start = 1

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( ipos_start )
      call my_mpi_bcast_int_0 ( ivel_start )

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  string                        */
!-----------------------------------------------------------------------

!     /*   check if file called `string.ini' exists   */
      if ( myrank .eq. 0 ) then
         call testfile( 'string.ini', 10, itest )
      end if

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( itest )

!     /*   if `geometry.ini' does not exist   */
      if ( ipos_start .eq. 0 ) then

!        /*   and if `string.ini' exists, restart    */
         if ( itest .eq. 0 )  ipos_start = 3
         if ( itest .eq. 0 )  ivel_start = 3

!     /*   if `geometry.ini' does not exist   */
      end if

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( ipos_start )
      call my_mpi_bcast_int_0 ( ivel_start )

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  bath                          */
!-----------------------------------------------------------------------

!     /*   check if file called `bath.ini' exists   */
      if ( myrank .eq. 0 ) call testfile( 'bath.ini', 8, itest )

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( itest )

!     /*   if the file exists, restart    */
      if ( itest .eq. 0 )  ibath_start = 1

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( ibath_start )
      call my_mpi_bcast_int_0 ( ibath_start )

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  box                           */
!-----------------------------------------------------------------------

!     /*   check if file called `box.ini' exists   */
      if ( myrank .eq. 0 ) call testfile( 'box.ini', 7, itest )

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( itest )

!     /*   if the file exists, restart    */
      if ( itest .eq. 0 )  ibox_start = 1

!     /*   mpi communication   */
      call my_mpi_bcast_int_0 ( ibox_start )
      call my_mpi_bcast_int_0 ( ibox_start )

      return
      end

