!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     read starting condition
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine read_start
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   irot_start, itrans_start, istep_start, ipos_start, &
     &   ivel_start, ibath_start, ibox_start, iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr, itest

!-----------------------------------------------------------------------
!     /*                                                              */
!     /*   read two integers after the tag `<corrections>'            */
!     /*                                                              */
!     /*   itrans_start =  0 ... no translational correction          */
!     /*                =  1 ... subtract at initial step             */
!     /*                =  2 ... correct each time step               */
!     /*   irot_start   =  0 ... no rotational correction             */
!     /*                =  1 ... subtract at initial step             */
!     /*                =  2 ... correct each time step               */
!     /*                                                              */
!-----------------------------------------------------------------------

!     /*   file open   */
      open ( iounit, file = 'input.dat' )

!     /*   search for tag    */
      call search_tag ( '<corrections>', 13, iounit, ierr )

!     /*   read integer   */
      read ( iounit, *, iostat=ierr )  itrans_start, irot_start

      close ( iounit )

      if ( ierr .ne. 0 ) then

!        /*   file open   */
         open ( iounit, file = 'input_default.dat' )

!        /*   search for tag    */
         call search_tag ( '<corrections>', 13, iounit, ierr )

!        /*   read integer   */
         read ( iounit, *, iostat=ierr )  itrans_start, irot_start

         close ( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  default                       */
!-----------------------------------------------------------------------

!     /*   default:  step number is 0.                                */
      istep_start  =  0
!     /*   default:  read centroid.dat and create bead conformation   */
      ipos_start   =  0
!     /*   default:  new velocities with random numbers               */
      ivel_start   =  0
!     /*   default:  new bath values with random numbers              */
      ibath_start  =  0
!     /*   default:  read box from input.dat                          */
      ibox_start   =  0

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  step                          */
!-----------------------------------------------------------------------

!     /*   check if file called `step.ini' exists   */
      call testfile ( 'step.ini', 8, itest, iounit )

!     /*   if the file exists,   */
      if ( itest .eq. 0 ) then

!        /*   open that file, read the step number for restart   */
         open ( iounit, file = 'step.ini' )
            read ( iounit, * ) istep_start
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  geometry                      */
!-----------------------------------------------------------------------

!     /*   check if file called `geometry.ini' exists   */
      call testfile ( 'geometry.ini', 12, itest, iounit )

!     /*   if the file exists, restart    */
      if ( itest .eq. 0 )  ipos_start = 1
      if ( itest .eq. 0 )  ivel_start = 1

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  string                        */
!-----------------------------------------------------------------------

!     /*   check if file called `string.ini' exists   */
      call testfile ( 'string.ini', 10, itest, iounit )

!     /*   if `geometry.ini' does not exist   */
      if ( ipos_start .eq. 0 ) then

!        /*   and if `string.ini' exists, restart    */
         if ( itest .eq. 0 )  ipos_start = 3
         if ( itest .eq. 0 )  ivel_start = 3

!     /*   if `geometry.ini' does not exist   */
      end if

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  bath                          */
!-----------------------------------------------------------------------

!     /*   check if file called `bath.ini' exists   */
      call testfile ( 'bath.ini', 8, itest, iounit )

!     /*   if the file exists, restart    */
      if ( itest .eq. 0 )  ibath_start = 1

!-----------------------------------------------------------------------
!     /*   initial/restart conditions:  box                           */
!-----------------------------------------------------------------------

!     /*   check if file called `box.ini' exists   */
      call testfile ( 'box.ini', 7, itest, iounit )

!     /*   if the file exists, restart    */
      if ( itest .eq. 0 )  ibox_start = 1

      return
      end

