!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 3, 2026 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine my_random_seed_XMPI( myrank )
!***********************************************************************

!     //   initialize
      implicit none

!     //   set local variables
      integer, intent(in) :: myrank
      integer, dimension(:), allocatable :: jseed
      integer :: i, jseedsize, jclock

!     //   initialize seed
      call random_seed( size=jseedsize )

!     //   memory allocation of seed
      if ( .not. allocated(jseed) ) allocate( jseed(jseedsize) )

!     //   generate seed using system clock
      call system_clock( jclock )

!     //   give seed unique to each process
      do i = 1, jseedsize
         jseed(i) = abs( jclock + 104729*myrank + 7919*i )
      end do

!     //   set seed
      call random_seed( put=jseed )

!     //   memory deallocation
      if ( allocated(jseed) ) deallocate( jseed )

      return
      end





!***********************************************************************
      real(8) function gasdev_XMPI()
!***********************************************************************
!=======================================================================
!
!     generate normal distribution.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: fac, rsq, v1, v2, ranf0

      real(8), save :: gset = 0.d0

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         do

            call random_number( ranf0 )
            v1  = 2.d0*ranf0 - 1.d0

            call random_number( ranf0 )
            v2  = 2.d0*ranf0 - 1.d0

            rsq = v1*v1 + v2*v2

            if ( (rsq .gt. 0.d0) .and. (rsq .le. 1.d0) ) exit

         end do

         fac    = sqrt(-2.d0*log(rsq)/rsq)

         gset        = v1*fac
         gasdev_XMPI = v2*fac

         iset = 1

      else

         gasdev_XMPI = gset

         iset = 0

      end if

      return
      end
