!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 3, 2026 by M. Shiga
!      Description:     random numbers
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      real(8) function ranf1()
!***********************************************************************
!=======================================================================
!
!     generate uniform distribution.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only:  irandom, iounit, iseed

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ierr

      integer, parameter :: l = 1029, a = 221591, m = 1048576

      integer, save :: iset = 0

      integer :: jseedsize, k, jclock

      integer, allocatable :: jseed(:)

!-----------------------------------------------------------------------
!     //   initialization (called once)
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         open ( iounit, file = 'input.dat', status='old', iostat=ierr )

         if ( ierr .eq. 0 ) then

            call search_tag ( '<irandom>', 9, iounit, ierr )

            read ( iounit, *, iostat=ierr ) irandom

            close( iounit )

         end if

         if ( ierr .ne. 0 ) then

            open ( iounit, file = 'input_default.dat', status='old' )

            call search_tag ( '<irandom>', 9, iounit, ierr )

            read ( iounit, *, iostat=ierr ) irandom

            close( iounit )

         end if

         if ( irandom .eq. 0 ) then

            iseed = 1

         else

            call random_seed(size=jseedsize)

            allocate( jseed(jseedsize) )

            call system_clock( jclock )

            do k = 1, jseedsize
               jseed(k) = jclock + 7919*k
            end do

            call random_seed(put=jseed)

            deallocate(jseed)

         end if

         iset = 1

      end if

!-----------------------------------------------------------------------
!     random number generation
!-----------------------------------------------------------------------

      if ( irandom .eq. 0 ) then

         iseed = mod(iseed*l + a, m)

         ranf1 = dble(iseed) / dble(m)

      else

         call random_number( ranf1 )

      end if

      return
      end





!***********************************************************************
      real(8) function gasdev()
!***********************************************************************
!=======================================================================
!
!     generate normal distribution.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: fac, rsq, v1, v2, ranf1

      real(8), save :: gset = 0.d0

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         do

            v1  = 2.d0*ranf1() - 1.d0
            v2  = 2.d0*ranf1() - 1.d0

            rsq = v1*v1 + v2*v2

            if ( (rsq .gt. 0.d0) .and. (rsq .le. 1.d0) ) exit

         end do

         fac    = sqrt(-2.d0*log(rsq)/rsq)

         gset   = v1*fac
         gasdev = v2*fac

         iset = 1

      else

         gasdev = gset

         iset = 0

      end if

      return
      end
