!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     project out translation in phonon calculations
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine project_out_phonon
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only: hessian, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integers  */
      integer :: i, j, k

!     /*   real numbers   */
      real(8), dimension(:,:), allocatable :: p
      real(8), dimension(:,:), allocatable :: f
      real(8), dimension(:),   allocatable :: a
      real(8), dimension(:,:), allocatable :: h3

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      if ( .not. allocated( p ) ) &
     &   allocate( p(3*natom,3*natom) )
      if ( .not. allocated( f ) ) &
     &   allocate( f(3*natom,3*natom) )
      if ( .not. allocated( a ) ) &
     &   allocate( a(3*natom) )
      if ( .not. allocated( h3 ) ) &
     &   allocate( h3(3*natom,3) )

!-----------------------------------------------------------------------
!     /*   projection preset to unit matrix                           */
!-----------------------------------------------------------------------

      p(:,:) = 0.d0

      do i = 1, 3*natom
         p(i,i) = 1.d0
      end do

!-----------------------------------------------------------------------
!     /*   translational contribution                                 */
!-----------------------------------------------------------------------

      do k = 1, 3

         a(:) = 0.d0

         do i = k, 3*natom, 3
            a(i) = 1.d0/sqrt(dble(natom))
         end do

         h3(:,k) = a(:)

      end do

!-----------------------------------------------------------------------
!     /*   no rotational contribution                                 */
!-----------------------------------------------------------------------

!     /*   orthogonalize   */

      call gram_schmidt ( h3, 3*natom, 3 )

!     /*   projection matrix   */

      do j = 1, 3*natom
      do i = 1, 3*natom
      do k = 1, 3
         p(i,j) = p(i,j) - h3(i,k)*h3(j,k)
      end do
      end do
      end do

!-----------------------------------------------------------------------
!     /*   correct hessian                                            */
!-----------------------------------------------------------------------

      do j = 1, 3*natom
      do i = 1, 3*natom

         f(i,j) = 0.d0

         do k = 1, 3*natom
            f(i,j) = f(i,j) + p(k,i)*hessian(k,j,1)
         end do

      end do
      end do

      do j = 1, 3*natom
      do i = 1, 3*natom

         hessian(i,j,1) = 0.d0

         do k = 1, 3*natom
            hessian(i,j,1) = hessian(i,j,1) + f(i,k)*p(k,j)
         end do

      end do
      end do

      return
      end
