!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Feb 1, 2025 by M. Shiga
!      Description:     print titles
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine print_titles_MPI
!***********************************************************************

      use common_variables, only : myrank_world

      implicit none

      if ( myrank_world .ne. 0 ) return

      write(6,'(a)')

      write(6,'(a)') &
     &   '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++' &
     &   // '++++++++++++++++++'
      write(6,'(a)')

      write(6,'(a)') &
     &   'PIMD version 2.7.1'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Author:        M. Shiga'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Last Updated:  Jan 8, 2026.'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Copyright(C) 2016-2026  M. Shiga  All rights reserved.'
      write(6,'(a)')

      write(6,'(a)') &
     &   'Licensed under the Apache License, Version 2.0' // &
     &   ' (the "License");'
      write(6,'(a)') &
     &   'you may not use this file except in compliance' // &
     &   ' with the License.'
      write(6,'(a)') &
     &   'You may obtain a copy of the License at'
      write(6,'(a)') &
     &   ''
      write(6,'(a)') &
     &   'http://www.apache.org/licenses/LICENSE-2.0'
      write(6,'(a)') &
     &   ''
      write(6,'(a)') &
     &   'Unless required by applicable law or agreed to in' // &
     &   ' writing, software'
      write(6,'(a)') &
     &   'distributed under the License is distributed on an' // &
     &   ' "AS IS" BASIS,'
      write(6,'(a)') &
     &   'WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either' // &
     &   ' express or implied.'
      write(6,'(a)') &
     &   'See the License for the specific language governing' // &
     &   ' permissions and'
      write(6,'(a)') &
     &   'limitations under the License.'
      write(6,'(a)')

      write(6,'(a)') &
     &   '++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++' &
     &   // '++++++++++++++++++'
      write(6,'(a)')

      return
      end





!***********************************************************************
      subroutine print_subtitles_MPI
!***********************************************************************

      use common_variables, only : &
     &   method, ipotential, ensemble, bath_type, temperature, &
     &   au_length, au_energy, au_mass, amu_mass, pressure, &
     &   physmass_spec, num_spec, mspec, spec, natom_spec, afed_type, &
     &   ipos_start, ivel_start, ibox_start, ibath_start, iorder_hmc, &
     &   npt_type, nph_type, ntt_type, nth_type, irem_type, natom, &
     &   iboundary, ends_string, equation_om, nbead, input_style, &
     &   tamd_type, logmfd_type, qmmm_potential, qmmm_embedding, &
     &   oniom_hi_potential, oniom_lo_potential, myrank_world

      use rehmc_variables, only : temperature_bead

      implicit none

      integer :: i
      real(8) :: pm

!-----------------------------------------------------------------------

      if ( myrank_world .ne. 0 ) return

!-----------------------------------------------------------------------

      if      ( method(1:7) .eq. 'STATIC ' ) then
         write( 6, '(a)' ) 'Method:   static.'
         write( 6, '(a)' )
      else if ( method(1:10) .eq. 'TESTFORCE ' ) then
         write( 6, '(a)' ) 'Method:   test forces.'
         write( 6, '(a)' )
      else if ( method(1:11) .eq. 'TESTVIRIAL ' ) then
         write( 6, '(a)' ) 'Method:   test virial.'
         write( 6, '(a)' )
      else if ( method(1:10) .eq. 'TESTEWALD ' ) then
         write( 6, '(a)' ) 'Method:   test ewald sum.'
         write( 6, '(a)' )
      else if ( method(1:10) .eq. 'TESTEWPOL ' ) then
         write( 6, '(a)' ) 'Method:   test ewald dipole sum.'
         write( 6, '(a)' )
      else if ( method(1:10) .eq. 'TESTOM ' ) then
         write( 6, '(a)' ) 'Method:   test OM forces.'
         write( 6, '(a)' )
      else if ( method(1:7) .eq. 'GEOOPT ' ) then
         write( 6, '(a)' ) 'Method:   geometry optimization.'
         write( 6, '(a)' )
         call titles_lbfgs
      else if ( method(1:4) .eq. 'NMA ' ) then
         write( 6, '(a)' ) 'Method:   normal mode analysis.'
         write( 6, '(a)' )
      else if ( method(1:7) .eq. 'PHONON ' ) then
         write( 6, '(a)' ) 'Method:   phonon calculation.'
         write( 6, '(a)' )
      else if ( method(1:3) .eq. 'SD ' ) then
         write( 6, '(a)' ) 'Method:   steepest decent.'
         write( 6, '(a)' )
      else if ( method(1:7) .eq. 'BOXOPT ' ) then
         write( 6, '(a)' ) 'Method:   box optimization.'
         write( 6, '(a)' )
      else if ( method(1:8) .eq. 'FULLOPT ' ) then
         write( 6, '(a)' ) 'Method:   full optimization.'
         write( 6, '(a)' )
      else if ( method(1:8) .eq. 'ELASTIC ' ) then
         write( 6, '(a)' ) 'Method:   elastic constants.'
         write( 6, '(a)' )
      else if ( method(1:3) .eq. 'MD ' ) then
         write( 6, '(a)' ) 'Method:   classical MD.'
         write( 6, '(a)' )
      else if ( method(1:5) .eq. 'PIMD ' ) then
         write( 6, '(a)' ) 'Method:   path integral MD.'
         write( 6, '(a)' )
      else if ( method(1:6) .eq. 'PIHMC ' ) then
         write( 6, '(a)' ) 'Method:   path integral HMC.'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'CMD ' ) then
         write( 6, '(a)' ) 'Method:   centroid MD.'
         write( 6, '(a)' )
      else if ( method(1:5) .eq. 'RPMD ' ) then
         write( 6, '(a)' ) 'Method:   ring polymer MD.'
         write( 6, '(a)' )
      else if ( method(1:6) .eq. 'TRPMD ' ) then
         write( 6, '(a)' ) 'Method:   thermostatted ring polymer MD.'
         write( 6, '(a)' )
      else if ( method(1:5) .eq. 'BCMD ' ) then
         write( 6, '(a)' ) 'Method:   path integral brownian chain MD.'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'MTD ' ) then
         write( 6, '(a)' ) 'Method:   metadynamics.'
         write( 6, '(a)' )
      else if ( method(1:5) .eq. 'TASS ' ) then
         write( 6, '(a)' ) 'Method:   temperature accelerated ' // &
     &                     'sliced sampling (beta version).'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'DVR ' ) then
         write( 6, '(a)' ) 'Method:   discrete variable representation.'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'MTS ' ) then
         write( 6, '(a)' ) 'Method:   multiple time scale PIMD.'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'TFS ' ) then
         write( 6, '(a)' ) 'Method:   Tully surface hopping MD.'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'MFE ' ) then
         write( 6, '(a)' ) 'Method:   Ehrenfest mean field MD.'
         write( 6, '(a)' )
      else if ( method(1:6) .eq. 'RPTFS ' ) then
         write( 6, '(a)' ) 'Method:   ring polymer surface hopping MD.'
         write( 6, '(a)' )
      else if ( method(1:6) .eq. 'RPMFE ' ) then
         write( 6, '(a)' ) 'Method:   ring polymer Ehrenfest MD.'
         write( 6, '(a)' )
      else if ( method(1:5) .eq. 'AFED ' ) then
         write( 6, '(a)' ) 'Method:   adiabatic free energy dynamics.'
         write( 6, '(a)' )
         call titles_afed
      else if ( method(1:5) .eq. 'SCAN ' ) then
         write( 6, '(a)' ) 'Method:   scan.'
         write( 6, '(a)' )
      else if ( method(1:6) .eq. 'REHMC ' ) then
         write( 6, '(a)' ) 'Method:   replica exchange HMC.'
         write( 6, '(a)' )
      else if ( method(1:5) .eq. 'REMC ' ) then
         write( 6, '(a)' ) 'Method:   replica exchange MC.'
         write( 6, '(a)' )
      else if ( method(1:7) .eq. 'STRING ' ) then
         write( 6, '(a)' ) 'Method:   string method.'
         write( 6, '(a)' )
      else if ( method(1:6) .eq. 'OMOPT ' ) then
         write( 6, '(a)' ) 'Method:   optimization of OM action.'
         write( 6, '(a)' )
!      else if ( method(1:3) .eq. 'OM ' ) then
!         write( 6, '(a)' ) 'Method:   OM dynamics.'
!         write( 6, '(a)' )
      else if ( method(1:6) .eq. 'ROTOR ' ) then
         write( 6, '(a)' ) 'Method:   MD of rigid molecules.'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'TPS ' ) then
         write( 6, '(a)' ) 'Method:   Transition path ensemble.'
         write( 6, '(a)' )
      else if ( method(1:4) .eq. 'GAD ' ) then
         write( 6, '(a)' ) 'Method:   gentlest ascent dynamics.'
         write( 6, '(a)' )
         call titles_gad
      else if ( method(1:4) .eq. 'HSS ' ) then
         write( 6, '(a)' ) 'Method:   hypersphere search.'
         write( 6, '(a)' )
      else if ( method(1:5) .eq. 'SCAN ' ) then
         write( 6, '(a)' ) 'Method:   Scan.'
         write( 6, '(a)' )
      else if ( method(1:8) .eq. 'PIMD-1D ' ) then
         write( 6, '(a)' ) 'Method:   1D path integral MD.'
         write( 6, '(a)' )
      else if ( method(1:7) .eq. 'HMC-1D ' ) then
         write( 6, '(a)' ) 'Method:   1D path integral HMC.'
         write( 6, '(a)' )
      else if ( method(1:8) .eq. 'BCMD-1D ' ) then
         write( 6, '(a)' ) 'Method:   1D Brownian chain MD.'
         write( 6, '(a)' )
      else if ( method(1:8) .eq. 'RPMD-1D ' ) then
         write( 6, '(a)' ) 'Method:   1D ring polymer MD.'
         write( 6, '(a)' )
      else if ( method(1:9) .eq. 'TRPMD-1D ' ) then
         write( 6, '(a)' ) 'Method:   1D thermostatted ring polymer MD.'
         write( 6, '(a)' )
      else if ( method(1:7) .eq. 'CMD-1D ' ) then
         write( 6, '(a)' ) 'Method:   1D centroid MD.'
         write( 6, '(a)' )
      else if ( method(1:13) .eq. 'MATSUBARA-1D ' ) then
         write( 6, '(a)' ) 'Method:   1D Matsubara dynamics.'
         write( 6, '(a)' )
      else
         write( 6, '(a)' ) 'Method:   ??'
         write( 6, '(a)' )
      end if

!-----------------------------------------------------------------------

      if ( method(1:5) .eq. 'AFED ' ) then
         if ( afed_type(1:5) .eq. 'GRAD '    ) then
            write( 6, '(a)' ) 'Type:     free energy gradient.'
            write( 6, '(a)' )
         end if
         if ( afed_type(1:8) .eq. 'HESSIAN '    ) then
            write( 6, '(a)' ) 'Type:     free energy hessian.'
            write( 6, '(a)' )
         end if
         if ( afed_type(1:5) .eq. 'TEST '    ) then
            write( 6, '(a)' ) 'Type:     test convergence.'
            write( 6, '(a)' )
         end if
         if ( afed_type(1:8) .eq. 'DESCENT ' ) then
            write( 6, '(a)' ) 'Type:     descent search.'
            write( 6, '(a)' )
         end if
         if ( afed_type(1:7) .eq. 'ASCENT '  ) then
            write( 6, '(a)' ) 'Type:     ascent search.'
            write( 6, '(a)' )
         end if
         if ( afed_type(1:5) .eq. 'AUTO '    ) then
            write( 6, '(a)' ) 'Type:     automated search.'
            write( 6, '(a)' )
         end if
         if ( afed_type(1:5) .eq. 'TAMD '    ) then
            if      ( tamd_type(1:4) .eq. 'NVE ' ) then
               write( 6, '(a)' ) &
     &            'Type:     temperature accelerated MD, NVE ensemble.'
               write( 6, '(a)' )
            else if ( tamd_type(1:4) .eq. 'NVT ' ) then
               write( 6, '(a)' ) &
     &            'Type:     temperature accelerated MD, NVT ensemble.'
               write( 6, '(a)' )
            else if ( tamd_type(1:4) .eq. 'VS  ' ) then
               write( 6, '(a)' ) &
     &            'Type:     temperature accelerated MD,' // &
     &            'velocity scaling.'
               write( 6, '(a)' )
            end if
         end if
         if ( afed_type(1:7) .eq. 'LOGMFD '  ) then
            if      ( logmfd_type(1:4) .eq. 'NVE ' ) then
               write( 6, '(a)' ) &
     &            'Type:     logarithmic mean force dynamics, ' // &
     &            'NVE ensemble.'
               write( 6, '(a)' )
            else if ( logmfd_type(1:4) .eq. 'NVT ' ) then
               write( 6, '(a)' ) &
     &            'Type:     logarithmic mean force dynamics, ' // &
     &            'NVT ensemble.'
               write( 6, '(a)' )
            else if ( logmfd_type(1:4) .eq. 'VS  ' ) then
               write( 6, '(a)' ) &
     &            'Type:     logarithmic mean force dynamics, ' // &
     &            'velocity scaling.'
               write( 6, '(a)' )
            end if
         end if
      end if

!-----------------------------------------------------------------------

      if      ( ipotential(1:6) .eq. 'WATER ' ) then
         write( 6, '(a)' ) 'Model:    water.'
         write( 6, '(a)' )
      else if ( ipotential(1:11) .eq. 'METALWATER ' ) then
         write( 6, '(a)' ) 'Model:    metal-water interface.'
         write( 6, '(a)' )
         call titles_gal
      else if ( ipotential(1:7) .eq. 'HELIUM ' ) then
         write( 6, '(a)' ) 'Model:    helium.'
         write( 6, '(a)' )
         call titles_helium
      else if ( ipotential(1:9) .eq. 'HYDROGEN ' ) then
         write( 6, '(a)' ) 'Model:    hydrogen.'
         write( 6, '(a)' )
         call titles_hydrogen
      else if ( ipotential(1:8) .eq. 'QUARTIC ' ) then
         write( 6, '(a)' ) 'Model:    quartic potential.'
         write( 6, '(a)' )
      else if ( ipotential(1:5) .eq. 'PAIR ' ) then
         write( 6, '(a)' ) 'Model:    pair potential.'
         write( 6, '(a)' )
      else if ( ipotential(1:3) .eq. 'MM ' ) then
         write( 6, '(a)' ) 'Model:    mm force field.'
         write( 6, '(a)' )
      else if ( ipotential(1:4) .eq. 'POL ' ) then
         write( 6, '(a)' ) 'Model:    polarizable mm force field.'
         write( 6, '(a)' )
      else if ( ipotential(1:4) .eq. 'EAM ' ) then
         write( 6, '(a)' ) 'Model:    eam.'
         write( 6, '(a)' )
      else if ( ipotential(1:4) .eq. 'ADP ' ) then
         write( 6, '(a)' ) 'Model:    adp.'
         write( 6, '(a)' )
      else if ( ipotential(1:8) .eq. 'TERSOFF ' ) then
         write( 6, '(a)' ) 'Model:    Tersoff potential.'
         write( 6, '(a)' )
      else if ( ipotential(1:6) .eq. 'MOPAC ' ) then
         write( 6, '(a)' ) 'Model:    mopac.'
         write( 6, '(a)' )
         call titles_mopac
      else if ( ipotential(1:6) .eq. 'SMASH ' ) then
         write( 6, '(a)' ) 'Model:    smash.'
         write( 6, '(a)' )
         call titles_smash
      else if ( ipotential(1:7) .eq. 'NTCHEM ' ) then
         write( 6, '(a)' ) 'Model:    ntchem.'
         write( 6, '(a)' )
         call titles_ntchem
      else if ( ipotential(1:4) .eq. 'G09 ' ) then
         write( 6, '(a)' ) 'Model:    g09.'
         write( 6, '(a)' )
         call titles_g09
      else if ( ipotential(1:4) .eq. 'G16 ' ) then
         write( 6, '(a)' ) 'Model:    g16.'
         write( 6, '(a)' )
         call titles_g16
      else if ( ipotential(1:4) .eq. 'G03 ' ) then
         write( 6, '(a)' ) 'Model:    g03.'
         write( 6, '(a)' )
         call titles_g03
      else if ( ipotential(1:4) .eq. 'G98 ' ) then
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Model:    g98.'
         call titles_g98
      else if ( ipotential(1:10) .eq. 'TURBOMOLE ' ) then
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Model:    turbomole.'
         call titles_turbomole
      else if ( ipotential(1:7) .eq. 'GAMESS ' ) then
         write( 6, '(a)' )
         write( 6, '(a)' ) 'Model:    gamess.'
         call titles_gamess
      else if ( ipotential(1:4) .eq. 'VASP' ) then
         write( 6, '(a)' ) 'Model:    vasp.'
         write( 6, '(a)' )
         call titles_vasp
      else if ( ipotential(1:5) .eq. 'QE ' ) then
         write( 6, '(a)' ) 'Model:    qe.'
         write( 6, '(a)' )
         call titles_qe
      else if ( ipotential(1:7) .eq. 'PHASE0 ' ) then
         write( 6, '(a)' ) 'Model:    phase/0.'
         write( 6, '(a)' )
         call titles_phase0
      else if ( ipotential(1:7) .eq. 'MOLPRO ' ) then
         write( 6, '(a)' ) 'Model:    molpro.'
         write( 6, '(a)' )
         call titles_molpro
      else if ( ipotential(1:5) .eq. 'ORCA ' ) then
         write( 6, '(a)' ) 'Model:    orca.'
         write( 6, '(a)' )
         call titles_orca
      else if ( ipotential(1:6) .eq. 'TULLY ' ) then
         write( 6, '(a)' ) 'Model:    tully model.'
         write( 6, '(a)' )
      else if ( ipotential(1:5) .eq. 'DUAL ' ) then
         write( 6, '(a)' ) 'Model:    dual levels.'
         write( 6, '(a)' )
      else if ( ipotential(1:8) .eq. 'CP2KLIB ' ) then
         write( 6, '(a)' ) 'Model:    cp2k.'
         write( 6, '(a)' )
         call titles_cp2k
      else if ( ipotential(1:5) .eq. 'DFTB ' ) then
         write( 6, '(a)' ) 'Model:    dftb - external'
         write( 6, '(a)' )
         call titles_dftb
      else if ( ipotential(1:8) .eq. 'DFTBLIB ' ) then
         write( 6, '(a)' ) 'Model:    dftb - internal'
         write( 6, '(a)' )
         call titles_dftb
      else if ( ipotential(1:4) .eq. 'XTB ' ) then
         write( 6, '(a)' ) 'Model:    xtb - external'
         write( 6, '(a)' )
         call titles_xtb
      else if ( ipotential(1:10) .eq. 'ABINIT-MP ' ) then
         write( 6, '(a)' ) 'Model:    abinit-mp.'
         write( 6, '(a)' )
         call titles_abinit_mp
      else if ( ipotential(1:7) .eq. 'ALCHEM ' ) then
         write( 6, '(a)' ) 'Model:    alchemical mixture.'
         write( 6, '(a)' )
         call titles_alchem
      else if ( ipotential(1:5) .eq. 'QMMM ' ) then
         if      ( qmmm_embedding(1:3) .eq. 'EE ' ) then
            write( 6, '(a)' ) 'Model:    qm/mm electronic embedding' &
     &         // ' with ' // trim(qmmm_potential) // '.'
         else if ( qmmm_embedding(1:3) .eq. 'ME ' ) then
            write( 6, '(a)' ) 'Model:    qm/mm mechanical embedding' &
     &         // ' with ' // trim(qmmm_potential) // '.'
         end if
         write( 6, '(a)' )
      else if ( ipotential(1:6) .eq. 'ONIOM ' ) then
         write( 6, '(a)' ) 'Model:    ONIOM with ' // &
     &         trim(oniom_hi_potential) // ' and ' // &
     &         trim(oniom_lo_potential) // '.'
         write( 6, '(a)' )
      else if ( ipotential(1:5) .eq. 'USER ' ) then
         write( 6, '(a)' ) 'Model:    user defined.'
         write( 6, '(a)' )
      else if ( ipotential(1:6) .eq. 'TIP4P ' ) then
         write( 6, '(a)' ) 'Model:    tip4p.'
         write( 6, '(a)' )
      else if ( ipotential(1:6) .eq. 'HILLS ' ) then
         write( 6, '(a)' ) 'Model:    hills.'
         write( 6, '(a)' )
      else if ( ipotential(1:5) .eq. 'CART ' ) then
         write( 6, '(a)' ) 'Model:    cartesian.'
         write( 6, '(a)' )
      else if ( ipotential(1:6) .eq. 'AENET ' ) then
         write( 6, '(a)' ) 'Model:    AENET artificial neural network.'
         write( 6, '(a)' )
         call titles_aenet
      else if ( ipotential(1:5) .eq. 'N2P2 ' ) then
         write( 6, '(a)' ) 'Model:    N2P2 artificial neural network.'
         write( 6, '(a)' )
         call titles_n2p2
      else if ( ipotential(1:4) .eq. 'MTP ' ) then
         write( 6, '(a)' ) 'Model:    moment tensor potential.'
         write( 6, '(a)' )
         call titles_mtp
      else if ( ipotential(1:7) .eq. 'LIBNNP ' ) then
         write( 6, '(a)' ) 'Model:    libnnp.'
         write( 6, '(a)' )
         call titles_libnnp
      else if ( ipotential(1:7) .eq. 'MULLER ' ) then
         write( 6, '(a)' ) 'Model:    Muller-Brown.'
         write( 6, '(a)' )
      else if ( ipotential(1:4) .eq. 'OSS ' ) then
         write( 6, '(a)' ) 'Model:    Ojamae-Shavitt-Singer (OSS2).'
         write( 6, '(a)' )
         call titles_oss
      else if ( ipotential(1:4) .eq. 'PFP ' ) then
         write( 6, '(a)' ) 'Model:    Matlantis PFP.'
         write( 6, '(a)' )
         call titles_pfp
      else
         write( 6, '(a)' ) 'Model:    ??'
         write( 6, '(a)' )
      end if

!-----------------------------------------------------------------------

      if      ( ensemble(1:5) .eq. 'NVE  ' ) then
         write(6, '(a)' ) 'Ensemble: NVE.'
      else if ( ensemble(1:5) .eq. 'NVT  ' ) then
         write(6, '(a)' ) 'Ensemble: NVT.'
      else if ( ensemble(1:5) .eq. 'NPT  ' ) then
          if     ( npt_type(1:6) .eq. 'CUBIC1' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NPT, Cubic box (Andersen).'
         else if ( npt_type(1:6) .eq. 'CUBIC2' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NPT, Cubic box (Martyna).'
         else if ( npt_type(1:6) .eq. 'PPHEX' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NPT, Parallel piped hexahedron box.'
         end if
      else if ( ensemble(1:5) .eq. 'NPH  ' ) then
         if      ( nph_type(1:6) .eq. 'CUBIC1' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NPH, Cubic box (Andersen).'
         else if ( nph_type(1:6) .eq. 'CUBIC2' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NPH, Cubic box (Martyna).'
         else if ( nph_type(1:6) .eq. 'PPHEX' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NPH, Parallel piped hexahedron box.'
         end if
      else if ( ensemble(1:5) .eq. 'NTT  ' ) then
         if      ( ntt_type(1:6) .eq. 'PPHEX' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NtT, Parallel piped hexahedron box.'
         end if
      else if ( ensemble(1:5) .eq. 'NTH  ' ) then
         if      ( nth_type(1:6) .eq. 'PPHEX' ) then
            write(6, '(a)' ) &
     &         'Ensemble: NtT, Parallel piped hexahedron box.'
         end if
      else if ( ensemble(1:5) .eq. 'NONE  ' ) then
         write(6, '(a)' ) 'Ensemble: none.'
      else if ( ensemble(1:5) .eq. 'QTST ' ) then
         write(6, '(a)' ) 'Ensemble: QTST.'
      else
         write(6, '(a)' ) 'Ensemble: ??'
      end if

      write( 6, '(a)' )

!-----------------------------------------------------------------------

      if      ( method(1:3) .eq. 'MD ' ) then

         if      ( bath_type(1:5) .eq. 'MNHC ' ) then
            write(6, '(a)' ) 'Temperature is controlled using' // &
     &         ' massive Nose-Hoover chains thermostat.'
            write(6, '(a)' )
         end if

      else if ( method(1:5) .eq. 'PIMD ' ) then

         if      ( bath_type(1:5) .eq. 'NHC  ' ) then
             write(6, '(a)' ) 'Temperature is controlled using' // &
     &          ' Nose-Hoover chain thermostat.'
         else if ( bath_type(1:5) .eq. 'NHCS ' ) then
             write(6, '(a)' ) 'Temperature is controlled using' // &
     &          ' multiple Nose-Hoover chains thermostat.'
         else if ( bath_type(1:5) .eq. 'MNHC ' ) then
             write(6, '(a)' ) 'Temperature is controlled using' // &
     &          ' massive Nose-Hoover chains thermostat.'
         end if

         write( 6, '(a)' )

      else if ( method(1:5) .eq. 'PIHMC' ) then

         if      ( iorder_hmc .eq. 2 ) then
             write(6, '(a)' ) 'Second order Suzuki-Trotter expansion.'
         else if ( iorder_hmc .eq. 4 ) then
             write(6, '(a)' ) 'Fourth order Suzuki-Trotter expansion.'
         end if

         write( 6, '(a)' )

      else if ( method(1:5) .eq. 'MTD  ' ) then

         if ( ipotential(1:5) .eq. 'DUAL ' ) then
             continue
         else if ( bath_type(1:5) .eq. 'MNHC ' ) then
             write(6, '(a)' ) 'Temperature is controlled using ' // &
     &          ' massive Nose-Hoover chains thermostat.'
         end if

         write( 6, '(a)' )

      else if ( method(1:5) .eq. 'REHMC' ) then

         if       ( irem_type(1:3) .eq. 'T  ' ) then
             write(6, '(a)' ) 'Parallel temperatures without exchange.'
         else if  ( irem_type(1:3) .eq. 'TX ' ) then
             write(6, '(a)' ) 'Temperature replica exchange.'
         else if  ( irem_type(1:3) .eq. 'HX ' ) then
             write(6, '(a)' ) 'Hamiltonian replica exchange.'
         end if

         write( 6, '(a)' )

      end if

!-----------------------------------------------------------------------

      if ( ( method(1:5) .eq. 'REHMC' ) .or. &
     &     ( method(1:5) .eq. 'RHMC ' ) ) then

         if  ( ( irem_type(1:3) .eq. 'T  ' ) .or. &
     &         ( irem_type(1:3) .eq. 'TX ' ) ) then
            write(6, '(a,i6,a,i4,a)' ) &
     &        'System:', &
     &         natom, ' atoms, ', &
     &         nbead, ' beads.'
            write( 6, '(a)' )
            write( 6, '(a)', advance='no' ) 'Temperatures: '
            do i = 1, nbead
               if ( i .eq. nbead ) then
                  write( 6, '(f8.1,a)' ) temperature_bead(i), ' K.'
               else if ( mod(i,6) .eq. 0 ) then
                  write( 6, '(f8.1,a)' ) temperature_bead(i), ','
                  write( 6, '(a)', advance='no' ) &
     &                                      '              '
               else
                  write( 6, '(f8.1,a)', advance='no' ) &
     &                                   temperature_bead(i), ','
               end if
            end do
            write( 6, '(a)' )
         else
            write(6, '(a,i6,a,i4,a)' ) &
     &        'System:', &
     &         natom, ' atoms, ', &
     &         nbead, ' beads.'
            write( 6, '(a)' )
         end if

      else

         if      ( ensemble(1:5) .eq. 'NVE  ' ) then
            write(6, '(a,i6,a,i4,a)' ) &
     &        'System:', &
     &         natom, ' atoms, ', &
     &         nbead, ' beads.'
            write( 6, '(a)' )
         else if ( ensemble(1:5) .eq. 'NVT  ' ) then
            write(6, '(a,i6,a,i4,a,f8.1,a)' ) &
     &        'System:', &
     &         natom, ' atoms, ', &
     &         nbead, ' beads, ', &
     &         temperature, ' K.'
            write( 6, '(a)' )
         else if ( ensemble(1:5) .eq. 'NPT  ' ) then
            write(6, '(a,i6,a,i4,a,f8.1,a,f8.1,a)' ) &
     &        'System:', &
     &         natom, ' atoms, ', &
     &         nbead, ' beads, ', &
     &         temperature, ' K, ', &
     &         pressure * (au_energy/au_length**3/10**6), ' MPa.'
            write( 6, '(a)' )
         else if ( ensemble(1:5) .eq. 'NTT  ' ) then
            write(6, '(a,i6,a,i4,a,f8.1,a)' ) &
     &        'System:', &
     &         natom, ' atoms, ', &
     &         nbead, ' beads, ', &
     &         temperature, ' K.'
            write( 6, '(a)' )
         else
            write(6, '(a,i6,a,i4,a)' ) &
     &        'System:', &
     &         natom, ' atoms, ', &
     &         nbead, ' beads.'
            write( 6, '(a)' )
         end if

      end if

!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &  '---------------------------------------------------------' &
     &  // '---------------------'
      write( 6, '(a)' ) &
     &  '     type  symbol  number           mass            atoms'
      write( 6, '(a)' ) &
     &  '---------------------------------------------------------' &
     &  // '---------------------'

      do i = 1, mspec

         pm = physmass_spec(i)/amu_mass*au_mass

         if ( ( pm .lt. 1.d0 ) .or. ( pm .gt. 1.d+9 ) ) then
            write( 6, '(5x,i4,2x,a8,i6,e15.7,9x,i8)' ) &
     &         i, spec(i), num_spec(i), pm, natom_spec(i)
         else
            write( 6, '(5x,i4,2x,a8,i6,f15.5,9x,i8)' ) &
     &         i, spec(i), num_spec(i), pm, natom_spec(i)
         end if

      end do

      write( 6, '(a)' ) &
     &  '---------------------------------------------------------' &
     &  // '---------------------'
      write( 6, '(a)' )

!-----------------------------------------------------------------------

      if ( ( ipos_start .eq. 0 ) .and. ( ivel_start .eq. 0 ) ) then

         if ( method(1:7) .eq. 'STRING ' ) then

            write( 6, '(a)' ) &
     &         'Atomic positions read from structure.dat and adjusted.'

         else if ( method(1:6) .eq. 'OMOPT ' ) then

            write( 6, '(a)' ) &
     &         'Atomic positions read from structure.dat and adjusted.'

!         else if ( method(1:3) .eq. 'OM ' ) then
!
!            write( 6, '(a)' )
!     &         'Atomic positions read from structure.dat and adjusted.'

         else

            if ( input_style(1:4) .eq. 'OLD ' ) then

               write( 6, '(a)' ) &
     &            'Atomic positions read from centroid.dat. ' // &
     &            'Molecular configuration initialized.'

            else if ( input_style(1:4) .eq. 'NEW ' ) then

               write( 6, '(a)' ) &
     &            'Atomic positions read from structure.dat. ' // &
     &            'Molecular configuration initialized.'

            end if

         end if

         write( 6, '(a)' )

         if      ( method(1:5) .eq. 'CMD ' ) then

            write(6,'(a)') &
     &          '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!' &
     &       // '!!!!!!!!!!!!!!!!!!!!!!!!!'

            write( 6, '(a)' ) &
     &         'WARNING: CMD did not restart from PIMD trajectory. ' &
     &      // 'geometry.ini not found.'

            write(6,'(a)') &
     &          '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!' &
     &       // '!!!!!!!!!!!!!!!!!!!!!!!!!'
            write(6,'(a)')

         else if ( method(1:5) .eq. 'RPMD ' ) then

            write(6,'(a)') &
     &          '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!' &
     &       // '!!!!!!!!!!!!!!!!!!!!!!!!!'

            write( 6, '(a)' ) &
     &         'WARNING: RPMD did not restart from PIMD trajectory. ' &
     &      // 'geometry.ini not found.'

            write(6,'(a)') &
     &          '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!' &
     &       // '!!!!!!!!!!!!!!!!!!!!!!!!!'
            write(6,'(a)')

         end if

      else if ( ( ipos_start .eq. 3 ) .and. ( ivel_start .eq. 3 ) ) then

         write( 6, '(a)' ) &
     &      'Molecular configuration restarted, ' // &
     &      'read from string.ini.'

         write( 6, '(a)' )

      else

         write( 6, '(a)' ) &
     &      'Molecular configuration restarted, ' // &
     &      'read from geometry.ini.'

         write( 6, '(a)' )

      end if

!-----------------------------------------------------------------------

      if      ( iboundary .eq. 0 ) then

         write( 6, '(a)' ) &
     &      'Free boundary condition - isolated system.'

      else if ( ( iboundary .eq. 1 ) .or. ( iboundary .eq. 2 ) ) then

         if      ( iboundary .eq. 1 ) then
            write( 6, '(a)' ) &
     &         'Periodic boundary condition ' // &
     &         '- atomic positions restricted within box.'
         else if ( iboundary .eq. 2 ) then
            write( 6, '(a)' ) &
     &         'Periodic boundary condition ' // &
     &         '- atomic positions NOT restricted within box.'
         end if

         write( 6, '(a)' )

         if ( ( ensemble(1:4) .eq. 'NTT ' ) .or. &
     &        ( ensemble(1:4) .eq. 'NTH ' ) ) then

            if ( ibox_start .eq. 0 ) then

               write( 6, '(a)' ) &
     &            'Simulation box read from input.dat.'
               write( 6, '(a)' ) &
     &            'Reference box read from input.dat.'

            else

               write( 6, '(a)' ) &
     &            'Simulation box read from box.ini.'
               write( 6, '(a)' ) &
     &            'Reference box read from input.dat.'

            end if

         else

            if ( ibox_start .eq. 0 ) then

               write( 6, '(a)' ) &
     &            'Simulation box read from input.dat.'

            else

               write( 6, '(a)' ) &
     &            'Simulation box read from box.ini.'

            end if

         end if

      end if

      write( 6, '(a)' )

!-----------------------------------------------------------------------

      if ( ( ( method(1:5) .eq. 'MD   '  ) .and. &
     &       ( ensemble(1:4) .eq. 'NVT ' ) ) .or. &
     &     ( ( method(1:5) .eq. 'PIMD '  ) .and. &
     &       ( ensemble(1:4) .eq. 'NVT ' ) ) .or. &
     &     ( ( method(1:5) .eq. 'PIMD '  ) .and. &
     &       ( ensemble(1:4) .eq. 'NPT ' ) ) .or. &
     &     ( ( method(1:5) .eq. 'PIMD '  ) .and. &
     &       ( ensemble(1:4) .eq. 'NTT ' ) ) .or. &
     &     ( ( method(1:5) .eq. 'MTS  '  ) .and. &
     &       ( ensemble(1:4) .eq. 'NVT ' ) ) .or. &
     &     ( ( method(1:5) .eq. 'MTD  '  ) .and. &
     &       ( ensemble(1:4) .eq. 'NVT ' ) ) .or. &
     &     ( ( method(1:5) .eq. 'CMD  '  ) .and. &
     &       ( ensemble(1:4) .eq. 'NVE ' ) ) ) then

         if ( ibath_start .eq. 0 ) then

            write( 6, '(a)' ) &
     &         'Thermostat positions and velocities initialized, ' // &
     &         'given randomly.'

            write( 6, '(a)' )

         else

            write( 6, '(a)' ) &
     &         'Thermostat positions and velocities restarted, ' // &
     &         'read from bath.ini.'

            write( 6, '(a)' )

         end if

      end if

!-----------------------------------------------------------------------

      if ( method(1:7) .eq. 'STRING ' ) then

         if      ( ends_string(1:5)  .eq. 'FREE '      ) then
            write( 6, '(a)' ) &
     &         'Both ends of the string is free to move.'
         else if ( ends_string(1:6)  .eq. 'FIXED '     ) then
            write( 6, '(a)' ) &
     &         'Both ends of the string are fixed.'
         else if ( ends_string(1:10) .eq. 'FREEFIXED ' ) then
            write( 6, '(a)' ) &
     &         'One end of the string is free, the other fixed.'
         else if ( ends_string(1:10) .eq. 'FIXEDFREE ' ) then
            write( 6, '(a)' ) &
     &         'One end of the string is fixed, the other free.'
         end if

         write( 6, '(a)' )

      end if

      if ( ( method(1:3) .eq. 'OM ' ) .or. &
     &     ( method(1:6) .eq. 'OMOPT ' ) ) then

         if      ( equation_om(1:11) .eq. 'OVERDAMPED '  ) then
            write( 6, '(a)' ) 'Overdamped Langevin Equation.'
         else if ( equation_om(1:12) .eq. 'UNDERDAMPED ' ) then
            write( 6, '(a)' ) 'Underdamped Langevin Equation.'
         end if

         write( 6, '(a)' )

         if      ( ends_string(1:5)  .eq. 'FREE '      ) then
            write( 6, '(a)' ) &
     &         'Both ends of the string is free to move.'
         else if ( ends_string(1:6)  .eq. 'FIXED '     ) then
            write( 6, '(a)' ) &
     &         'Both ends of the string are fixed.'
         else if ( ends_string(1:10) .eq. 'FREEFIXED ' ) then
            write( 6, '(a)' ) &
     &         'One end of the string is free, the other fixed.'
         else if ( ends_string(1:10) .eq. 'FIXEDFREE ' ) then
            write( 6, '(a)' ) &
     &         'One end of the string is fixed, the other free.'
         end if

         write( 6, '(a)' )

      end if

!-----------------------------------------------------------------------

      return
      end
