!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     polymers print outputs
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine print_polymers_atom_MPI
!***********************************************************************

      call print_trj_polymers_atom_MPI

      call print_fenergy_polymers_atom_MPI

      return
      end





!***********************************************************************
      subroutine print_polymers_cons_MPI
!***********************************************************************

      call print_trj_polymers_cons_MPI

      call print_fenergy_polymers_cons_MPI

      return
      end





!***********************************************************************
      subroutine print_trj_polymers_atom_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

!     /*   shared variables   */

      use common_variables, only : &
     &   au_length, species, natom, myrank_world, iounit

      use polymers_variables, only : &
     &   xc_poly, yc_poly, zc_poly, npoly, icycle_poly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8), parameter :: bohr2ang = au_length/1.d-10

      integer :: i, m

!-----------------------------------------------------------------------
!     /*   only master process                                        */
!-----------------------------------------------------------------------

      if ( myrank_world .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   print trajectory of polymers                               */
!-----------------------------------------------------------------------

      open( iounit, file = 'poly.all.xyz', access = 'append' )

         write( iounit, '(i8)' ) npoly*natom
         write( iounit, '(i8)' ) icycle_poly

         do m = 1, npoly

            i = 0

            do i = 1, natom
               write( iounit, '(a,3f12.6)' ) &
     &            species(i), &
     &            xc_poly(i,m)*bohr2ang, &
     &            yc_poly(i,m)*bohr2ang, &
     &            zc_poly(i,m)*bohr2ang
            end do

         end do

      close( iounit )

      open( iounit, file = 'poly.one.xyz' )

         do m = 1, npoly

            write( iounit, '(i8)' ) natom
            write( iounit, '(2i8)' ) m, icycle_poly

            i = 0

            do i = 1, natom
               write( iounit, '(a,3f12.6)' ) &
     &            species(i), &
     &            xc_poly(i,m)*bohr2ang, &
     &            yc_poly(i,m)*bohr2ang, &
     &            zc_poly(i,m)*bohr2ang
            end do

         end do

      close( iounit )

      return
      end





!***********************************************************************
      subroutine print_trj_polymers_cons_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : myrank_world, iounit
      use cons_variables, only : ncons
      use polymers_variables, only : rcons_poly, npoly, icycle_poly

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, m

!-----------------------------------------------------------------------
!     /*   only master process                                        */
!-----------------------------------------------------------------------

      if ( myrank_world .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   print trajectory of polymers                               */
!-----------------------------------------------------------------------

      open( iounit, file = 'poly.all.out', access = 'append' )

      do m = 1, npoly
      do i = 1, ncons
         write( iounit, '(i8,f12.6)' ) icycle_poly, rcons_poly(i,m)
      end do
      end do

      close( iounit )

      return
      end





!***********************************************************************
      subroutine print_fenergy_polymers_atom_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   myrank_world, iounit, char_date

      use polymers_variables, only : &
     &   ekinvir_poly, epot_poly, pmfc_poly, entropy_poly, rc_arc, &
     &   pmfc_arc, npoly, icycle_poly, narc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, k

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   only master process                                        */
!-----------------------------------------------------------------------

      if ( myrank_world .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   standard output                                            */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         if ( icycle_poly .eq. 0 ) then

            open( iounit, file = 'poly.out', access = 'append' )

            write( iounit, '(a)' ) &
     &         '=======================================' // &
     &         '======================================='

            write( iounit, '(a)' ) &
     &         'cycl num   kinetic potential ' // &
     &         'helmholtz     entropy  wall clock time           '

            write( iounit, '(a)' ) &
     &         '---------------------------------------' // &
     &         '---------------------------------------'

            close( iounit )

         end if

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   print free energy                                          */
!-----------------------------------------------------------------------

      call getdate

      open( iounit, file = 'poly.out', access = 'append' )

      do i = 1, npoly

         write( iounit, '(2i4,3f10.5,f12.7,2x,a26)' ) &
     &      icycle_poly, i, &
     &      ekinvir_poly(i)-ekinvir_poly(1), &
     &      epot_poly(i)-epot_poly(1), &
     &      pmfc_poly(i)-pmfc_poly(1), &
     &      entropy_poly(i)-entropy_poly(1), &
     &      char_date

      end do

      close( iounit )

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   '=======================================' // &
     &   '======================================='

      write( 6, '(a)' ) &
     &   'cycl num   kinetic potential ' // &
     &   'helmholtz     entropy  wall clock time           '

      write( 6, '(a)' ) &
     &   '---------------------------------------' // &
     &   '---------------------------------------'

      do i = 1, npoly

         write( 6, '(2i4,3f10.5,f12.7,2x,a26)' ) &
     &      icycle_poly, i, &
     &      ekinvir_poly(i)-ekinvir_poly(1), &
     &      epot_poly(i)-epot_poly(1), &
     &      pmfc_poly(i)-pmfc_poly(1), &
     &      entropy_poly(i)-entropy_poly(1), &
     &      char_date

      end do

      write( 6, '(a)' )

      open( iounit, file = 'poly_final.out', access = 'append' )

      do k = 1, narc

         write( iounit, '(2i8,2f16.8)' ) &
     &      icycle_poly, k, rc_arc(k), pmfc_arc(k)

      end do

      close( iounit )

      return
      end





!***********************************************************************
      subroutine print_fenergy_polymers_cons_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   myrank_world, iounit, char_date

      use cons_variables, only : &
     &   ncons

      use polymers_variables, only : &
     &   rcons_poly, scons_poly, pmfc_poly, rc_arc, pmfc_arc, &
     &   npoly, icycle_poly, narc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   only master process                                        */
!-----------------------------------------------------------------------

      if ( myrank_world .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   standard output                                            */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         if ( icycle_poly .eq. 0 ) then

            open( iounit, file = 'poly.out', access = 'append' )

            write( iounit, '(a)' ) &
     &         '============================' // &
     &         '========================================'

            write( iounit, '(a)' ) &
     &         'cycl num     rcons     scons' // &
     &         '   helmholtz  wall clock time           '

            write( iounit, '(a)' ) &
     &         '----------------------------' // &
     &         '----------------------------------------'

            close( iounit )

         end if

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   print free energy                                          */
!-----------------------------------------------------------------------

      call getdate

      open( iounit, file = 'poly.out', access = 'append' )

      do i = 1, npoly

         do j = 1, ncons
            write( iounit, '(2i4,2f10.4,f12.7,2x,a26)' ) &
     &         icycle_poly, i, &
     &         rcons_poly(j,i), scons_poly(j,i), &
     &         pmfc_poly(i)-pmfc_poly(1), &
     &         char_date
         end do

      end do

      close( iounit )

      write( 6, '(a)' )

      write( 6, '(a)' ) &
     &   '============================' // &
     &   '========================================'

      write( 6, '(a)' ) &
     &   'cycl num     rcons     scons' // &
     &   '   helmholtz  wall clock time           '

      write( 6, '(a)' ) &
     &   '----------------------------' // &
     &   '----------------------------------------'

      WRITE(*,*) 'NPOLY =', npoly

      do i = 1, npoly

      WRITE(*,*) 'i =', i

         do j = 1, ncons
            write( 6, '(2i4,2f10.4,f12.7,2x,a26)' ) &
     &         icycle_poly, i, &
     &         rcons_poly(j,i), scons_poly(j,i), &
     &         pmfc_poly(i)-pmfc_poly(1), &
     &         char_date
         end do

      end do

      write( 6, '(a)' )

      open( iounit, file = 'poly_final.out', access = 'append' )

      do k = 1, narc

         write( iounit, '(2i8,2f16.8)' ) &
     &      icycle_poly, k, rc_arc(k), pmfc_arc(k)

      end do

      close( iounit )

      return
      end
