!///////////////////////////////////////////////////////////////////////
!
!      Author:          B. Thomsen, M. Shiga
!      Last updated:    Jul 30, 2019 by M. Shiga
!      Description:     module for generating .minfo output
!                       for method = NMA, static, scan
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine print_minfo_vibcoord ( )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   natom, iounit_minfo

      use nma_variables, only : &
     &   eigval, eigvec

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: natom3, k, i

!-----------------------------------------------------------------------
!     /*   print minfo                                                */
!-----------------------------------------------------------------------

      natom3 = 3*natom

      write( iounit_minfo, '(a)' ) &
     &   '[ Vibrational Data ]'
      write( iounit_minfo, '(a)' ) &
     &   'Normal modes'
      write( iounit_minfo, '(a)' ) &
     &   'Translational Frequency'
      write( iounit_minfo, '(I0,T5)' ) &
     &   3
      write( iounit_minfo, '(e15.8,a2,e15.8,a2,e15.8)' ) &
     &   eigval(1),', ',eigval(2),', ',eigval(3)
      write( iounit_minfo, '(a)') &
     &   'Translational vector'
      do k = 1, 3
         write( iounit_minfo, '(a2,I0,T5)' ) &
     &      'T ',k-1
         write( iounit_minfo, '(I0,T5)' ) &
     &      natom3
         do i = 1, natom3/5
            write( iounit_minfo, &
     &         '(e15.8,a2,e15.8,a2,e15.8,a2,e15.8,a2,e15.8)' ) &
     &         eigvec((i-1)*5+1,k),', ',eigvec((i-1)*5+2,k),', ', &
     &         eigvec((i-1)*5+3,k),', ',eigvec((i-1)*5+4,k),', ', &
     &         eigvec((i-1)*5+5,k)
         end do
         if ( MOD(3*natom,5) .ne. 0 ) then
            do i = 1, MOD(natom3,5)-1
               write( iounit_minfo, '(e15.8,a2)', advance="no" ) &
     &            eigvec((natom3/5)*5+i,k), ', '
            end do
            write( iounit_minfo, '(e15.8)' ) eigvec(natom3,k);
         end if
      end do
      write( iounit_minfo, '(a)' ) &
     &   'Rotational Frequency'
      write( iounit_minfo, '(I0,T5)' ) &
     &   3
      write( iounit_minfo, '(e15.8,a2,e15.8,a2,e15.8)' ) &
     &   eigval(4),', ',eigval(5),', ',eigval(6)
      write( iounit_minfo, '(a)' ) &
     &   'Rotational vector'
      do k = 4, 6
         write( iounit_minfo, '(a2,I0,T5)' ) &
     &      'R ',k-4
         write( iounit_minfo, '(I0,T5)' ) &
     &      natom3
         do i = 1, natom3/5
            write( iounit_minfo, &
     &         '(e15.8,a2,e15.8,a2,e15.8,a2,e15.8,a2,e15.8)' ) &
     &         eigvec((i-1)*5+1,k),', ',eigvec((i-1)*5+2,k),', ', &
     &         eigvec((i-1)*5+3,k),', ',eigvec((i-1)*5+4,k),', ', &
     &         eigvec((i-1)*5+5,k)
         end do
         if ( MOD(natom3,5) .ne. 0 ) then
            do i = 1, MOD(natom3,5)-1
               write( iounit_minfo, '(e15.8,a2)', advance="no" ) &
     &            eigvec((natom3/5)*5+i,k), ', '
            end do
            write( iounit_minfo, '(e15.8)' ) eigvec(natom3,k);
         end if
      end do
      write( iounit_minfo, '(a)' ) &
     &   'Vibrational Frequency'
      write( iounit_minfo, '(I0,T5)' ) &
     &   natom3-6
      if ( natom3-6 .gt. 5 ) then
         do i = 1, (natom3-6)/5
            write( iounit_minfo, &
     &         '(e15.8,a2,e15.8,a2,e15.8,a2,e15.8,a2,e15.8)') &
     &         eigval((i-1)*5+7),', ',eigval((i-1)*5+8),', ', &
     &         eigval((i-1)*5+9),', ',eigval((i-1)*5+10),', ', &
     &         eigval((i-1)*5+11)
         end do
      end if
      if ( MOD((natom3-6),5) .ne. 0 ) then
         do i = 1, MOD(natom3-6,5)-1
            write( iounit_minfo, '(e15.8,a2)', advance="no" ) &
     &         eigval(((natom3-6)/5)*5+i+6), ', '
         end do
         write( iounit_minfo, '(e15.8)' ) eigval(natom3);
      end if
      write( iounit_minfo, '(a)') &
     &   'Vibrational vector'
      do k = 7, natom3
         write( iounit_minfo, '(a5,I0,T5)' ) &
     &      'Mode ',k-7
         write( iounit_minfo, '(I0,T5)' ) &
     &      natom3
         do i = 1, natom3/5
            write( iounit_minfo, &
     &         '(e15.8,a2,e15.8,a2,e15.8,a2,e15.8,a2,e15.8)' ) &
     &         eigvec((i-1)*5+1,k),', ',eigvec((i-1)*5+2,k),', ', &
     &         eigvec((i-1)*5+3,k),', ',eigvec((i-1)*5+4,k),', ', &
     &         eigvec((i-1)*5+5,k)
         end do
         if ( MOD(natom3,5) .ne. 0 ) then
            do i = 1, MOD(natom3,5)-1
               write( iounit_minfo, '(e15.8,a2)', advance="no" ) &
     &            eigvec((natom3/5)*5+i,k), ', '
            end do
            write( iounit_minfo, '(e15.8)' ) eigvec(natom3,k);
         end if
      end do

      return
      end





!***********************************************************************
      subroutine print_minfo_electronic ( curr_bead )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   pot, natom, iounit_minfo, fx, fy, fz, au_mass, amu_mass, &
     &   nbead, iounit, method

!cc      use common_variables, only :
!cc     &   dipx, dipy, dipz

      use nma_variables, only : &
     &   hess

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: curr_bead, natom3, k, i, j

      real(8) :: rl_nbead

!-----------------------------------------------------------------------
!     /*   print minfo                                                */
!-----------------------------------------------------------------------

      natom3 = 3*natom

      rl_nbead = - dble(nbead)

      write( iounit_minfo, '(a)' ) &
     &   '[ Electronic Data ]'
      write( iounit_minfo, '(a)' ) &
     &   'Energy'
      write( iounit_minfo, '(e15.8)' ) &
     &   pot(curr_bead)
      write( iounit_minfo, '(a)' ) &
     &   'Multiplicity'
      write( iounit_minfo, '(a)' ) &
     &   '1.0'
      write( iounit_minfo, '(a)' ) &
     &   'Gradient'
      write( iounit_minfo, '(I0,T5)' ) &
     &   natom3
      k = 1
      do i = 1, natom
         write( iounit_minfo, '(e15.8)', advance="no" ) &
     &      fx(i,curr_bead)*rl_nbead
         if ( k .eq. 5 ) then
            write( iounit_minfo, '(a)' ) &
     &         ' '
            k = 1
         else
            write( iounit_minfo, '(a)', advance="no" ) &
     &         ', '
            k = k + 1
         end if
         write( iounit_minfo, '(e15.8)', advance="no" ) &
     &      fy(i,curr_bead)*rl_nbead
         if ( k .eq. 5 ) then
            write( iounit_minfo, '(a)' )
            k = 1
         else
            write( iounit_minfo, '(a)', advance="no" ) &
     &         ', '
            k = k + 1
         end if
         write( iounit_minfo, '(e15.8)', advance="no" ) &
     &      fz(i,curr_bead)*rl_nbead
         if ( k .eq. 5 ) then
            write( iounit_minfo, '(a)' )
            k = 1
         else if ( i .eq. natom ) then
            write( iounit_minfo, '(a)' )
         else
            write( iounit_minfo, '(a)', advance="no" ) &
     &         ', '
            k = k + 1
         end if
      end do

      if ( method(1:4) .eq. 'NMA ' ) then
         write( iounit_minfo, '(a)' ) &
     &      'Hessian'
         write( iounit_minfo, '(I0,T6)' ) &
     &      natom3*(natom3+1)/2
         k = 1
         do i = 1, natom3
         do j = 1, i
            write( iounit_minfo, '(e15.8)', advance="no" ) &
     &         hess(i,j)*(amu_mass/au_mass)
            if ( k .eq. 5 ) then
               write( iounit_minfo, '(a)' )
               k = 1
            else if ( j .eq. natom3 ) then
               write( iounit_minfo, '(a)' )
            else
               write( iounit_minfo, '(a)', advance="no" ) &
     &            ', '
               k = k + 1
            end if
         end do
         end do
      end if

!cc      write( iounit_minfo, '(a)' )
!cc     &   'Dipole Moment'
!cc
!cc      write( iounit_minfo, '(e15.8,a2,e15.8,a2,e15.8)' )
!cc     &   dipx(curr_bead),', ',dipy(curr_bead),', ',dipz(curr_bead)

      write( iounit_minfo, '(a)' )

      return
      end





!***********************************************************************
      subroutine print_minfo_coord ( curr_bead )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, physmass, species, int_spec, &
     &   natom, iounit_minfo, au_mass, amu_mass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: curr_bead, i

!-----------------------------------------------------------------------
!     /*   print minfo                                                */
!-----------------------------------------------------------------------

      write( iounit_minfo,'(a)' ) &
     &   '# minfo File version 2:'
      write( iounit_minfo,'(a)' ) &
     &   '#'
      write( iounit_minfo,'(a)' ) &
     &   '[ Atomic Data ]'
      write( iounit_minfo,'(I0,T5)') natom

      do i = 1, natom

         write( iounit_minfo, &
     &      '(a4,a1,i6,a1,f11.4,a1,f16.8,a1,f16.8,a1,f16.8)' ) &
     &      species(i), ',', int_spec(i), &
     &      ',', (physmass(i)*au_mass/amu_mass), ',', &
     &      x(i,curr_bead), ',', y(i,curr_bead), ',', z(i,curr_bead)

      end do

      write( iounit_minfo, '(a)' )

      return
      end





!***********************************************************************
      subroutine print_minfo ( curr_bead, scan_cycle )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   method, iounit_minfo, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: curr_bead, scan_cycle

      character(len=8) :: char_num

!-----------------------------------------------------------------------
!     /*   print minfo                                                */
!-----------------------------------------------------------------------

      if      ( method(1:7) .eq. 'STATIC ' ) then
         open ( iounit_minfo, &
     &      file = 'singlepoint.minfo' )
         call print_minfo_coord( 1 )
         call print_minfo_electronic ( 1 )
      else if ( method(1:4) .eq. 'NMA ' ) then
         open ( iounit_minfo, &
     &      file = 'nma.minfo' )
         call print_minfo_coord( 1 )
         call print_minfo_electronic ( 1 )
         call print_minfo_vibcoord
      else if ( method(1:5) .eq. 'SCAN ' ) then
         call int8_to_char &
     &      ( (scan_cycle-1)*nbead+curr_bead, char_num )
         open ( iounit_minfo, &
     &      file = 'singlepoint.' // char_num // '.minfo' )
         call print_minfo_coord( curr_bead )
         call print_minfo_electronic ( curr_bead )
      else
         return
      end if

      close ( iounit_minfo )

      return
      end
