!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     preparation of XMPI
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine prep_XMPI
!***********************************************************************
!-----------------------------------------------------------------------
!     //   shared variables
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   natom, nbead, nprocs_main, nprocs_sub, myrank_main, myrank_sub

      use XMPI_variables, only : &
     &   istart_bead, iend_bead, istart_atom, iend_atom, nbead_paral, &
     &   natom_paral, jstart_bead, jend_bead, jstart_atom, jend_atom

!-----------------------------------------------------------------------
!     //   local variables
!-----------------------------------------------------------------------

      implicit none

      include 'mpif.h'

      integer :: l, natom_div, natom_rem, nbead_div, nbead_rem
      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     //   initial access only
!-----------------------------------------------------------------------

      if ( iset .ne. 0 ) return

      iset = 1

!-----------------------------------------------------------------------
!     //   memory allocation
!-----------------------------------------------------------------------

      if ( .not. allocated( istart_bead ) ) &
     &   allocate( istart_bead(nprocs_main) )

      if ( .not. allocated( iend_bead ) ) &
     &   allocate( iend_bead(nprocs_main) )

      if ( .not. allocated( nbead_paral ) ) &
     &   allocate( nbead_paral(nprocs_main) )

      if ( .not. allocated( istart_atom ) ) &
     &   allocate( istart_atom(nprocs_sub) )

      if ( .not. allocated( iend_atom ) ) &
     &   allocate( iend_atom(nprocs_sub) )

      if ( .not. allocated( natom_paral ) ) &
     &   allocate( natom_paral(nprocs_sub) )

!-----------------------------------------------------------------------
!     //   bead allocation
!-----------------------------------------------------------------------

      nbead_div = nbead / nprocs_main
      nbead_rem = mod( nbead, nprocs_main )

      do l = 1, nprocs_main

         istart_bead(l) = (l-1) * nbead_div + nbead_rem + 1
         iend_bead(l)   = istart_bead(l) + nbead_div - 1

         if ( (l-1) .lt. nbead_rem ) then
            istart_bead(l) = (l-1) * ( nbead_div + 1 ) + 1
            iend_bead(l)   = istart_bead(l) + nbead_div
         end if

         nbead_paral(l) = iend_bead(l) - istart_bead(l) + 1

      end do

!-----------------------------------------------------------------------
!     //   atom allocation
!-----------------------------------------------------------------------

      natom_div = natom / nprocs_sub
      natom_rem = mod( natom, nprocs_sub )

      do l = 1, nprocs_sub

         istart_atom(l) = (l-1) * natom_div + natom_rem + 1
         iend_atom(l)   = istart_atom(l) + natom_div - 1

         if ( (l-1) .lt. natom_rem ) then
            istart_atom(l) = (l-1) * ( natom_div + 1 ) + 1
            iend_atom(l)   = istart_atom(l) + natom_div
         end if

         natom_paral(l) = iend_atom(l) - istart_atom(l) + 1

      end do

      jstart_bead = istart_bead(myrank_main+1)
      jend_bead   = iend_bead(myrank_main+1)

      jstart_atom = istart_atom(myrank_sub+1)
      jend_atom   = iend_atom(myrank_sub+1)

!-----------------------------------------------------------------------
!     //   end of subroutine
!-----------------------------------------------------------------------

      return
      end
