#ifdef n2p2



!***********************************************************************
      subroutine reset_flag_predict_n2p2_XMPI
!***********************************************************************

      use common_variables, only : myrank
      use n2p2_variables, only : iset_predict
      use n2p2_general_interface, only : &
     &  n2p2_pimd_closeinterface, n2p2_interface_setup, &
     &  n2p2interface_ptr

      iset_predict = 0

      call n2p2_pimd_closeinterface(n2p2interface_ptr)
      call n2p2_interface_setup(myrank, n2p2interface_ptr)

!***********************************************************************
      end subroutine reset_flag_predict_n2p2_XMPI
!***********************************************************************





!***********************************************************************
      subroutine predict_n2p2_XMPI
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, fx, fy, fz, vir, pot, char_spec, boxinv, &
     &   au_length, au_charge, au_energy, box, natom, iounit, &
     &   vir_bead, natom

      use n2p2_variables, only : &
     &   coo_i, coo_j, e_i, fx_i, fy_i, fz_i, vir_i, &
     &   r2_j, type_i, rcut2_n2p2, &
     &   iset_predict, n2p2_lenscale, n2p2_enscale,&
     &   idx_j, neighbor_e, ielement, en_scale_n2p2, len_scale_n2p2, &
     &   n2p2_x, n2p2_y, n2p2_z, n2p2_box, n2p2_box_inv, transfer_size

      use n2p2_general_interface, only : n2p2interface_ptr

      use n2p2_predict_interface, only : &
     &   n2p2_atomic_energy_and_forces

      use neighbor_list_variables, only : neighbor_list, &
     &   atom_navigation, local_atoms, local_beads,      &
     &   neighbor_list_jx, neighbor_list_jy,             &
     &   neighbor_list_jz, max_neighbors, bigbox,        &
     &   bigboxinv, nbox_list

      use iso_c_binding

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

!     //   initialize
      implicit none

!     //   integers
      integer :: m, i, j, n, n_at, jx, jy, jz, & 
     &           idx_1, idx_2, n_beg, n_end

!     //   real variables
      real(8) :: r2, xij, yij, zij, aij, bij, cij

!     //   status
      integer :: stat = 0

!     //   unit conversions
      real(8) :: const_r, const_e, const_f, const_s

!-----------------------------------------------------------------------
!     /*   initialize n2p2                                           */
!-----------------------------------------------------------------------

!     //   on initial entry
      if ( iset_predict .eq. 0 ) then

!        //   Initialize neighbor list variables 
         call initialize_neighbor_list_XMPI &
     &      (sqrt(rcut2_n2p2)/n2p2_lenscale)

!        //   memory allocation: local virial
         if ( .not. allocated(vir_i) ) allocate( vir_i(3,3) )

!        //   memory allocation: local force
         if ( .not. allocated(fx_i) ) allocate( fx_i(natom) )
         if ( .not. allocated(fy_i) ) allocate( fy_i(natom) )
         if ( .not. allocated(fz_i) ) allocate( fz_i(natom) )

!        //   initialize local energy
         e_i = 0.d0

!        //   initialize local virial
         vir_i(:,:) = 0.d0

!        //   set finished
         iset_predict = 1

!     //   on initial entry
      end if

!-----------------------------------------------------------------------
!     /*   unit conversion factor                                     */
!-----------------------------------------------------------------------

!     //   length
      const_r = n2p2_lenscale

!     //   energy
      const_e = n2p2_enscale

!     //   force
      const_f = const_e * const_r

!     //   energy
      const_s = const_e

!-----------------------------------------------------------------------
!     /*   call neighbor list                                         */
!-----------------------------------------------------------------------

!     /*   check maximum deviation and make neighbor list if needed   */
      call make_neighbor_list_XMPI

!     /*   extend transfer arrays if maximum of neighbors grow        */

      if( max_neighbors .gt. transfer_size ) then

         if ( allocated(coo_j) ) deallocate( coo_j )
         allocate( coo_j(3,max_neighbors) )

         if ( allocated(r2_j) ) deallocate( r2_j )
         allocate( r2_j(max_neighbors) )

         if ( allocated( idx_j ) ) deallocate ( idx_j )
         allocate( idx_j(max_neighbors))

         if ( allocated( neighbor_e ) ) deallocate ( neighbor_e )
         allocate( neighbor_e(max_neighbors))

         transfer_size = max_neighbors

      end if

!-----------------------------------------------------------------------
!     /*   if we have length scaling apply it to the coordinates now  */
!-----------------------------------------------------------------------

!     //   length scaling
      if ( len_scale_n2p2 ) then

!        //   position
         n2p2_x(:,:) = x(:,:) * const_r
         n2p2_y(:,:) = y(:,:) * const_r
         n2p2_z(:,:) = z(:,:) * const_r

!        //   box matrix
         n2p2_box(:,:) = box(:,:) * const_r

!        //   inverse of box matrix
         n2p2_box_inv(:,:) = boxinv(:,:) * const_r

!     //   length scaling
      end if

!-----------------------------------------------------------------------
!     /*   execute n2p2 for minimum image convention                  */
!-----------------------------------------------------------------------

!     /*   periodic boundary   */
      if ( nbox_list(1)*nbox_list(2)*nbox_list(3) .eq. 1 ) then

!        /*   bead parallel loop of beads   */
         do idx_1 = 1, size(local_beads)

!           //   bead index
            m = local_beads(idx_1)

!           //   initialize forces
            fx_i(:) = 0.d0
            fy_i(:) = 0.d0
            fz_i(:) = 0.d0

!           //   initialize virial
            vir_i(:,:) = 0.d0

            e_i = 0.0

!           /*   force parallel loop of atom pairs   */
            do idx_2 = 1, size(local_atoms)

               i = local_atoms(idx_2)

!              /*   atomic coordinates   */
               coo_i(1) = n2p2_x(i,m)
               coo_i(2) = n2p2_y(i,m)
               coo_i(3) = n2p2_z(i,m)

!              /*   atomic kind   */
               type_i = trim(char_spec(i))//c_null_char

!              /*  Get the beginning of the local neighbor list  */
               n_beg = atom_navigation( (idx_1 - 1) &
     &                 * size(local_atoms) + idx_2 )

!              /*  Get the end of the local neighbor list  */
               n_end = atom_navigation( (idx_1 - 1) &
     &                 * size(local_atoms) + idx_2+1) - 1

!              /*   clear number of atom pairs   */
               n_at = 0

!              /*   loop of atoms   */
               do n = n_beg, n_end

!                 /*   atom in neighbor list   */
                  j = neighbor_list(n)

!                 /*   interatomic distance   */
                  xij = coo_i(1) - n2p2_x(j,m)
                  yij = coo_i(2) - n2p2_y(j,m)
                  zij = coo_i(3) - n2p2_z(j,m)

!                 /*   apply free or periodic boundary   */
                  call pbc_atom_MPI ( xij, yij, zij )

                  r2 = xij*xij+yij*yij+zij*zij

!                 /*   if distance if further than cutoff skip   */
                  if( r2 > rcut2_n2p2) cycle

!                 /*   update number of atom pairs   */
                  n_at = n_at + 1

!                 /*   atom index   */
                  idx_j(n_at) = j

!                 /*   add the distance to distance array   */
                  r2_j(n_at) = r2

!                 /*   relative interatomic distance   */
                  coo_j(1,n_at) = xij
                  coo_j(2,n_at) = yij
                  coo_j(3,n_at) = zij

!                 /*   atomic kind   */
                  neighbor_e(n_at) = ielement(j)

!              /*   loop of atoms   */
               end do

!              //   predict energy and force
               call n2p2_atomic_energy_and_forces( &
     &            n2p2interface_ptr, i, coo_i, type_i, &
     &            n_at, c_loc(coo_j(1,1)), c_loc(neighbor_e(1)), &
     &            c_loc(idx_j(1)), e_i, c_loc(fx_i(1)), c_loc(fy_i(1)), &
     &            c_loc(fz_i(1)), c_loc(vir_i(1,1)))

!           /*   loop of atom pairs   */
            end do

!           /*   sum potential energy   */
            call my_mpi_allreduce_real_0_sub( e_i )

!           /*   sum virial   */
            call my_mpi_allreduce_real_2_sub( vir_i, 3, 3 )

!           /*   sum forces for local atoms   */
            call my_mpi_reduce_scatter_XMPI( fx_i, fy_i, fz_i, m )

!           /*   substitute virial   */
            vir_bead(:,:,m) = vir_i(:,:)

!           /*   substitute potential energy   */
            pot(m) = pot(m) + e_i

!        /*   loop of beads   */
         end do

!-----------------------------------------------------------------------
!     /*   execute n2p2 for multiple images                           */
!-----------------------------------------------------------------------

!     /*   periodic boundary with replicated boxes   */
      else

!        /*   replicated boxes   */
         bigbox(:,1) = dble(nbox_list(1))*n2p2_box(:,1)
         bigbox(:,2) = dble(nbox_list(2))*n2p2_box(:,2)
         bigbox(:,3) = dble(nbox_list(3))*n2p2_box(:,3)

!        /*   inverse of box matrix   */
         call inv3 ( bigbox, bigboxinv )

!        /*   bead parallel loop of beads   */
         do idx_1 = 1, size(local_beads)

            m = local_beads(idx_1)

!           //  initialize forces
            fx_i(:) = 0.0
            fy_i(:) = 0.0
            fz_i(:) = 0.0

!           //   initialize virial
            vir_i(:,:) = 0.d0

            e_i = 0.0

!           /*   force parallel loop of atom pairs   */
            do idx_2 = 1, size(local_atoms)

               i = local_atoms(idx_2)

!              /*   atomic coordinates   */
               coo_i(1) = n2p2_x(i,m)
               coo_i(2) = n2p2_y(i,m)
               coo_i(3) = n2p2_z(i,m)

!              /*   atomic kind   */
               type_i = trim(char_spec(i)) // c_null_char

!              /*   Get the beginning of local neighbor list  */
               n_beg = atom_navigation( (idx_1 - 1) &
     &             * size(local_atoms) + idx_2 )

!              /*   Get the end of local neighbor list  */
               n_end = atom_navigation( (idx_1 - 1) &
     &             * size(local_atoms) + idx_2+1) - 1

!              /*   clear number of atom pairs   */
               n_at = 0

!              /*   loop of atoms   */
               do n = n_beg, n_end

!                 /*   atom in neighbor list   */
                  j = neighbor_list(n)

!                 /*   replicated boxes   */
                  jx = neighbor_list_jx(n)
                  jy = neighbor_list_jy(n)
                  jz = neighbor_list_jz(n)

!                 /*   interatomic distance of i and j in same box   */
                  xij = coo_i(1) - n2p2_x(j,m)
                  yij = coo_i(2) - n2p2_y(j,m)
                  zij = coo_i(3) - n2p2_z(j,m)

!                 /*   distance of i and j in different box   */
                  xij = xij - n2p2_box(1,1)*jx - n2p2_box(1,2)*jy &
     &                      - n2p2_box(1,3)*jz
                  yij = yij - n2p2_box(2,1)*jx - n2p2_box(2,2)*jy &
     &                      - n2p2_box(2,3)*jz
                  zij = zij - n2p2_box(3,1)*jx - n2p2_box(3,2)*jy &
     &                      - n2p2_box(3,3)*jz

!                  /*   vector in big box   */
                   aij = bigboxinv(1,1)*xij + bigboxinv(1,2)*yij &
     &                 + bigboxinv(1,3)*zij
                   bij = bigboxinv(2,1)*xij + bigboxinv(2,2)*yij &
     &                 + bigboxinv(2,3)*zij
                   cij = bigboxinv(3,1)*xij + bigboxinv(3,2)*yij &
     &                 + bigboxinv(3,3)*zij

!                 /*   apply periodic boundary in big box   */
                  aij = aij - nint(aij)
                  bij = bij - nint(bij)
                  cij = cij - nint(cij)

!                 /*   distance of nearest i and j   */
                  xij = bigbox(1,1)*aij + bigbox(1,2)*bij &
     &                + bigbox(1,3)*cij
                  yij = bigbox(2,1)*aij + bigbox(2,2)*bij &
     &                + bigbox(2,3)*cij
                  zij = bigbox(3,1)*aij + bigbox(3,2)*bij &
     &                + bigbox(3,3)*cij

!                 //   interatomic distance
                  r2 = xij*xij + yij*yij + zij*zij

!                 /*   If distance if further than cutoff skip   */
                  if( r2 > rcut2_n2p2) cycle

!                 /*   update number of atom pairs   */
                  n_at = n_at + 1

!                 //   atomc index
                  idx_j(n_at) = j

!                 /*   Add the distance to distance array   */
                  r2_j(n_at) = r2

!                 //   interatomic distance
                  coo_j(1,n_at) = xij
                  coo_j(2,n_at) = yij
                  coo_j(3,n_at) = zij

!                 /*   atomic kind   */
                  neighbor_e(n_at) = ielement(j)

!           /*   loop of atoms   */
            end do

!           //   predict energy and force
            call n2p2_atomic_energy_and_forces( &
     &         n2p2interface_ptr, i, coo_i, type_i, &
     &         n_at, c_loc(coo_j(1,1)), c_loc(neighbor_e(1)), &
     &         c_loc(idx_j(1)), e_i, c_loc(fx_i(1)), c_loc(fy_i(1)), &
     &         c_loc(fz_i(1)), c_loc(vir_i(1,1)))

!        /*   loop of atom pairs   */
         end do

!        /*   sum potential energy   */
         call my_mpi_allreduce_real_0_sub( e_i )

!        /*   sum virial   */
         call my_mpi_allreduce_real_2_sub( vir_i, 3, 3 )

!        /*   sum forces for local atoms   */
         call my_mpi_reduce_scatter_XMPI(fx_i, fy_i, fz_i, m)

!        /*   substitute potential energy   */
         pot(m) = pot(m) + e_i

!        /*   substitute virial   */
         vir_bead(:,:,m) = vir_i(:,:)

!        /*   loop of beads   */
         end do

!     /*   periodic boundaries   */
      end if
 
!-----------------------------------------------------------------------
!     /*   rescale forces and virial                                  */
!-----------------------------------------------------------------------

!     /*   Scale Forces and Virials from N2P2 units to AU             */
!     /*   If N2P2 units are already AU then this is skipped          */

!     /*   length scaling   */
      if( en_scale_n2p2 .or. len_scale_n2p2 ) then

!        //   potential
         pot(:) = pot(:) * const_e

!        //   virial
         vir(:,:) = vir(:,:) * const_s

!        //   force
         fx(:,:) = fx(:,:) * const_f
         fy(:,:) = fy(:,:) * const_f
         fz(:,:) = fz(:,:) * const_f

!     /*   length scaling   */
      end if

!     //   stop on error
      call error_handling_MPI( stat, 'subroutine predict_n2p2_XMPI', 28)

!     //   end of subroutine
      return

!***********************************************************************
      end subroutine predict_n2p2_XMPI
!***********************************************************************





!***********************************************************************
      subroutine my_mpi_reduce_scatter_XMPI( ux, uy, uz, ibead )
!***********************************************************************
!-----------------------------------------------------------------------
!     //   shared variables
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nprocs_sub, mpi_comm_sub, natom, fx, fy, fz

      use XMPI_variables, only : &
     &   istart_atom, iend_atom

      use neighbor_list_variables, only: local_atoms

!-----------------------------------------------------------------------
!     //   local variables
!-----------------------------------------------------------------------

!     //   reset
      implicit none

!     //   mpi
      include 'mpif.h'

!     //   tentative forces on sub-communicator
      real(8) :: ux(natom), uy(natom), uz(natom)

!     //   number atoms in sub-communicator
      integer :: counts(nprocs_sub)

!     //   integers
      integer :: i, idx_2, l, ierr, ibead

!-----------------------------------------------------------------------
!     //   reduce_scatter of atoms (for jstart < i < jend)
!-----------------------------------------------------------------------

!     //   create number atoms in sub-communicator
      do l = 1, nprocs_sub
         counts(l) = iend_atom(l) - istart_atom(l) + 1
      end do

!     //   communicate and get sum of local force

      call mpi_reduce_scatter ( mpi_in_place, ux, counts, &
     &               mpi_double_precision, mpi_sum, mpi_comm_sub, ierr )
      call mpi_reduce_scatter ( mpi_in_place, uy, counts, &
     &               mpi_double_precision, mpi_sum, mpi_comm_sub, ierr )
      call mpi_reduce_scatter ( mpi_in_place, uz, counts, &
     &               mpi_double_precision, mpi_sum, mpi_comm_sub, ierr )

!-----------------------------------------------------------------------
!     /*   Update force                                               */
!-----------------------------------------------------------------------

!     //   loop of local atoms
      do idx_2 = 1, size(local_atoms)

!        //   atom index
         i = local_atoms(idx_2)

!        //   add force contributions
         fx(i,ibead) = fx(i,ibead) + ux(idx_2)
         fy(i,ibead) = fy(i,ibead) + uy(idx_2)
         fz(i,ibead) = fz(i,ibead) + uz(idx_2)

!     //   loop of atoms
      end do

      return
      end


#endif

