!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 28, 2019 by M. Shiga
!      Description:     polymers main routine
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      program polymers_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : code

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   name of the code                                           */
!-----------------------------------------------------------------------

      code = 'POLYMERS'

!-----------------------------------------------------------------------
!     /*  initialize MPI                                              */
!-----------------------------------------------------------------------

      call my_mpi_init_3

!-----------------------------------------------------------------------
!     /*   print titles                                               */
!-----------------------------------------------------------------------

      call print_titles_MPI

!-----------------------------------------------------------------------
!     /*   set parameters                                             */
!-----------------------------------------------------------------------

      call setparams_MPI

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      call setallocation

!-----------------------------------------------------------------------
!     /*   prepare condition                                          */
!-----------------------------------------------------------------------

      call setcondition_MPI

!-----------------------------------------------------------------------
!     /*   setup polymers                                             */
!-----------------------------------------------------------------------

      call setup_polymers_MPI

!-----------------------------------------------------------------------
!     /*   initialize external programs                               */
!-----------------------------------------------------------------------

      call init_extprograms_MPI

!-----------------------------------------------------------------------
!     /*   main cycle of polymers                                     */
!-----------------------------------------------------------------------

      call main_polymers_MPI

!-----------------------------------------------------------------------
!     /*   initialize external programs                               */
!-----------------------------------------------------------------------

      call finalize_extprograms_MPI

!-----------------------------------------------------------------------
!     /*  finalize MPI                                                */
!-----------------------------------------------------------------------

      call my_mpi_finalize_3

      stop
      end
