!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pimdcycle_nvt_mnhc_XMPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type III.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   preparation of parallel MPI   */
      call prep_XMPI

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_XMPI(0)

!     /*   get interatomic forces   */
      call getforce_XMPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_XMPI(1)

!     /*   get harmonic force  */
      call getforce_ref_XMPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_mnhc_XMPI

!     /*   do some analysis   */
      call analysis_XMPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent_XMPI

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_XMPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref_XMPI

!           /*   update all the normal mode coordinates   */
            call update_pos_XMPI

!           /*   get harmonic forces   */
            call getforce_ref_XMPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref_XMPI

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_XMPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_XMPI(0)

!        /*   get interatomic forces   */
         call getforce_XMPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_XMPI(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent_XMPI

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_XMPI(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_mnhc_XMPI

!        /*   do some analysis   */
         call analysis_XMPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_mnhc_XMPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine cmdcycle_XMPI
!***********************************************************************
!-----------------------------------------------------------------------
!
!     The CMD molecular dynamics cycle.
!
!-----------------------------------------------------------------------

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   preparation of parallel MPI   */
      call prep_XMPI

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_XMPI( 0 )

!     /*   get interatomic forces   */
      call getforce_XMPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_XMPI( 1 )

!     /*   get harmonic force  */
      call getforce_ref_XMPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_cmd_0_XMPI

!     /*   do some analysis   */
      call analysis_XMPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!c        /*   update thermostats attached to centroids  */
!         call update_nhc_cent_XMPI

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_XMPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref_XMPI

!           /*   update all the normal mode coordinates   */
            call update_pos_XMPI

!           /*   get harmonic forces   */
            call getforce_ref_XMPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref_XMPI

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_XMPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_XMPI( 0 )

!        /*   get interatomic forces   */
         call getforce_XMPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_XMPI( 1 )

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!c        /*   update thermostats attached to centroids  */
!         call update_nhc_cent_XMPI

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_XMPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_cmd_0_XMPI

!        /*   do some analysis   */
         call analysis_XMPI ( 2 )

!        /*   output restart   */
         call backup_cmd_XMPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
