!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral molecular dynamics (NVT)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pimdcycle_nvt_nhc_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   without constraints                                        */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call pimdcycle_nvt_nhc_0_MPI
      else

         call pimdcycle_nvt_nhc_cons_MPI

      end if

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhcs_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   without constraints                                        */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call pimdcycle_nvt_nhcs_0_MPI
      else

         call pimdcycle_nvt_nhcs_cons_MPI

      end if

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_mnhc_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   without constraints                                        */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call pimdcycle_nvt_mnhc_0_MPI
      else

         call pimdcycle_nvt_mnhc_cons_MPI

      end if

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhc_0_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type I.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_MPI(0)

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_MPI(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhc_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_MPI(0)

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_MPI(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_MPI(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhc_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhcs_0_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type II.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_MPI(0)

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_MPI(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhcs_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_MPI(0)

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_MPI(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_MPI(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhcs_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhcs_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_mnhc_0_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type III.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_MPI(0)

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_MPI(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_mnhc_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_MPI(0)

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_MPI(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_MPI(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_mnhc_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_mnhc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhc_cons_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type I.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_MPI(0)

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_MPI(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   get constrained force  */
      call getforce_ref_cons_cent_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhc_cons_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   get constrained force  */
            call getforce_ref_cons_cent_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_MPI(0)

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_MPI(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_MPI(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhc_cons_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhcs_cons_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type II.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_MPI(0)

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_MPI(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   get constrained force  */
      call getforce_ref_cons_cent_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhcs_cons_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   get constrained force  */
            call getforce_ref_cons_cent_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_MPI(0)

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_MPI(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_MPI(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhcs_cons_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhcs_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_mnhc_cons_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type III.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_MPI(0)

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_MPI(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   get constrained force  */
      call getforce_ref_cons_cent_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_mnhc_cons_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   get constrained force  */
            call getforce_ref_cons_cent_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_MPI(0)

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_MPI(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_MPI(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_mnhc_cons_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_mnhc_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
