!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral molecular dynamics (NVT)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pimdcycle_nvt_nhc
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   without constraints                                        */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call pimdcycle_nvt_nhc_0
      else

         call pimdcycle_nvt_nhc_cons

      end if

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhcs
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   without constraints                                        */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call pimdcycle_nvt_nhcs_0
      else

         call pimdcycle_nvt_nhcs_cons

      end if

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_mnhc
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   without constraints                                        */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call pimdcycle_nvt_mnhc_0
      else

         call pimdcycle_nvt_mnhc_cons

      end if

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhc_0
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type I.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhc

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhc

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhcs_0
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type II.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhcs

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhcs

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhcs

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_mnhc_0
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type III.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_mnhc

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_mnhc

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_mnhc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhc_cons
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type I.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   get constrained force  */
      call getforce_ref_cons_cent

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhc_cons

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   get constrained force  */
            call getforce_ref_cons_cent

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhc_cons

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_nhcs_cons
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type II.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   get constrained force  */
      call getforce_ref_cons_cent

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_nhcs_cons

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   get constrained force  */
            call getforce_ref_cons_cent

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_nhcs_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_nhcs_cons

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_nhcs

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nvt_mnhc_cons
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  thermostat type III.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   get constrained force  */
      call getforce_ref_cons_cent

!     /*   calculate the hamiltonian and temperature   */
      call standard_nvt_mnhc_cons

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   get constrained force  */
            call getforce_ref_cons_cent

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nvt_mnhc_cons

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nvt_mnhc

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end

