!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral molecular dynamics (NVE)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pimdcycle_nve
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   without constraints                                        */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call pimdcycle_nve_0
      else

         call pimdcycle_nve_cons

      end if

      return
      end





!***********************************************************************
      subroutine pimdcycle_nve_0
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  no thermostat.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_nve_0

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nve_0

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nve

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nve_cons
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  no thermostat.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans(0)

!     /*   get interatomic forces   */
      call getforce

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force(1)

!     /*   get harmonic force  */
      call getforce_ref

!     /*   get constrained force  */
      call getforce_ref_cons_cent

!     /*   calculate the hamiltonian and temperature   */
      call standard_nve_cons

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   start multiple time step cycle   */
         do iref = 1, nref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update all the normal mode coordinates   */
            call update_pos

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   get constrained force  */
            call getforce_ref_cons_cent

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

         end do

!        /*   normal mode position -> Cartesian position   */
         call nm_trans(0)

!        /*   get interatomic forces   */
         call getforce

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force(1)

!        /*   update the velocities by interatomic forces   */
         call update_vel

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity(0)

!        /*   calculate the hamiltonian and temperature   */
         call standard_nve_cons

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_nve

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
