!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral molecular dynamics (NPH)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pimdcycle_ntt_pp
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  flexible cell.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, nref, iref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   get interatomic forces   */
      call getforce

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force( 1 )

!     /*   get harmonic forces   */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_ntt_pp

!     /*   do some analysis   */
      call analysis ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to box  */
         call update_mnhc_box_pp

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update volume velocity   */
         call update_vel_box_nth_pp

!        /*   update centroid and non-centroid velocities   */
         call update_vel

         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

!           /*   update volume   */
            call update_pos_box_nth_pp

!           /*   update centroid velocities   */
            call update_vel_cent_nth_pp

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update centroid position   */
            call update_pos_ntt_pp

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update centroid velocities   */
            call update_vel_cent_nth_pp

!           /*   update volume   */
            call update_pos_box_nth_pp

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode

         end do

!        /*   normal mode position -> cartesian position   */
         call nm_trans( 0 )

!        /*   get interatomic forces   */
         call getforce

!        /*   cartesian force -> normal mode force   */
         call nm_trans_force( 1 )

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update volume velocity   */
         call update_vel_box_nth_pp

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update thermostats attached to box  */
         call update_mnhc_box_pp

!        /*   normal mode velocity -> cartesian velocity   */
         call nm_trans_velocity( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_ntt_pp

!        /*   do some analysis   */
         call analysis ( 2 )

!        /*   output restart   */
         call backup_pimd_ntt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end

