!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral molecular dynamics (NPH)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pimdcycle_npt_c2_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  flexible cell.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, nref, iref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans_MPI( 0 )

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force_MPI( 1 )

!     /*   get harmonic forces   */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_npt_c2_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to box  */
         call update_mnhc_box_c2

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update volume velocity   */
         call update_vel_box_nph_c2

!        /*   update centroid and non-centroid velocities   */
         call update_vel

         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update volume   */
            call update_pos_box_nph_c2

!           /*   update centroid velocities   */
            call update_vel_cent_nph_c2

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update centroid position   */
            call update_pos_npt_c2

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update centroid velocities   */
            call update_vel_cent_nph_c2

!           /*   update volume   */
            call update_pos_box_nph_c2

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> cartesian position   */
         call nm_trans_MPI( 0 )

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   cartesian force -> normal mode force   */
         call nm_trans_force_MPI( 1 )

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update volume velocity   */
         call update_vel_box_nph_c2

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update thermostats attached to box  */
         call update_mnhc_box_c2

!        /*   normal mode velocity -> cartesian velocity   */
         call nm_trans_velocity_MPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_npt_c2_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_npt_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_npt_pp_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  flexible cell.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, nref, iref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans_MPI( 0 )

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force_MPI( 1 )

!     /*   get harmonic forces   */
      call getforce_ref

!     /*   calculate the hamiltonian and temperature   */
      call standard_npt_pp_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   broadcast barostat info   */
         call my_mpi_bcast_box

!        /*   update thermostats attached to box  */
         call update_mnhc_box_pp

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update volume velocity   */
         call update_vel_box_nph_pp

!        /*   update centroid and non-centroid velocities   */
         call update_vel

         do iref = 1, nref

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

!           /*   update volume   */
            call update_pos_box_nph_pp_MPI

!           /*   update centroid velocities   */
            call update_vel_cent_nph_pp_MPI

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update centroid position   */
            call update_pos_npt_pp_MPI

!           /*   get harmonic forces   */
            call getforce_ref

!           /*   update the velocities by harmonic forces   */
            call update_vel_ref

!           /*   update centroid velocities   */
            call update_vel_cent_nph_pp_MPI

!           /*   update volume   */
            call update_pos_box_nph_pp_MPI

!           /*  update thermostats attached to non-centroid modes  */
            call update_mnhc_mode_MPI

         end do

!        /*   normal mode position -> cartesian position   */
         call nm_trans_MPI( 0 )

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   cartesian force -> normal mode force   */
         call nm_trans_force_MPI( 1 )

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update volume velocity   */
         call update_vel_box_nph_pp

!        /*   update thermostats attached to centroids  */
         call update_mnhc_cent

!        /*   update thermostats attached to box  */
         call update_mnhc_box_pp

!        /*   normal mode velocity -> cartesian velocity   */
         call nm_trans_velocity_MPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_npt_pp_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_npt_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end

