!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral molecular dynamics (NPH)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pimdcycle_nph_c1_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  flexible cell.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, nref, iref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans_MPI( 0 )

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force_MPI( 1 )

!     /*   calculate the hamiltonian and temperature   */
      call standard_nph_c1_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update volume velocity   */
         call update_vel_box_nph_c1

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update non-centroid position and velocity  */
         call update_mode_nph

         do iref = 1, nref

!           /*   update volume   */
            call update_pos_box_nph_c1

!           /*   update centroid velocities   */
            call update_vel_cent_nph_c1

!           /*   update centroid position   */
            call update_pos_cent_nph_c1

!           /*   update centroid velocities   */
            call update_vel_cent_nph_c1

!           /*   update volume   */
            call update_pos_box_nph_c1

         end do

!        /*   normal mode position -> cartesian position   */
         call nm_trans_MPI( 0 )

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   cartesian force -> normal mode force   */
         call nm_trans_force_MPI( 1 )

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update volume velocity   */
         call update_vel_box_nph_c1

!        /*   normal mode velocity -> cartesian velocity   */
         call nm_trans_velocity_MPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_nph_c1_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nph_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nph_c2_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  flexible cell.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, nref, iref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans_MPI( 0 )

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force_MPI( 1 )

!     /*   calculate the hamiltonian and temperature   */
      call standard_nph_c2_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update volume velocity   */
         call update_vel_box_nph_c2

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update non-centroid position and velocity  */
         call update_mode_nph

         do iref = 1, nref

!           /*   update volume   */
            call update_pos_box_nph_c2

!           /*   update centroid velocities   */
            call update_vel_cent_nph_c2

!           /*   update centroid position   */
            call update_pos_cent_nph_c2

!           /*   update centroid velocities   */
            call update_vel_cent_nph_c2

!           /*   update volume   */
            call update_pos_box_nph_c2

         end do

!        /*   normal mode position -> cartesian position   */
         call nm_trans_MPI( 0 )

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   cartesian force -> normal mode force   */
         call nm_trans_force_MPI( 1 )

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update volume velocity   */
         call update_vel_box_nph_c2

!        /*   normal mode velocity -> cartesian velocity   */
         call nm_trans_velocity_MPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_nph_c2_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nph_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pimdcycle_nph_pp_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  flexible cell.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, nref, iref

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans_MPI( 0 )

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force_MPI( 1 )

!     /*   calculate the hamiltonian and temperature   */
      call standard_nph_pp_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   broadcast barostat info   */
         call my_mpi_bcast_box

!        /*   update volume velocity   */
         call update_vel_box_nph_pp

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update non-centroid position and velocity  */
         call update_mode_nph

         do iref = 1, nref

!           /*   update volume   */
            call update_pos_box_nph_pp_MPI

!           /*   update centroid velocities   */
            call update_vel_cent_nph_pp_MPI

!           /*   update centroid position   */
            call update_pos_cent_nph_pp_MPI

!           /*   update centroid velocities   */
            call update_vel_cent_nph_pp_MPI

!           /*   update volume   */
            call update_pos_box_nph_pp_MPI

         end do

!        /*   normal mode position -> cartesian position   */
         call nm_trans_MPI( 0 )

!        /*   get interatomic forces   */
         call getforce_MPI

!        /*   cartesian force -> normal mode force   */
         call nm_trans_force_MPI( 1 )

!        /*   update centroid and non-centroid velocities   */
         call update_vel

!        /*   update volume velocity   */
         call update_vel_box_nph_pp

!        /*   normal mode velocity -> cartesian velocity   */
         call nm_trans_velocity_MPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_nph_pp_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_pimd_nph_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end

