!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral hybrid Monte Carlo (NVT)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pihmccycle_second_nvt_MPI
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans_MPI( 0 )

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force_MPI( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_second_hmc_nvt_MPI

!     /*   save data   */
      call save_second_hmc_nvt

!     /*   adjust HMC step   */
      call adjust_step_hmc_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc_MPI

!     /*   do some analysis   */
      call analysis_second_hmc_MPI( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel

!           /*   update all the normal mode coordinates   */
            call update_posvel_anal

!           /*   normal mode position -> cartesian position   */
            call nm_trans_MPI( 0 )

!           /*   get interatomic forces   */
            call getforce_MPI

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force_MPI( 1 )

!           /*   update the velocities by interatomic forces   */
            call update_vel

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity_MPI( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_second_hmc_nvt_MPI

!        /*   judge accept or reject   */
         call judge_second_hmc_nvt_MPI

!        /*   adjust HMC step   */
         call adjust_step_hmc_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc_MPI

!        /*   do some analysis   */
         call analysis_second_hmc_MPI ( 2 )

!        /*   output restart   */
         call backup_pihmc_second_nvt_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end






!***********************************************************************
      subroutine pihmccycle_fourth_nvt_MPI
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans_MPI( 0 )

!     /*   get interatomic forces   */
      call getforce_MPI

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force_MPI( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_fourth_hmc_nvt_MPI

!     /*   save data   */
      call save_fourth_hmc_nvt

!     /*   adjust HMC step   */
      call adjust_step_hmc_MPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc_MPI

!     /*   do some analysis   */
      call analysis_fourth_hmc_MPI ( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update the velocities by interatomic forces   */
            call update_vel

!           /*   update all the normal mode coordinates   */
            call update_posvel_anal

!           /*   normal mode position -> cartesian position   */
            call nm_trans_MPI( 0 )

!           /*   get interatomic forces   */
            call getforce_MPI

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force_MPI( 1 )

!           /*   update the velocities by interatomic forces   */
            call update_vel

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity_MPI( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_fourth_hmc_nvt_MPI

!        /*   judge accept or reject   */
         call judge_fourth_hmc_nvt_MPI

!        /*   adjust HMC step   */
         call adjust_step_hmc_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc_MPI

!        /*   do some analysis   */
         call analysis_fourth_hmc_MPI ( 2 )

!        /*   output restart   */
         call backup_pihmc_fourth_nvt_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end

