!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     path integral hybrid Monte Carlo (NPT)
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pihmccycle_second_npt_c1
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc, &
     &   iref, nref

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   get interatomic forces   */
      call getforce

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_second_hmc_npt_c1

!     /*   save data   */
      call save_second_hmc_npt

!     /*   adjust HMC step   */
      call adjust_step_hmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc

!     /*   do some analysis   */
      call analysis_second_hmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update volume velocity   */
            call update_vel_box_nph_c1

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update non-centroid position and velocity  */
            call update_mode_nph

            do iref = 1, nref

!              /*   update volume   */
               call update_pos_box_nph_c1

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c1

!              /*   update centroid position   */
               call update_pos_cent_nph_c1

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c1

!              /*   update volume   */
               call update_pos_box_nph_c1

            end do

!           /*   normal mode position -> cartesian position   */
            call nm_trans( 0 )

!           /*   get interatomic forces   */
            call getforce

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force( 1 )

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update volume velocity   */
            call update_vel_box_nph_c1

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_second_hmc_npt_c1

!        /*   judge accept or reject   */
         call judge_second_hmc_npt_c1

!        /*   adjust HMC step   */
         call adjust_step_hmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc

!        /*   do some analysis   */
         call analysis_second_hmc( 2 )

!        /*   output restart   */
         call backup_pihmc_second_npt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pihmccycle_second_npt_c2
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc, &
     &   iref, nref

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   get interatomic forces   */
      call getforce

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_second_hmc_npt_c2

!     /*   save data   */
      call save_second_hmc_npt

!     /*   adjust HMC step   */
      call adjust_step_hmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc

!     /*   do some analysis   */
      call analysis_second_hmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update volume velocity   */
            call update_vel_box_nph_c2

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update non-centroid position and velocity  */
            call update_mode_nph

            do iref = 1, nref

!              /*   update volume   */
               call update_pos_box_nph_c2

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c2

!              /*   update centroid position   */
               call update_pos_cent_nph_c2

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c2

!              /*   update volume   */
               call update_pos_box_nph_c2

            end do

!           /*   normal mode position -> cartesian position   */
            call nm_trans( 0 )

!           /*   get interatomic forces   */
            call getforce

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force( 1 )

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update volume velocity   */
            call update_vel_box_nph_c2

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_second_hmc_npt_c2

!        /*   judge accept or reject   */
         call judge_second_hmc_npt_c2

!        /*   adjust HMC step   */
         call adjust_step_hmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc

!        /*   do some analysis   */
         call analysis_second_hmc( 2 )

!        /*   output restart   */
         call backup_pihmc_second_npt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pihmccycle_second_npt_pp
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc, &
     &   iref, nref

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   get interatomic forces   */
      call getforce

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_second_hmc_npt_pp

!     /*   save data   */
      call save_second_hmc_npt

!     /*   adjust HMC step   */
      call adjust_step_hmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc

!     /*   do some analysis   */
      call analysis_second_hmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update volume velocity   */
            call update_vel_box_nph_pp

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update non-centroid position and velocity  */
            call update_mode_nph

            do iref = 1, nref

!              /*   update volume   */
               call update_pos_box_nph_pp

!              /*   update centroid velocities   */
               call update_vel_cent_nph_pp

!              /*   update centroid position   */
               call update_pos_cent_nph_pp

!              /*   update centroid velocities   */
               call update_vel_cent_nph_pp

!              /*   update volume   */
               call update_pos_box_nph_pp

            end do

!           /*   normal mode position -> cartesian position   */
            call nm_trans( 0 )

!           /*   get interatomic forces   */
            call getforce

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force( 1 )

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update volume velocity   */
            call update_vel_box_nph_pp

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_second_hmc_npt_pp

!        /*   judge accept or reject   */
         call judge_second_hmc_npt_pp

!        /*   adjust HMC step   */
         call adjust_step_hmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc

!        /*   do some analysis   */
         call analysis_second_hmc( 2 )

!        /*   output restart   */
         call backup_pihmc_second_npt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pihmccycle_fourth_npt_c1
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc, &
     &   iref, nref

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   get interatomic forces   */
      call getforce

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_fourth_hmc_npt_c1

!     /*   save data   */
      call save_fourth_hmc_npt

!     /*   adjust HMC step   */
      call adjust_step_hmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc

!     /*   do some analysis   */
      call analysis_fourth_hmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update volume velocity   */
            call update_vel_box_nph_c1

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update non-centroid position and velocity  */
            call update_mode_nph

            do iref = 1, nref

!              /*   update volume   */
               call update_pos_box_nph_c1

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c1

!              /*   update centroid position   */
               call update_pos_cent_nph_c1

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c1

!              /*   update volume   */
               call update_pos_box_nph_c1

            end do

!           /*   normal mode position -> cartesian position   */
            call nm_trans( 0 )

!           /*   get interatomic forces   */
            call getforce

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force( 1 )

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update volume velocity   */
            call update_vel_box_nph_c1

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_fourth_hmc_npt_c1

!        /*   judge accept or reject   */
         call judge_fourth_hmc_npt_c1

!        /*   adjust HMC step   */
         call adjust_step_hmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc

!        /*   do some analysis   */
         call analysis_fourth_hmc( 2 )

!        /*   output restart   */
         call backup_pihmc_fourth_npt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pihmccycle_fourth_npt_c2
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc, &
     &   iref, nref

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   get interatomic forces   */
      call getforce

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_fourth_hmc_npt_c2

!     /*   save data   */
      call save_fourth_hmc_npt

!     /*   adjust HMC step   */
      call adjust_step_hmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc

!     /*   do some analysis   */
      call analysis_fourth_hmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update volume velocity   */
            call update_vel_box_nph_c2

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update non-centroid position and velocity  */
            call update_mode_nph

            do iref = 1, nref

!              /*   update volume   */
               call update_pos_box_nph_c2

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c2

!              /*   update centroid position   */
               call update_pos_cent_nph_c2

!              /*   update centroid velocities   */
               call update_vel_cent_nph_c2

!              /*   update volume   */
               call update_pos_box_nph_c2

            end do

!           /*   normal mode position -> cartesian position   */
            call nm_trans( 0 )

!           /*   get interatomic forces   */
            call getforce

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force( 1 )

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update volume velocity   */
            call update_vel_box_nph_c2

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_fourth_hmc_npt_c2

!        /*   judge accept or reject   */
         call judge_fourth_hmc_npt_c2

!        /*   adjust HMC step   */
         call adjust_step_hmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc

!        /*   do some analysis   */
         call analysis_fourth_hmc( 2 )

!        /*   output restart   */
         call backup_pihmc_fourth_npt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine pihmccycle_fourth_npt_pp
!***********************************************************************
!=======================================================================
!
!     path integral hybrid monte carlo cycle.
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   iexit, istep, istep_start, istep_end, nstep, istep_hmc, &
     &   iref, nref

!     /*   shared variables   */
      use hmc_variables, only : &
     &   jstep

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> cartesian position   */
      call nm_trans( 0 )

!     /*   get interatomic forces   */
      call getforce

!     /*   cartesian force -> normal mode force   */
      call nm_trans_force( 1 )

!     /*   get harmonic force  */
      call getforce_ref

!     /*   energy   */
      call getenergy_fourth_hmc_npt_pp

!     /*   save data   */
      call save_fourth_hmc_npt

!     /*   adjust HMC step   */
      call adjust_step_hmc

!     /*   calculate the hamiltonian and temperature   */
      call standard_hmc

!     /*   do some analysis   */
      call analysis_fourth_hmc( 1 )

!     /*   start main cycle   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   start molecular dynamics cycle   */
         do jstep = 1, istep_hmc

!           /*   update volume velocity   */
            call update_vel_box_nph_pp

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update non-centroid position and velocity  */
            call update_mode_nph

            do iref = 1, nref

!              /*   update volume   */
               call update_pos_box_nph_pp

!              /*   update centroid velocities   */
               call update_vel_cent_nph_pp

!              /*   update centroid position   */
               call update_pos_cent_nph_pp

!              /*   update centroid velocities   */
               call update_vel_cent_nph_pp

!              /*   update volume   */
               call update_pos_box_nph_pp

            end do

!           /*   normal mode position -> cartesian position   */
            call nm_trans( 0 )

!           /*   get interatomic forces   */
            call getforce

!           /*   cartesian force -> normal mode force   */
            call nm_trans_force( 1 )

!           /*   update centroid and non-centroid velocities   */
            call update_vel

!           /*   update volume velocity   */
            call update_vel_box_nph_pp

!           /*   normal mode velocity -> cartesian velocity   */
            call nm_trans_velocity( 0 )

!        /*   end of molecular dynamics cycle   */
         end do

!        /*   energy   */
         call getenergy_fourth_hmc_npt_pp

!        /*   judge accept or reject   */
         call judge_fourth_hmc_npt_pp

!        /*   adjust HMC step   */
         call adjust_step_hmc

!        /*   calculate the hamiltonian and temperature   */
         call standard_hmc

!        /*   do some analysis   */
         call analysis_fourth_hmc( 2 )

!        /*   output restart   */
         call backup_pihmc_fourth_npt

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

!     /*   end of main cycle   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end

