!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jun 29, 2025 by M. Shiga
!      Description:     brownian chain molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pibcmdcycle_XMPI
!***********************************************************************
!=======================================================================
!
!     path integral brownian chain molecular dynamics cycle
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, kickstep_bcmd

!     /*   local variables   */
      implicit none

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   preparation of parallel MPI   */
      call prep_XMPI

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_XMPI( 0 )

!     /*   get interatomic forces   */
      call getforce_XMPI

!     /*   Cartesian force -> normal mode force   */
      call nm_trans_force_XMPI( 1 )

!     /*   get harmonic force  */
      call getforce_ref_XMPI

!     /*   calculate the hamiltonian and temperature   */
      call standard_pibcmd_0_XMPI

!     /*   do some analysis   */
      call analysis_XMPI ( 1 )

!     /*   main loop start   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   random mode velocity   */
         if ( mod(istep,kickstep_bcmd) .eq. 0 ) then
            call nm_velocity_mode_XMPI
         end if

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!        /*   update all the normal mode coordinates   */
         call update_posvel_anal_XMPI

!        /*   normal mode position -> Cartesian position   */
         call nm_trans_XMPI( 0 )

!        /*   get interatomic forces   */
         call getforce_XMPI

!        /*   Cartesian force -> normal mode force   */
         call nm_trans_force_XMPI( 1 )

!        /*   update the velocities by interatomic forces   */
         call update_vel_XMPI

!        /*   normal mode velocity -> Cartesian velocity   */
         call nm_trans_velocity_XMPI( 0 )

!        /*   calculate the hamiltonian and temperature   */
         call standard_pibcmd_0_XMPI

!        /*   do some analysis   */
         call analysis_XMPI ( 2 )

!        /*   output restart   */
         call backup_pibcmd_XMPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

!     /*   main loop end   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end
