!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     boundary condition of collective variables
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pbc_tass( ioption, f )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption

      real(8) :: f

!-----------------------------------------------------------------------
!     /*   periodic boundary condition                                */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         f = f - 360.d0 * nint( f / 360.d0 )

      else

         continue

      end if

      return
      end





!***********************************************************************
      subroutine pbc_cv_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : nbead

      use tass_variables, only : rtass, ntass, ipbc_tass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   periodic boundary condition                                */
!-----------------------------------------------------------------------

      do i = 1, ntass

         if ( ipbc_tass(i) .eq. 1 ) then

            do j = 1, nbead
               rtass(i,j) = rtass(i,j) - 360.d0*nint(rtass(i,j)/360.d0)
            end do

         else

            continue

         end if

      end do

      return
      end
