!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     boundary condition of collective variables
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pbc_meta( ioption, f )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption

      real(8) :: f

!-----------------------------------------------------------------------
!     /*   periodic boundary condition                                */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         f = f - 360.d0 * nint( f / 360.d0 )

      else

         continue

      end if

      return
      end





!***********************************************************************
      subroutine pbc_cv_meta
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : nbead

      use meta_variables, only : rmeta, nmeta, ipbc_meta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   periodic boundary condition                                */
!-----------------------------------------------------------------------

      do i = 1, nmeta

         if ( ipbc_meta(i) .eq. 1 ) then

            do j = 1, nbead
               rmeta(i,j) = rmeta(i,j) - 360.d0*nint(rmeta(i,j)/360.d0)
            end do

         else

            continue

         end if

      end do

      return
      end
