!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga, H. Kimizuka
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pbc_cent_XMPI
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   ux, uy, uz, box, boxinv, iboundary, mbox, &
     &   myrank_main, nprocs_sub, mpi_comm_sub

      use XMPI_variables, only : &
     &   jstart_atom, jend_atom, jstart_bead, istart_atom, iend_atom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      include "mpif.h"

      integer :: i, l, ierr

      real(8) :: ac, bc, cc, da, db, dc, dx, dy, dz, xc, yc, zc

      integer :: disps(nprocs_sub), counts(nprocs_sub)

!-----------------------------------------------------------------------
!     /*   periodic boundary for path integrals                       */
!-----------------------------------------------------------------------

      if      ( iboundary .eq. 0 ) then

         continue

      else if ( iboundary .eq. 1 ) then

         if ( jstart_bead .eq. 1 ) then

            do i = jstart_atom, jend_atom

!              /*   shift according to centroids   */

               xc = ux(i,1)
               yc = uy(i,1)
               zc = uz(i,1)

               ac = boxinv(1,1)*xc + boxinv(1,2)*yc + boxinv(1,3)*zc
               bc = boxinv(2,1)*xc + boxinv(2,2)*yc + boxinv(2,3)*zc
               cc = boxinv(3,1)*xc + boxinv(3,2)*yc + boxinv(3,3)*zc

               mbox(1,i,1) = mbox(1,i,1) + nint(ac-0.5d0)
               mbox(2,i,1) = mbox(2,i,1) + nint(bc-0.5d0)
               mbox(3,i,1) = mbox(3,i,1) + nint(cc-0.5d0)

               da = - dble(nint(ac-0.5d0))
               db = - dble(nint(bc-0.5d0))
               dc = - dble(nint(cc-0.5d0))

               dx = box(1,1)*da + box(1,2)*db + box(1,3)*dc
               dy = box(2,1)*da + box(2,2)*db + box(2,3)*dc
               dz = box(3,1)*da + box(3,2)*db + box(3,3)*dc

!              /*   shift to the range 0 < x < box   */

               ux(i,1) = xc + dx
               uy(i,1) = yc + dy
               uz(i,1) = zc + dz

            end do

         end if

      else if ( iboundary .eq. 2 ) then

         continue

      end if

!-----------------------------------------------------------------------
!     /*   communicate mbox(:,:,1) ... centroids only                 */
!-----------------------------------------------------------------------

!     //   centroid communicators
      if ( myrank_main .eq. 0 ) then

         do l = 1, nprocs_sub
            counts(l) = 3 * ( iend_atom(l) - istart_atom(l) + 1 )
         end do

         disps(1) = 0
         do l = 2, nprocs_sub
            disps(l) = disps(l-1) + counts(l-1)
         end do

!        //   share mbox(:,:,1) among centroid communicators of atoms
         call mpi_allgatherv( &
     &      mpi_in_place, 0, mpi_datatype_null, mbox(1,1,1), &
     &      counts, disps, &
     &      mpi_integer, mpi_comm_sub, ierr )

!     //   centroid communicators
      end if

      return
      end
