!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     periodic boundary for phonon calculations
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pbc_atom_prim ( xi, yi, zi )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use phonon_variables, only: box_prim, boxinv_prim

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   real numbers   */
      real(8) :: ai, bi, ci, xi, yi, zi

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      ai = boxinv_prim(1,1)*xi &
     &   + boxinv_prim(1,2)*yi &
     &   + boxinv_prim(1,3)*zi

      bi = boxinv_prim(2,1)*xi &
     &   + boxinv_prim(2,2)*yi &
     &   + boxinv_prim(2,3)*zi

      ci = boxinv_prim(3,1)*xi &
     &   + boxinv_prim(3,2)*yi &
     &   + boxinv_prim(3,3)*zi

!     /*   shift to the range -box/2 < x < +box/2   */

      ai = ai - nint(ai)
      bi = bi - nint(bi)
      ci = ci - nint(ci)

      xi = box_prim(1,1)*ai + box_prim(1,2)*bi + box_prim(1,3)*ci
      yi = box_prim(2,1)*ai + box_prim(2,2)*bi + box_prim(2,3)*ci
      zi = box_prim(3,1)*ai + box_prim(3,2)*bi + box_prim(3,3)*ci

      return
      end
