!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     periodic boundary condition for atoms
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine pbc_atom ( xi, yi, zi )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : iboundary, box, boxinv

      implicit none

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      real(8) :: ai, bi, ci, xi, yi, zi

!-----------------------------------------------------------------------
!     /*   apply boundary condition                                   */
!-----------------------------------------------------------------------

      if      ( iboundary .eq. 1 ) then

         ai = boxinv(1,1)*xi + boxinv(1,2)*yi + boxinv(1,3)*zi
         bi = boxinv(2,1)*xi + boxinv(2,2)*yi + boxinv(2,3)*zi
         ci = boxinv(3,1)*xi + boxinv(3,2)*yi + boxinv(3,3)*zi

         ai = ai - nint(ai)
         bi = bi - nint(bi)
         ci = ci - nint(ci)

         xi = box(1,1)*ai + box(1,2)*bi + box(1,3)*ci
         yi = box(2,1)*ai + box(2,2)*bi + box(2,3)*ci
         zi = box(3,1)*ai + box(3,2)*bi + box(3,3)*ci

      else if ( iboundary .eq. 2 ) then

         ai = boxinv(1,1)*xi + boxinv(1,2)*yi + boxinv(1,3)*zi
         bi = boxinv(2,1)*xi + boxinv(2,2)*yi + boxinv(2,3)*zi
         ci = boxinv(3,1)*xi + boxinv(3,2)*yi + boxinv(3,3)*zi

         ai = ai - nint(ai)
         bi = bi - nint(bi)
         ci = ci - nint(ci)

         xi = box(1,1)*ai + box(1,2)*bi + box(1,3)*ci
         yi = box(2,1)*ai + box(2,2)*bi + box(2,3)*ci
         zi = box(3,1)*ai + box(3,2)*bi + box(3,3)*ci

      end if

      return
      end

