!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     optimization of Onsager-Machlup action
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine omoptcycle
!***********************************************************************
!=======================================================================
!
!     optimize onsager-machlup action
!
!=======================================================================

!     /*   shared variables   */
      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!     /*   local variables   */
      implicit none

!     /*   current step   */
      istep = istep_start

!     /*   convert position: normal modes to cartesian   */
      call nm_trans_om( 0 )

!     /*   get action   */
      call getaction_om

!     /*   convert force: cartesian to normal mode   */
      call nm_trans_force_om( 1 )

!     /*   get interatomic forces   */
      call getaction_ref_om

!     /*   calculate the hamiltonian and temperature   */
      call standard_omopt

!     /*   do some analysis   */
      call analysis_string ( 1 )

!     /*   main loop   */
      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update by steepest descent   */
         call update_omopt

!        /*   convert position: normal modes to cartesian   */
         call nm_trans_om( 0 )

!        /*   get action   */
         call getaction_om

!        /*   convert force: cartesian to normal mode   */
         call nm_trans_force_om( 1 )

!        /*   get interatomic forces   */
         call getaction_ref_om

!        /*   calculate the hamiltonian and temperature   */
         call standard_omopt

!        /*   do some analysis   */
         call analysis_string ( 2 )

!        /*   output restart   */
         call backup_omopt

!        /*   exit if converged   */
         if ( iexit .eq. 1 ) exit

!        /*   look for `exit.dat'   */
         call softexit

!        /*   exit if `exit.dat' exists   */
         if ( iexit .eq. 1 ) exit

!     /*   main loop   */
      end do

!     /*   current step   */
      istep = istep_end

      return
      end

