!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine nm_trans_force_rehmc
!***********************************************************************
!=======================================================================
!
!     force multiplied by nbead
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : fx, fy, fz, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer i, j

!-----------------------------------------------------------------------
!     /*   force                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         fx(i,j) = fx(i,j) * dble(nbead)
         fy(i,j) = fy(i,j) * dble(nbead)
         fz(i,j) = fz(i,j) * dble(nbead)
      end do
      end do

      return
      end
