!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     transform in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine nm_trans_cart( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, ux, uy, uz, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if      ( ioption .eq. 2 ) then

         do j = 1, nbead
         do i = 1, natom
            x(i,j) = ux(i,j)
            y(i,j) = uy(i,j)
            z(i,j) = uz(i,j)
         end do
         end do

      else if ( ioption .eq. 3 ) then

         do j = 1, nbead
         do i = 1, natom
            ux(i,j) = x(i,j)
            uy(i,j) = y(i,j)
            uz(i,j) = z(i,j)
         end do
         end do

      end if

      return
      end





!***********************************************************************
      subroutine nm_trans_force_cart
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   fx, fy, fz, fux, fuy, fuz, potential, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         fux(i,j) = fx(i,j)*dble(nbead)
         fuy(i,j) = fy(i,j)*dble(nbead)
         fuz(i,j) = fz(i,j)*dble(nbead)
      end do
      end do

      potential = potential*dble(nbead)

      return
      end





!***********************************************************************
      subroutine nm_trans_velocity_cart( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vx, vy, vz, vux, vuy, vuz, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, i, j

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      if      ( ioption .eq. 2 ) then

         do j = 1, nbead
         do i = 1, natom
            vx(i,j) = vux(i,j)
            vy(i,j) = vuy(i,j)
            vz(i,j) = vuz(i,j)
         end do
         end do

      else if ( ioption .eq. 3 ) then

         do j = 1, nbead
         do i = 1, natom
            vux(i,j) = vx(i,j)
            vuy(i,j) = vy(i,j)
            vuz(i,j) = vz(i,j)
         end do
         end do

      end if

      return
      end
