!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Feb 9, 2020 by M. Shiga
!      Description:     measure cpu time and walltime for debugging
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine my_cputime_MPI( char, len_char, iounit, myrank )
!***********************************************************************

!-----------------------------------------------------------------------
!     //   variables
!-----------------------------------------------------------------------

!     //   initialize variables
      implicit none

!     //   initial time
      real(8), save :: t0 = 0.d0

!     //   last time
      real(8), save :: t1 = 0.d0

!     //   final time
      real(8) :: t2 = 0.d0

!     //   time inverval
      real(8) :: t20 = 0.d0

!     //   time inverval
      real(8) :: t21 = 0.d0

!     //   flag set to zero
      integer, save :: iset = 0

!     //   length of character
      integer :: len_char

!     //   character
      character(len=len_char) :: char

!     //   output file
      integer :: iounit

!     //   rank
      integer :: myrank

!-----------------------------------------------------------------------
!     //   start
!-----------------------------------------------------------------------

!     //   first access
      if ( iset .eq. 0 ) then

!        //   master rank only
         if ( myrank .ne. 0 ) return

!        //   get initial time
         call cpu_time( t0 )

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "cpu time at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t0

!        //   flag set to one
         iset = 1

!     //   second access or later
      else

!        //   master rank only
         if ( myrank .ne. 0 ) return

!        //   get final time
         call cpu_time( t2 )

!        //   time interval from first time
         t20 = t2 - t0

!        //   time interval from last time
         t21 = t2 - t1

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "cpu time at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t2

!     //   end of if statement
      end if

      return
      end





!***********************************************************************
      subroutine my_wtime_MPI( char, len_char, iounit, myrank )
!***********************************************************************

!-----------------------------------------------------------------------
!     //   variables
!-----------------------------------------------------------------------

!     //   initialize variables
      implicit none

!     //   initial time
      real(8), save :: t0 = 0.d0

!     //   last time
      real(8), save :: t1 = 0.d0

!     //   final time
      real(8) :: t2 = 0.d0

!     //   time inverval
      real(8) :: t20 = 0.d0

!     //   time inverval
      real(8) :: t21 = 0.d0

!     //   flag set to zero
      integer, save :: iset = 0

!     //   length of character
      integer :: len_char

!     //   character
      character(len=len_char) :: char

!     //   output file
      integer :: iounit

!     //   rank
      integer :: myrank

!     //   mpi
      include 'mpif.h'

!-----------------------------------------------------------------------
!     //   start
!-----------------------------------------------------------------------

!     //   first access
      if ( iset .eq. 0 ) then

!        //   get initial time
         t0 = mpi_wtime()

!        //   master rank only
         if ( myrank .ne. 0 ) return

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "walltime at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t0

!        //   flag set to one
         iset = 1

!     //   second access or later
      else

!        //   get final time
         t2 = mpi_wtime()

!        //   master rank only
         if ( myrank .ne. 0 ) return

!        //   time interval from first time
         t20 = t2 - t0

!        //   time interval from last time
         t21 = t2 - t1

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "walltime at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t2

!     //   end of if statement
      end if

      return
      end
