!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Feb 9, 2020 by M. Shiga
!      Description:     measure cpu time and walltime for debugging
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine my_cputime( char, len_char, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     //   variables
!-----------------------------------------------------------------------

!     //   initialize variables
      implicit none

!     //   initial time
      real(8), save :: t0 = 0.d0

!     //   last time
      real(8) :: t1 = 0.d0

!     //   final time
      real(8) :: t2 = 0.d0

!     //   time inverval
      real(8) :: t20 = 0.d0

!     //   time inverval
      real(8) :: t21 = 0.d0

!     //   flag set to zero
      integer, save :: iset = 0

!     //   length of character
      integer :: len_char

!     //   character
      character(len=len_char) :: char

!     //   output file
      integer :: iounit

!-----------------------------------------------------------------------
!     //   start
!-----------------------------------------------------------------------

!     //   first access
      if ( iset .eq. 0 ) then

!        //   get initial time
         call cpu_time( t0 )

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "cpu time at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t0

!        //   flag set to one
         iset = 1

!     //   second access or later
      else

!        //   get final time
         call cpu_time( t2 )

!        //   time interval from first time
         t20 = t2 - t0

!        //   time interval from last time
         t21 = t2 - t1

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "cpu time at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t2

!     //   end of if statement
      end if

      return
      end





!***********************************************************************
      subroutine my_wtime( char, len_char, iounit )
!***********************************************************************

!-----------------------------------------------------------------------
!     //   variables
!-----------------------------------------------------------------------

!     //   initialize variables
      implicit none

!     //   initial time
      real(8), save :: t0 = 0.d0

!     //   last time
      real(8), save :: t1 = 0.d0

!     //   final time
      real(8) :: t2 = 0.d0

!     //   time inverval
      real(8) :: t20 = 0.d0

!     //   time inverval
      real(8) :: t21 = 0.d0

!     //   flag set to zero
      integer, save :: iset = 0

!     //   length of character
      integer :: len_char

!     //   character
      character(len=len_char) :: char

!     //   output file
      integer :: iounit

!     //   initial time
      integer, save :: i0 = 0

!     //   final time
      integer :: i2 = 0

!     //   maximum time
      integer :: imax = 0

!     //   rate
      integer :: irate = 0

!-----------------------------------------------------------------------
!     //   start
!-----------------------------------------------------------------------

!     //   first access
      if ( iset .eq. 0 ) then

!        //   get initial time
         call system_clock( i0, irate, imax )

!        //   initial time
         t0 = dble(i0) / dble(irate)

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "walltime at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t0

!        //   flag set to one
         iset = 1

!     //   second access or later
      else

!        //   get final time
         call system_clock( i2, irate, imax )

!        //   final time
         if ( i2 .lt. i0 ) then
            t2 = dble(i2+imax+1) / dble(irate)
         else
            t2 = dble(i2) / dble(irate)
         end if

!        //   time interval from first time
         t20 = t2 - t0

!        //   time interval from last time
         t21 = t2 - t1

!        //   open file
         open ( iounit, file = 'debug.out', access = 'append' )

!        //   print time
         write( iounit, '(a12,a16,f12.3,a18,f12.3,a4)' ) &
     &      "walltime at ", char // ': ', t20, &
     &      " sec;  last part: ", t21, ' sec.'

!        //   open file
         close( iounit )

!        //   last time
         t1 = t2

!     //   end of if statement
      end if

      return
      end
