!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     multiscale molecular dynamics for QM/MM systems
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine multicycle_me_MPI
!***********************************************************************
!=======================================================================
!
!     the molecular dynamics cycle:  multiple time scale.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &    dt, istep, istep_start, istep_end, iexit, nstep, nref

      use qmmm_variables, only : &
     &    dt_multi, dt_multi_ref, jref, kref, nmulti

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   normal mode position -> Cartesian position   */
      call nm_trans_MPI(0)

!     /*   get interatomic forces a   */
      call getforce_me_p_MPI

!     /*   get interatomic forces b   */
      call getforce_me_s_MPI

!     /*   get sum of interatomic forces a, b, c   */
      call getforce_me_sum_MPI

!     /*   get harmonic forces p   */
      call getforce_ref_me_p

!     /*   get harmonic forces s   */
      call getforce_ref_me_s

!     /*   calculate the hamiltonian and temperature   */
      call standard_multi_me_MPI

!     /*   do some analysis   */
      call analysis_MPI ( 1 )

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update thermostats attached to centroids p   */
         call update_mnhc_cent_me_p ( dt )

!        /*   update the velocities by interatomic forces a   */
         call update_vel_multi_me_p ( dt )

!        /*   start multiple time step cycle   */
         do jref = 1, nmulti

!           /*   update thermostats attached to centroids s   */
            call update_mnhc_cent_me_s ( dt_multi )

!           /*   update the velocities by interatomic forces b   */
            call update_vel_multi_me_s ( dt_multi )

            do kref = 1, nref

!              /*  update thermostats attached to non-centroid p   */
               call update_mnhc_mode_me_p_MPI ( dt_multi_ref )

!              /*  update thermostats attached to non-centroid s   */
               call update_mnhc_mode_me_s_MPI ( dt_multi_ref )

!              /*   update the velocities by harmonic forces p   */
               call update_vel_multi_me_ref_p ( dt_multi_ref )

!              /*   update the velocities by harmonic forces s   */
               call update_vel_multi_me_ref_s ( dt_multi_ref )

!              /*   update all the normal mode coordinates p   */
               call update_pos_multi_me_p ( dt_multi_ref )

!              /*   update all the normal mode coordinates s   */
               call update_pos_multi_me_s ( dt_multi_ref )

!              /*   get harmonic forces s   */
               call getforce_ref_me_p

!              /*   get harmonic forces s   */
               call getforce_ref_me_s

!              /*   update the velocities by harmonic forces s   */
               call update_vel_multi_me_ref_s ( dt_multi_ref )

!              /*   update the velocities by harmonic forces p   */
               call update_vel_multi_me_ref_p ( dt_multi_ref )

!              /*  update thermostats attached to non-centroid s   */
               call update_mnhc_mode_me_s_MPI ( dt_multi_ref )

!              /*  update thermostats attached to non-centroid p   */
               call update_mnhc_mode_me_p_MPI ( dt_multi_ref )

            end do

!           /*   normal mode position -> Cartesian position   */
            call nm_trans_MPI ( 0 )

!           /*   get interatomic forces c   */
            call getforce_me_s_MPI

!           /*   update the velocities by interatomic forces c   */
            call update_vel_multi_me_s ( dt_multi )

!           /*   update thermostats attached to centroids s   */
            call update_mnhc_cent_me_s ( dt_multi )

         end do

!        /*   get interatomic forces a   */
         call getforce_me_p_MPI

!        /*   update the velocities by interatomic forces a   */
         call update_vel_multi_me_p ( dt )

!        /*   update thermostats attached to centroids p   */
         call update_mnhc_cent_me_p ( dt )

!        /*   normal mode velocity -> cartesian velocity   */
         call nm_trans_velocity_MPI ( 0 )

!        /*   get sum of interatomic forces a, b, c   */
         call getforce_me_sum_MPI

!        /*   calculate the hamiltonian and temperature   */
         call standard_multi_me_MPI

!        /*   do some analysis   */
         call analysis_MPI ( 2 )

!        /*   output restart   */
         call backup_multi_me_MPI

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
