!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine metacycle
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref

      use meta_variables, only : dt_ref_meta, nref_meta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate physical potential   */
      call getforce

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   calculate gaussian potential   */
      call getforce_hills_meta

!     /*   calculate harmonic potential   */
      call getforce_ref_meta

!     /*   hamiltonian and temperature   */
      call standard_meta

!     /*   do some analysis   */
      call analysis_meta ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   add new gaussian   */
         call addhills_meta

!        /*   calculate gaussian potential   */
         call getforce_hills_meta

!        /*   calculate harmonic potential   */
         call getforce_ref_meta

!        /*   update system velocity: real potential    */
         call update_vel_sys_meta

         do iref = 1, nref_meta

!           /*   update thermostats attached to system   */
            call update_mnhc_sys_cart( dt_ref_meta )

!           /*   update cv velocity: gaussian potential   */
            call update_vel_cv_meta

!           /*   update thermostats attached to cv   */
            call update_mnhc_cv_meta

!           /*   update cv velocity: harmonic potential   */
            call update_vel_cv_ref_meta

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_meta

!           /*   update system position   */
            call update_pos_sys_meta

!           /*   ux --> x   */
            call nm_trans_cart( 2 )

!           /*   update cv position   */
            call update_pos_cv_meta

!           /*   apply periodic boundary condition   */
            call pbc_cv_meta

!           /*   calculate harmonic potential   */
            call getforce_ref_meta

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_meta

!           /*   update cv velocity: harmonic potential   */
            call update_vel_cv_ref_meta

!           /*   calculate gaussian potential   */
            call getforce_hills_meta

!           /*   update thermostats attached to cv   */
            call update_mnhc_cv_meta

!           /*   update cv velocity: gaussian potential   */
            call update_vel_cv_meta

!           /*   update thermostats attached to system   */
            call update_mnhc_sys_cart( dt_ref_meta )

         end do

!        /*   calculate physical potential   */
         call getforce

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_meta

!        /*   hamiltonian and temperature   */
         call standard_meta

!        /*   output restart   */
         call backup_meta

!        /*   do some analysis   */
         call analysis_meta ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
