!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     classical molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine mdcycle_nve_MPI
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call mdcycle_nve_0_MPI

      else

         call mdcycle_nve_cons_MPI

      end if

      return
      end





!***********************************************************************
      subroutine mdcycle_nvt_MPI
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call mdcycle_nvt_0_MPI

      else

         call mdcycle_nvt_cons_MPI

      end if

      return
      end





!***********************************************************************
      subroutine mdcycle_nve_0_MPI
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate physical potential   */
      call getforce_MPI

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nve_MPI

!     /*   do some analysis   */
      call analysis_cart_MPI ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   update system position   */
         call update_pos_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate physical potential   */
         call getforce_MPI

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   hamiltonian and temperature   */
         call standard_md_nve_MPI

!        /*   output restart   */
         call backup_md_nve_MPI

!        /*   do some analysis   */
         call analysis_cart_MPI ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine mdcycle_nvt_0_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dt, istep, istep_start, istep_end, nstep, iexit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate physical potential   */
      call getforce_MPI

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nvt_MPI

!     /*   do some analysis   */
      call analysis_cart_MPI ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   update system position   */
         call update_pos_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate physical potential   */
         call getforce_MPI

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   hamiltonian and temperature   */
         call standard_md_nvt_MPI

!        /*   output restart   */
         call backup_md_nvt_MPI

!        /*   do some analysis   */
         call analysis_cart_MPI ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine mdcycle_nve_cons_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate harmonic potential   */
      call getforce_ref_cons_MPI

!     /*   calculate physical potential   */
      call getforce_MPI

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nve_cons_MPI

!     /*   do some analysis   */
      call analysis_cart_MPI ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate harmonic potential   */
         call getforce_ref_cons_MPI

!        /*   loop for harmonic constraints   */
         do iref = 1, nref

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!           /*   update system position: harmonic potential   */
            call update_pos_sys_cons

!           /*   ux --> x   */
            call nm_trans_cart( 2 )

!           /*   calculate harmonic potential   */
            call getforce_ref_cons_MPI

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!        /*   loop for harmonic constraints   */
         end do

!        /*   calculate physical potential   */
         call getforce_MPI

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   hamiltonian and temperature   */
         call standard_md_nve_cons_MPI

!        /*   output restart   */
         call backup_md_nve_MPI

!        /*   do some analysis   */
         call analysis_cart_MPI ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine mdcycle_nvt_cons_MPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dt, istep, istep_start, istep_end, nstep, iexit, iref, nref

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate harmonic potential   */
      call getforce_ref_cons_MPI

!     /*   calculate physical potential   */
      call getforce_MPI

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nvt_cons_MPI

!     /*   do some analysis   */
      call analysis_cart_MPI ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate harmonic potential   */
         call getforce_ref_cons_MPI

!        /*   loop for harmonic constraints   */
         do iref = 1, nref

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!           /*   update system position: harmonic potential   */
            call update_pos_sys_cons

!           /*   ux --> x   */
            call nm_trans_cart( 2 )

!           /*   calculate harmonic potential   */
            call getforce_ref_cons_MPI

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!        /*   loop for harmonic constraints   */
         end do

!        /*   calculate physical potential   */
         call getforce_MPI

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   hamiltonian and temperature   */
         call standard_md_nvt_cons_MPI

!        /*   output restart   */
         call backup_md_nvt_MPI

!        /*   do some analysis   */
         call analysis_cart_MPI ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit_MPI
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
