!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     classical molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine mdcycle_nve
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call mdcycle_nve_0

      else

         call mdcycle_nve_cons

      end if

      return
      end





!***********************************************************************
      subroutine mdcycle_nvt
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use cons_variables, only : ncons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   constraints                                                */
!-----------------------------------------------------------------------

      if ( ncons .eq. 0 ) then

         call mdcycle_nvt_0
      else

         call mdcycle_nvt_cons

      end if

      return
      end





!***********************************************************************
      subroutine mdcycle_nve_0
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate physical potential   */
      call getforce

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nve

!     /*   do some analysis   */
      call analysis_cart ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   update system position   */
         call update_pos_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate physical potential   */
         call getforce

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   hamiltonian and temperature   */
         call standard_md_nve

!        /*   output restart   */
         call backup_md_nve

!        /*   do some analysis   */
         call analysis_cart ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine mdcycle_nvt_0
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dt, istep, istep_start, istep_end, nstep, iexit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate physical potential   */
      call getforce

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nvt

!     /*   do some analysis   */
      call analysis_cart ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   update system position   */
         call update_pos_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate physical potential   */
         call getforce

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   hamiltonian and temperature   */
         call standard_md_nvt

!        /*   output restart   */
         call backup_md_nvt

!        /*   do some analysis   */
         call analysis_cart ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine mdcycle_nve_cons
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep, istep_start, istep_end, nstep, iexit, iref, nref

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate harmonic potential   */
      call getforce_ref_cons

!     /*   calculate physical potential   */
      call getforce

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nve_cons

!     /*   do some analysis   */
      call analysis_cart ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate harmonic potential   */
         call getforce_ref_cons

!        /*   loop for harmonic constraints   */
         do iref = 1, nref

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!           /*   update system position: harmonic potential   */
            call update_pos_sys_cons

!           /*   ux --> x   */
            call nm_trans_cart( 2 )

!           /*   calculate harmonic potential   */
            call getforce_ref_cons

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!        /*   loop for harmonic constraints   */
         end do

!        /*   calculate physical potential   */
         call getforce

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   hamiltonian and temperature   */
         call standard_md_nve_cons

!        /*   output restart   */
         call backup_md_nve

!        /*   do some analysis   */
         call analysis_cart ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end





!***********************************************************************
      subroutine mdcycle_nvt_cons
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dt, istep, istep_start, istep_end, nstep, iexit, iref, nref

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   initial setup                                              */
!-----------------------------------------------------------------------

!     /*   initialize step   */
      istep = istep_start
      istep_end = istep

!     /*   ux --> x   */
      call nm_trans_cart( 2 )

!     /*   calculate harmonic potential   */
      call getforce_ref_cons

!     /*   calculate physical potential   */
      call getforce

!     /*   fx --> fux   */
      call nm_trans_force_cart

!     /*   hamiltonian and temperature   */
      call standard_md_nvt_cons

!     /*   do some analysis   */
      call analysis_cart ( 1 )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do istep = istep_start+1, nstep

!        /*   current step   */
         istep_end = istep

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   ux --> x   */
         call nm_trans_cart( 2 )

!        /*   calculate harmonic potential   */
         call getforce_ref_cons

!        /*   loop for harmonic constraints   */
         do iref = 1, nref

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!           /*   update system position: harmonic potential   */
            call update_pos_sys_cons

!           /*   ux --> x   */
            call nm_trans_cart( 2 )

!           /*   calculate harmonic potential   */
            call getforce_ref_cons

!           /*   update system velocity: harmonic potential   */
            call update_vel_sys_ref_cons

!        /*   loop for harmonic constraints   */
         end do

!        /*   calculate physical potential   */
         call getforce

!        /*   fx --> fux   */
         call nm_trans_force_cart

!        /*   update system velocity: real potential    */
         call update_vel_sys_cart

!        /*   REVISED: update thermostats attached to system   */
!        call update_mnhc_sys_cart( dt )
         call update_mnhc_sys_cart_revised( dt )

!        /*   hamiltonian and temperature   */
         call standard_md_nvt_cons

!        /*   output restart   */
         call backup_md_nvt

!        /*   do some analysis   */
         call analysis_cart ( 2 )

!        /*   exit if `exit.dat' exists   */
         call softexit
         if ( iexit .eq. 1 ) exit

      end do

!     /*   current step   */
      istep = istep_end

      return
      end
