#///////////////////////////////////////////////////////////////////////
#
#      Author:          S. Ruiz-Barragan, K. Ishimura, M. Shiga
#      Last updated:    May 1, 2016 by M. Shiga
#      Description:     makefile for the PIMD code with SMASH
#
#///////////////////////////////////////////////////////////////////////

#-----------------------------------------------------------------------
#     define SMASH variables
#-----------------------------------------------------------------------

########################################################################
ifdef SMASH
########################################################################

SMASHSRC = module.F90 modulefmt.F90 modulerys.F90 basis.F90 geom.F90 \
           guess.F90 fileio.F90 int1.F90 machine.F90 main.F90 \
           math.F90 memory.F90 scf.F90 scflib.F90 int2.F90 \
           int2elec.F90 int2sp.F90 int2spd1.F90 int2spd2.F90 \
           int2spd3.F90 int2spd4.F90 gradient.F90 rysquad.F90 \
           dft.F90 dftfunc.F90 lebedev.F90 mp2.F90 grad1.F90 \
           grad2.F90 ecp.F90 ecpfunc.F90 ecpder.F90 parallel.F90 \
           mp2grad.F90

#           int2sp_lc.F90 int2spd1_lc.F90 int2spd2_lc.F90 \
#           int2spd3_lc.F90 int2spd4_lc.F90 dftd3.F90 \
#           geom_pbc.F90 int1_pbc.F90 int1_pbc_1.F90 int1_pbc_2.F90 \
#           gradient_pbc.F90 grad1_pbc.F90 grad1_pbc_1.F90 grad1_pbc_2.F90

OBJSMASH = $(addprefix $(SMASHDIR)/,$(SMASHSRC:.F90=.o))

OBJSMASHMPI = $(addprefix $(SMASHDIR)/,$(SMASHSRC:.F90=_MPI.o))

########################################################################
endif
########################################################################

#-----------------------------------------------------------------------
#     compile SMASH
#-----------------------------------------------------------------------

########################################################################
ifdef SMASH
########################################################################

$(SMASHDIR)/%.o : $(SMASHDIR)/%.F
	$(FCMP) $(SMASHOPT) -o $@ -c $<

$(SMASHDIR)/%.o : $(SMASHDIR)/%.F90
	$(FCMP) $(SMASHOPT) -o $@ -c $<

$(SMASHDIR)/%_MPI.o : $(SMASHDIR)/%.F
	$(FCMP) $(SMASHOPTMPI) -o $@ -c $<

$(SMASHDIR)/%_MPI.o : $(SMASHDIR)/%.F90
	$(FCMP) $(SMASHOPTMPI) -o $@ -c $<

$(SMASHDIR)/fileio.o : $(SMASHDIR)/fileio.F90
	$(FCMP) $(SMASHOPT) -o common_variables.o -c common_variables.F90
	$(FCMP) $(SMASHOPTMPI) -o $@ -c $<

$(SMASHDIR)/ecpfunc.o : $(SMASHDIR)/ecpfunc.F90
	$(FCMP) $(SMASHOPT) -o common_variables.o -c common_variables.F90
	$(FCMP) $(SMASHOPTMPI) -o $@ -c $<

$(LIBSMASH) : $(OBJSMASH)
	ar -cr $(LIBSMASH) $(OBJSMASH)

$(LIBSMASHMPI) : $(OBJSMASHMPI)
	ar -cr $(LIBSMASHMPI) $(OBJSMASHMPI)

#force_smash.o : force_smash.F
#	$(FCMP) $(SMASHOPT) -o $@ -c $<
#
#force_smash_int_mod.o : force_smash_int_mod.F
#	$(FCMP) $(SMASHOPT) -o $@ -c $<
#
#force_smash_MPI.o : force_smash_MPI.F
#	$(FCMP) $(SMASHOPTMPI) -o $@ -c $<

########################################################################
endif
########################################################################
