#///////////////////////////////////////////////////////////////////////
#
#      Author:          M. Shiga
#      Last updated:    Apr 7, 2022 by M. Shiga
#      Description:     makefile for the PIMD code
#
#///////////////////////////////////////////////////////////////////////
#-----------------------------------------------------------------------
#     program names
#-----------------------------------------------------------------------

PROGPIMD        = pimd.x
PROGPIMPI       = pimd.mpi.x
PROGPOLY        = polymers.x

PROGCALC        = calc.x
PROGGAU         = gau.x
PROGMOLPRO      = run_molpro.x
PROGCHARMM      = convert_charmm.x
PROGTINKER      = convert_tinker.x
PROGPREPLIQUID  = prep_liquid.x
PROGPREPBEST    = prep_best.x

#-----------------------------------------------------------------------
#     objects
#-----------------------------------------------------------------------

ifdef AENETFLAG
OBJUTILS = \
        ioutils_s.o
endif

ifdef PFPFLAG
OBJPFP = \
        pfp_interface.o \
        pfp_py.o
endif


OBJPIMD = \
        common_variables.o \
        addfbox.o \
        addhills_meta.o \
        addhills_tass.o \
        adjust_step_hmc.o \
        adjust_step_rehmc.o \
        afedcycle.o \
        afedcycle_logmfd.o \
        afedcycle_tamd.o \
        align_string.o \
        analysis.o \
        analysis_cart.o \
        analysis_dcd.o \
        analysis_fourth_hmc.o \
        analysis_meta.o \
        analysis_mfe.o \
        analysis_ratio_hmc.o \
        analysis_rec_tass.o \
        analysis_rehmc.o \
        analysis_remc.o \
        analysis_second_hmc.o \
        analysis_string.o \
        analysis_tass.o \
        analysis_tfs.o \
        analysis_xsf.o \
        backup_boxopt.o \
        backup_cartesian.o \
        backup_cmd.o \
        backup_geoopt.o \
        backup_md.o \
        backup_meta.o \
        backup_multi.o \
        backup_pihmc.o \
        backup_pimd.o \
        backup_rehmc.o \
        backup_string.o \
        backup_tass.o \
        boundary.o \
        boxoptcycle.o \
        checkphase.o \
        cmdcycle.o \
        correct_force_cent.o \
        correct_virial.o \
        det3.o \
        diag.o \
        diag_nolapack.o \
        dvrcycle.o \
        elastic.o \
        erf.o \
        error_handling.o \
        exchange_rehmc.o \
        fftpack.o \
        force_adp.o \
        force_aenet.o \
        force_abinit_mp.o \
        force_abinit_mp5.o \
        force_best.o \
        force_cart.o \
        force_dftb.o \
        force_eam.o \
        force_ee.o \
        force_ee_next.o \
        force_external.o \
        force_external_multi.o \
        force_g03.o \
        force_g09.o \
        force_g16.o \
        force_g98.o \
        force_gamess.o \
        force_helium.o \
        force_hob.o \
        force_hydrogen.o \
        force_libcp2k.o \
        force_libdftb.o \
        force_libnnp.o \
        force_metalwater.o \
        force_me.o \
        force_me_next.o \
        force_mm.o \
        force_mm_ljpair.o \
        force_mm_ljpair_next.o \
        force_mm_next.o \
        force_mm_tip4p.o \
        force_molpro.o \
        force_mopac.o \
        force_mtp.o \
        force_muller.o \
        force_n2p2.o \
        force_ntchem.o \
        force_oniom.o \
        force_orca.o \
        force_oss.o \
        force_pair.o \
        force_pfp.o \
        force_phase0.o \
        force_pmeewald_fs.o \
        force_pol.o \
        force_qe.o \
        force_quartic.o \
        force_smash_int_mod.o \
        force_smash.o \
        force_tersoff.o \
        force_tully.o \
        force_turbo.o \
        force_user.o \
        force_vasp.o \
        force_vasp5.o \
        force_vasp6.o \
        force_water.o \
        force_xtb.o \
        fulloptcycle.o \
        gadcycle.o \
        geooptcycle.o \
        get_cv.o \
        get_cv_cons.o \
        get_cv_tass.o \
        get_ljpair.o \
        get_v_best.o \
        getaction_om.o \
        getaction_ref_om.o \
        getdate.o \
        getenergy_fourth_hmc.o \
        getenergy_rehmc.o \
        getenergy_second_hmc.o \
        getfbox.o \
        getforce.o \
        getforce_alchem.o \
        getforce_hills_meta.o \
        getforce_hills_tass.o \
        getforce_me_multi.o \
        getforce_mfe.o \
        getforce_ref.o \
        getforce_ref_cons.o \
        getforce_ref_cons_cent.o \
        getforce_ref_cons_geoopt.o \
        getforce_ref_meta.o \
        getforce_ref_multi.o \
        getforce_ref_tass.o \
        getforce_ref_xyz.o \
        getforce_tfs.o \
        gethess.o \
        getpot_string.o \
        getswf.o \
        gram_schmidt.o \
        hopping_tfs.o \
        init_bath.o \
        init_bath_cart.o \
        init_bath_multi.o \
        init_box.o \
        init_box_rehmc.o \
        init_centroid.o \
        init_extprograms.o \
        init_mass.o \
        init_mass_pibcmd.o \
        init_meta.o \
        init_mode.o \
        init_molcomp.o \
        init_position_cart.o \
        init_string.o \
        init_tass.o \
        init_velocity.o \
        init_velocity_cart.o \
        int_to_char.o \
        inv.o \
        ioforce.o \
        iogeometry.o \
        judge_fourth_hmc.o \
        judge_rehmc.o \
        judge_remc.o \
        judge_second_hmc.o \
        kinetic_energy.o \
        lbfgs.o \
        mdcycle.o \
        matsubaracycle.o \
        metacycle.o \
        metacycle_dual.o \
        mfecycle.o \
        multicycle_me.o \
        my_cputime.o \
        nm_matrix.o \
        nm_trans.o \
        nm_trans_cart.o \
        nm_trans_om.o \
        nm_trans_rehmc.o \
        nm_velocity_mode.o \
        nma.o \
        omoptcycle.o \
        pbc.o \
        pbc_atom.o \
        pbc_atom_prim.o \
        pbc_meta.o \
        pbc_tass.o \
        pbc_unfold.o \
        phonon.o \
        pibcmdcycle.o \
        pihmccycle_1d.o \
        pihmccycle_dual.o \
        pihmccycle_npt.o \
        pihmccycle_ntt.o \
        pihmccycle_nvt.o \
        pimd.o \
        pimdcycle_nph.o \
        pimdcycle_npt.o \
        pimdcycle_nth.o \
        pimdcycle_ntt.o \
        pimdcycle_nve.o \
        pimdcycle_nvt.o \
        print_final_xyz.o \
        print_minfo.o \
        print_titles.o \
        project_out_nma.o \
        project_out_phonon.o \
        random.o \
        read_species.o \
        read_start.o \
        read_tension.o \
        readinput.o \
        recover_fourth_hmc.o \
        recover_rehmc.o \
        recover_second_hmc.o \
        remccycle.o \
        reorient_string.o \
        restart.o \
        restart_bath.o \
        restart_bath_cart.o \
        restart_bath_multi.o \
        restart_box.o \
        restart_box_rehmc.o \
        restart_meta.o \
        restart_rehmc.o \
        restart_tass.o \
        rehmccycle.o \
        rehmccycle_npt.o \
        rotor.o \
        rpmdcycle.o \
        rpmfecycle.o \
        rptfscycle.o \
        save_fourth_hmc.o \
        save_second_hmc.o \
        save_rehmc.o \
        scancycle.o \
        sdcycle.o \
        search_tag.o \
        set_dof.o \
        setallocation.o \
        setpiparams.o \
        setcondition.o \
        setparams.o \
        setup_alchem.o \
        setup_best.o \
        setup_boxopt.o \
        setup_cmd.o \
        setup_cons.o \
        setup_dual.o \
        setup_ee.o \
        setup_elastic.o \
        setup_fullopt.o \
        setup_geometry.o \
        setup_geoopt.o \
        setup_md.o \
        setup_me.o \
        setup_meta.o \
        setup_mfe.o \
        setup_multi.o \
        setup_nma.o \
        setup_omopt.o \
        setup_oniom.o \
        setup_pibcmd.o \
        setup_pihmc_npt.o \
        setup_pihmc_ntt.o \
        setup_pihmc_nvt.o \
        setup_pimd_nve.o \
        setup_pimd_nvt.o \
        setup_pimd_nph.o \
        setup_pimd_npt.o \
        setup_pimd_nth.o \
        setup_pimd_ntt.o \
        setup_qmass.o \
        setup_rehmc.o \
        setup_rehmc_npt.o \
        setup_remc.o \
        setup_rpmd.o \
        setup_sd.o \
        setup_string.o \
        setup_tass.o \
        setup_testforce.o \
        setup_testvirial.o \
        setup_tfs.o \
        shscycle.o \
        softexit.o \
        spline_string.o \
        standard.o \
        standard_boxopt.o \
        standard_geoopt.o \
        standard_hmc.o \
        standard_md.o \
        standard_meta.o \
        standard_mfe.o \
        standard_multi.o \
        standard_nph.o \
        standard_npt.o \
        standard_nth.o \
        standard_ntt.o \
        standard_omopt.o \
        standard_rehmc.o \
        standard_remc.o \
        standard_sd.o \
        standard_string.o \
        standard_tass.o \
        standard_testforce.o \
        standard_testvirial.o \
        standard_tfs.o \
        static.o \
        stringcycle.o \
        suzuki_yoshida.o \
        tasscycle.o \
        temp_control.o \
        testewald.o \
        testforce.o \
        testforce_om.o \
        testfile.o \
        testvirial.o \
        titles.o \
        tfscycle.o \
        tpscycle.o \
        trpmdcycle.o \
        update_cstate.o \
        update_cv_meta.o \
        update_cv_tass.o \
        update_mnhc_box.o \
        update_mnhc_cent.o \
        update_mnhc_cent_multi.o \
        update_mnhc_meta.o \
        update_mnhc_mode.o \
        update_mnhc_mode_multi.o \
        update_mnhc_sys_cart.o \
        update_mnhc_tass.o \
        update_mode_nph.o \
        update_mode_nth.o \
        update_omopt.o \
        update_pibcmd_platen.o \
        update_pos.o \
        update_pos_box_nph.o \
        update_pos_box_nth.o \
        update_pos_cart.o \
        update_pos_cent_nph.o \
        update_pos_cent_nth.o \
        update_pos_multi.o \
        update_pos_npt.o \
        update_pos_ntt.o \
        update_pos_xyz.o \
        update_posvel_anal.o \
        update_rehmc.o \
        update_remc.o \
        update_string.o \
        update_sys_cart.o \
        update_sys_cons.o \
        update_sys_meta.o \
        update_sys_tass.o \
        update_vel.o \
        update_vel_box_nph.o \
        update_vel_box_nth.o \
        update_vel_cart.o \
        update_vel_cent_nph.o \
        update_vel_cent_nth.o \
        update_vel_multi.o \
        update_vel_multi_ref.o \
        update_vel_sd.o \
        update_vel_xyz.o \
        $(OBJPFP)

OBJPIMPI = \
        common_variables.o \
        addfbox.o \
        addhills_meta_MPI.o \
        addhills_tass_MPI.o \
        adjust_step_hmc_MPI.o \
        adjust_step_rehmc_MPI.o \
        afedcycle_MPI.o \
        afedcycle_logmfd_MPI.o \
        afedcycle_tamd_MPI.o \
        align_string.o \
        analysis_cart_MPI.o \
        analysis_dcd_MPI.o \
        analysis_dcd_XMPI.o \
        analysis_fourth_hmc_MPI.o \
        analysis_meta_MPI.o \
        analysis_mfe_MPI.o \
        analysis_MPI.o \
        analysis_ratio_hmc_MPI.o \
        analysis_rec_tass_MPI.o \
        analysis_rehmc_MPI.o \
        analysis_remc_MPI.o \
        analysis_second_hmc_MPI.o \
        analysis_string_MPI.o \
        analysis_tass_MPI.o \
        analysis_tfs_MPI.o \
        analysis_XMPI.o \
        analysis_xsf_MPI.o \
        backup_boxopt_MPI.o \
        backup_cartesian_MPI.o \
        backup_cmd_MPI.o \
        backup_geoopt_MPI.o \
        backup_md_MPI.o \
        backup_meta_MPI.o \
        backup_multi_MPI.o \
        backup_nma_MPI.o \
        backup_pihmc_MPI.o \
        backup_pimd_MPI.o \
        backup_pimd_XMPI.o \
        backup_rehmc_MPI.o \
        backup_string_MPI.o \
        backup_tass_MPI.o \
        boundary_MPI.o \
        boxoptcycle_MPI.o \
        checkphase_MPI.o \
        cmdcycle_MPI.o \
        communicate_MPI.o \
        communicate_2_MPI.o \
        communicate_4_MPI.o \
        correct_force_cent_MPI.o \
        correct_force_cent_XMPI.o \
        correct_virial.o \
        correct_virial_XMPI.o \
        det3.o \
        diag_MPI.o \
        diag_nolapack_MPI.o \
        dvrcycle_MPI.o \
        elastic_MPI.o \
        erf.o \
        error_handling_MPI.o \
        exchange_rehmc.o \
        fftpack.o \
        force_adp_MPI.o \
        force_aenet_MPI.o \
        force_abinit_mp_MPI.o \
        force_abinit_mp5_MPI.o \
        force_best_MPI.o \
        force_cart_MPI.o \
        force_dftb_MPI.o \
        force_eam_MPI.o \
        force_eam_XMPI.o \
        force_ee_MPI.o \
        force_ee_next_MPI.o \
        force_external_MPI.o \
        force_external_multi_MPI.o \
        force_g03_MPI.o \
        force_g09_MPI.o \
        force_g16_MPI.o \
        force_g98_MPI.o \
        force_gamess_MPI.o \
        force_helium_MPI.o \
        force_helium_XMPI.o \
        force_hob_MPI.o \
        force_hydrogen_MPI.o \
        force_libcp2k_MPI.o \
        force_libcp2k_v8.2_MPI.o \
        force_libdftb_MPI.o \
        force_libnnp_MPI.o \
        force_metalwater_MPI.o \
        force_me_MPI.o \
        force_me_next_MPI.o \
        force_mm_MPI.o \
        force_mm_ljpair_MPI.o \
        force_mm_ljpair_next_MPI.o \
        force_mm_next_MPI.o \
        force_mm_tip4p_MPI.o \
        force_mm_XMPI.o \
        force_molpro_MPI.o \
        force_mopac_MPI.o \
        force_mtp_MPI.o \
        force_muller_MPI.o \
        force_n2p2_MPI.o \
        force_n2p2_XMPI.o \
        force_ntchem_MPI.o \
        force_oniom_MPI.o \
        force_orca_MPI.o \
        force_oss_MPI.o \
        force_pair_MPI.o \
        force_pfp_MPI.o \
        force_phase0_MPI.o \
        force_pmeewald_fs_MPI.o \
        force_pol_MPI.o \
        force_qe_MPI.o \
        force_qegit_MPI.o \
        force_quartic_MPI.o \
        force_smash_int_mod.o \
        force_smash_MPI.o \
        force_tersoff_MPI.o \
        force_tully_MPI.o \
        force_turbo_MPI.o \
        force_user_MPI.o \
        force_vasp_MPI.o \
        force_vasp5_MPI.o \
        force_vasp6_MPI.o \
        force_water_MPI.o \
        force_xtb_MPI.o \
        fulloptcycle_MPI.o \
        gadcycle_MPI.o \
        geooptcycle_MPI.o \
        geooptcycle_XMPI.o \
        get_cv_MPI.o \
        get_cv_cons_MPI.o \
        get_cv_tass_MPI.o \
        get_ljpair.o \
        get_v_best.o \
        getaction_om_MPI.o \
        getaction_ref_om.o \
        getdate.o \
        getenergy_fourth_hmc_MPI.o \
        getenergy_second_hmc_MPI.o \
        getenergy_rehmc_MPI.o \
        getfbox_MPI.o \
        getfbox_XMPI.o \
        getforce_hills_meta_MPI.o \
        getforce_hills_tass_MPI.o \
        getforce_me_multi_MPI.o \
        getforce_mfe_MPI.o \
        getforce_MPI.o \
        getforce_alchem_MPI.o \
        getforce_ref.o \
        getforce_ref_cons_MPI.o \
        getforce_ref_cons_cent_MPI.o \
        getforce_ref_cons_geoopt_MPI.o \
        getforce_ref_meta_MPI.o \
        getforce_ref_multi.o \
        getforce_ref_tass_MPI.o \
        getforce_ref_XMPI.o \
        getforce_ref_xyz.o \
        getforce_tfs_MPI.o \
        getforce_XMPI.o \
        gethess_MPI.o \
        gethess_paral_MPI.o \
        getpot_string.o \
        getswf.o \
        gram_schmidt.o \
        hopping_tfs_MPI.o \
        init_bath_MPI.o \
        init_bath_cart_MPI.o \
        init_bath_multi_MPI.o \
        init_box_MPI.o \
        init_box_rehmc_MPI.o \
        init_centroid_MPI.o \
        init_molcomp_MPI.o \
        init_extprograms_MPI.o \
        init_mass_MPI.o \
        init_mass_pibcmd_MPI.o \
        init_meta_MPI.o \
        init_mode_MPI.o \
        init_position_cart_MPI.o \
        init_string_MPI.o \
        init_tass_MPI.o \
        init_velocity_MPI.o \
        init_velocity_XMPI.o \
        init_velocity_cart_MPI.o \
        int_to_char.o \
        inv_MPI.o \
        ioforce.o \
        iogeometry.o \
        judge_second_hmc_MPI.o \
        judge_rehmc_MPI.o \
        judge_remc_MPI.o \
        judge_fourth_hmc_MPI.o \
        kinetic_energy.o \
        lbfgs.o \
        matsubaracycle_MPI.o \
        mdcycle_MPI.o \
        metacycle_MPI.o \
        metacycle_dual_MPI.o \
        mfecycle_MPI.o \
        multicycle_me_MPI.o \
        my_cputime_MPI.o \
        neighbor_list_XMPI.o \
        nm_matrix_MPI.o \
        nm_trans.o \
        nm_trans_MPI.o \
        nm_trans_XMPI.o \
        nm_trans_cart.o \
        nm_trans_om_MPI.o \
        nm_trans_rehmc.o \
        nm_velocity_mode_MPI.o \
        nm_velocity_mode_XMPI.o \
        nma_MPI.o \
        omoptcycle_MPI.o \
        pbc_atom_MPI.o \
        pbc_atom_prim.o \
        pbc_meta.o \
        pbc_tass.o \
        pbc.o \
        pbc_cent_XMPI.o \
        pbc_unfold_MPI.o \
        phonon_MPI.o \
        pibcmdcycle_MPI.o \
        pibcmdcycle_XMPI.o \
        pihmccycle_1d_MPI.o \
        pihmccycle_dual_MPI.o \
        pihmccycle_npt_MPI.o \
        pihmccycle_ntt_MPI.o \
        pihmccycle_nvt_MPI.o \
        pimd_MPI.o \
        pimdcycle_nph_MPI.o \
        pimdcycle_npt_MPI.o \
        pimdcycle_nth_MPI.o \
        pimdcycle_ntt_MPI.o \
        pimdcycle_nve_MPI.o \
        pimdcycle_nvt_MPI.o \
        pimdcycle_nvt_XMPI.o \
        pimdcycle_qtst_MPI.o \
        predict_aenet_MPI.o \
        predict_n2p2_MPI.o \
        predict_n2p2_XMPI.o \
        prep_XMPI.o \
        print_final_xyz_MPI.o \
        print_final_xyz_XMPI.o \
        print_minfo.o \
        print_titles_MPI.o \
        project_out_nma_MPI.o \
        project_out_phonon.o \
        random.o \
        random_XMPI.o \
        readinput_MPI.o \
        read_species_MPI.o \
        read_start_MPI.o \
        read_tension_MPI.o \
        recover_fourth_hmc_MPI.o \
        recover_rehmc.o \
        recover_second_hmc_MPI.o \
        rehmccycle_MPI.o \
        rehmccycle_npt_MPI.o \
        remccycle_MPI.o \
        reorient_string_MPI.o \
        restart_MPI.o \
        restart_XMPI.o \
        restart_bath_MPI.o \
        restart_bath_XMPI.o \
        restart_bath_cart_MPI.o \
        restart_bath_multi_MPI.o \
        restart_box_MPI.o \
        restart_box_rehmc_MPI.o \
        restart_meta_MPI.o \
        restart_rehmc_MPI.o \
        restart_tass_MPI.o \
        rotor_MPI.o \
        rpmdcycle_MPI.o \
        rpmdcycle_XMPI.o \
        rpmfecycle_MPI.o \
        rptfscycle_MPI.o \
        save_rehmc.o \
        save_fourth_hmc.o \
        save_second_hmc.o \
        scancycle_MPI.o \
        sdcycle_MPI.o \
        search_tag.o \
        set_dof.o \
        setallocation.o \
        setpiparams_MPI.o \
        setcondition_MPI.o \
        setparams_MPI.o \
        setup_alchem_MPI.o \
        setup_best_MPI.o \
        setup_boxopt_MPI.o \
        setup_cmd_MPI.o \
        setup_cons_MPI.o \
        setup_dual_MPI.o \
        setup_ee_MPI.o \
        setup_elastic_MPI.o \
        setup_fullopt_MPI.o \
        setup_geometry_MPI.o \
        setup_geoopt_MPI.o \
        setup_md_MPI.o \
        setup_me_MPI.o \
        setup_meta_MPI.o \
        setup_mfe_MPI.o \
        setup_multi_MPI.o \
        setup_nma_MPI.o \
        setup_omopt_MPI.o \
        setup_oniom_MPI.o \
        setup_pibcmd_MPI.o \
        setup_pihmc_npt_MPI.o \
        setup_pihmc_ntt_MPI.o \
        setup_pihmc_nvt_MPI.o \
        setup_pimd_nve_MPI.o \
        setup_pimd_nvt_MPI.o \
        setup_pimd_nph_MPI.o \
        setup_pimd_npt_MPI.o \
        setup_pimd_nth_MPI.o \
        setup_pimd_ntt_MPI.o \
        setup_qmass.o \
        setup_rehmc_MPI.o \
        setup_rehmc_npt_MPI.o \
        setup_remc_MPI.o \
        setup_rpmd_MPI.o \
        setup_sd_MPI.o \
        setup_string_MPI.o \
        setup_tass_MPI.o \
        setup_testforce_MPI.o \
        setup_testvirial_MPI.o \
        setup_tfs_MPI.o \
        shscycle_MPI.o \
        softexit_MPI.o \
        spline_string.o \
        standard_boxopt_MPI.o \
        standard_hmc_MPI.o \
        standard_geoopt_MPI.o \
        standard_md_MPI.o \
        standard_meta_MPI.o \
        standard_mfe_MPI.o \
        standard_multi_MPI.o \
        standard_MPI.o \
        standard_XMPI.o \
        standard_nph_MPI.o \
        standard_npt_MPI.o \
        standard_nth_MPI.o \
        standard_ntt_MPI.o \
        standard_omopt_MPI.o \
        standard_rehmc_MPI.o \
        standard_remc_MPI.o \
        standard_sd_MPI.o \
        standard_string_MPI.o \
        standard_tass_MPI.o \
        standard_testforce_MPI.o \
        standard_testforce_XMPI.o \
        standard_testvirial_MPI.o \
        standard_tfs_MPI.o \
        static_MPI.o \
        stringcycle_MPI.o \
        suzuki_yoshida.o \
        tasscycle_MPI.o \
        temp_control.o \
        testforce_MPI.o \
        testforce_XMPI.o \
        testforce_om_MPI.o \
        testewald_MPI.o \
        testfile.o \
        testvirial_MPI.o \
        testvirial_XMPI.o \
        titles.o \
        tfscycle_MPI.o \
        tpscycle_MPI.o \
        trpmdcycle_MPI.o \
        update_cstate_MPI.o \
        update_cv_meta.o \
        update_cv_tass.o \
        update_mnhc_box.o \
        update_mnhc_cent.o \
        update_mnhc_cent_XMPI.o \
        update_mnhc_cent_multi.o \
        update_mnhc_meta.o \
        update_mnhc_mode_MPI.o \
        update_mnhc_mode_XMPI.o \
        update_mnhc_mode_multi_MPI.o \
        update_mnhc_sys_cart.o \
        update_mnhc_tass.o \
        update_mode_nph.o \
        update_mode_nth.o \
        update_pibcmd_platen_MPI.o \
        update_pos.o \
        update_pos_XMPI.o \
        update_pos_box_nph_MPI.o \
        update_pos_box_nth_MPI.o \
        update_pos_cart.o \
        update_pos_cent_nph_MPI.o \
        update_pos_cent_nth_MPI.o \
        update_pos_multi.o \
        update_pos_npt_MPI.o \
        update_pos_ntt_MPI.o \
        update_pos_xyz_MPI.o \
        update_posvel_anal.o \
        update_posvel_anal_XMPI.o \
        update_omopt_MPI.o \
        update_rehmc.o \
        update_remc_MPI.o \
        update_string.o \
        update_sys_cart.o \
        update_sys_cons.o \
        update_sys_meta.o \
        update_sys_tass.o \
        update_vel.o \
        update_vel_XMPI.o \
        update_vel_box_nph.o \
        update_vel_box_nth.o \
        update_vel_cart.o \
        update_vel_cent_nph_MPI.o \
        update_vel_cent_nth_MPI.o \
        update_vel_multi.o \
        update_vel_multi_ref.o \
        update_vel_sd.o \
        update_vel_xyz.o \
        $(OBJUTILS) $(OBJPFP)

OBJPOLY = \
        common_variables.o \
        align_polymers_MPI.o \
        analysis_polymers_MPI.o \
        diag_MPI.o \
        diag_nolapack_MPI.o \
        det3.o \
        backup_polymers_MPI.o \
        boundary_MPI.o \
        communicate_MPI.o \
        communicate_2_MPI.o \
        communicate_3_MPI.o \
        correct_force_cent_MPI.o \
        correct_virial.o \
        erf.o \
        error_handling_MPI.o \
        fftpack.o \
        finalize_polymers_MPI.o \
        force_adp_MPI.o \
        force_aenet_MPI.o \
        force_abinit_mp_MPI.o \
        force_abinit_mp5_MPI.o \
        force_best_MPI.o \
        force_cart_MPI.o \
        force_dftb_MPI.o \
        force_eam_MPI.o \
        force_ee_MPI.o \
        force_ee_next_MPI.o \
        force_external_MPI.o \
        force_external_multi_MPI.o \
        force_g03_MPI.o \
        force_g09_MPI.o \
        force_g16_MPI.o \
        force_g98_MPI.o \
        force_gamess_MPI.o \
        force_helium_MPI.o \
        force_hob_MPI.o \
        force_hydrogen_MPI.o \
        force_libcp2k_MPI.o \
        force_libcp2k_v8.2_MPI.o \
        force_libdftb_MPI.o \
        force_libnnp_MPI.o \
        force_metalwater_MPI.o \
        force_me_MPI.o \
        force_me_next_MPI.o \
        force_mm_MPI.o \
        force_mm_next_MPI.o \
        force_mm_tip4p_MPI.o \
        force_mm_ljpair_MPI.o \
        force_mm_ljpair_next_MPI.o \
        force_molpro_MPI.o \
        force_mopac_MPI.o \
        force_mtp_MPI.o \
        force_muller_MPI.o \
        force_n2p2_MPI.o \
        force_ntchem_MPI.o \
        force_oniom_MPI.o \
        force_orca_MPI.o \
        force_oss_MPI.o \
        force_pair_MPI.o \
        force_pfp_MPI.o \
        force_phase0_MPI.o \
        force_pmeewald_fs_MPI.o \
        force_pol_MPI.o \
        force_qe_MPI.o \
        force_qegit_MPI.o \
        force_quartic_MPI.o \
        force_smash_int_mod.o \
        force_smash_MPI.o \
        force_tersoff_MPI.o \
        force_tully_MPI.o \
        force_turbo_MPI.o \
        force_user_MPI.o \
        force_vasp_MPI.o \
        force_vasp5_MPI.o \
        force_vasp6_MPI.o \
        force_water_MPI.o \
        force_xtb_MPI.o \
        get_cv_cons_MPI.o \
        get_ljpair.o \
        get_v_best.o \
        getdate.o \
        getforce_MPI.o \
        getforce_ref.o \
        getforce_ref_cons_MPI.o \
        getforce_ref_cons_cent_MPI.o \
        getforce_ref_cons_geoopt_MPI.o \
        getswf.o \
        gram_schmidt.o \
        random.o \
        init_bath_MPI.o \
        init_extprograms_MPI.o \
        init_mass_polymers.o \
        init_mode_MPI.o \
        init_polymers_MPI.o \
        init_velocity_MPI.o \
        init_velocity_cart_MPI.o \
        int_to_char.o \
        kinetic_energy.o \
        main_polymers_MPI.o \
        my_cputime_MPI.o \
        nm_matrix_MPI.o \
        nm_trans.o \
        nm_trans_MPI.o \
        pbc_atom_MPI.o \
        pbc_unfold_MPI.o \
        pbc.o \
        pmfc_polymers_MPI.o \
        polymers_MPI.o \
        predict_aenet_MPI.o \
        predict_n2p2_MPI.o \
        print_polymers_MPI.o \
        print_titles_MPI.o \
        project_out_nma_MPI.o \
        projection_polymers_MPI.o \
        readinput_MPI.o \
        read_species_MPI.o \
        read_start_MPI.o \
        read_tension_MPI.o \
        restart_box_MPI.o \
        restart_box_rehmc_MPI.o \
        restart_polymers_MPI.o \
        run_polymers_MPI.o \
        save_polymers_MPI.o \
        search_tag.o \
        setallocation.o \
        setpiparams_MPI.o \
        set_dof.o \
        setcondition_MPI.o \
        setparams_MPI.o \
        setup_best_MPI.o \
        setup_cons_MPI.o \
        setup_ee_MPI.o \
        setup_me_MPI.o \
        setup_oniom_MPI.o \
        setup_polymers_MPI.o \
        setup_qmass.o \
        softexit_MPI.o \
        standard_polymers_MPI.o \
        suzuki_yoshida.o \
        testfile.o \
        titles.o \
        update_mnhc_cent.o \
        update_mnhc_mode_MPI.o \
        update_polymers_MPI.o \
        update_pos.o \
        update_vel.o \
        $(OBJUTILS) $(OBJPFP)

OBJCALC = \
        calc_variables.o \
        boundary_calc.o \
        calc_adiff.o \
        calc_adiff_atom_dens.o \
        calc_adiff_atom_dens_setup.o \
        calc_adiff_setup.o \
        calc_angl.o \
        calc_angl_atom_dens.o \
        calc_angl_atom_dens_setup.o \
        calc_angl_avg.o \
        calc_angl_avg_setup.o \
        calc_angl_setup.o \
        calc_angl_spec.o \
        calc_angl_spec_dens.o \
        calc_angl_spec_dens_setup.o \
        calc_angl_spec_setup.o \
        calc_cube.o \
        calc_cube_setup.o \
        calc_diff.o \
        calc_diff_atom_dens.o \
        calc_diff_atom_dens_setup.o \
        calc_diff_setup.o \
        calc_dih.o \
        calc_dih_atom_dens.o \
        calc_dih_atom_dens_setup.o \
        calc_dih_avg.o \
        calc_dih_avg_setup.o \
        calc_dih_setup.o \
        calc_dih_spec.o \
        calc_dih_spec_dens.o \
        calc_dih_spec_dens_setup.o \
        calc_dih_spec_setup.o \
        calc_lin.o \
        calc_lin_atom_dens.o \
        calc_lin_atom_dens_setup.o \
        calc_lin_avg.o \
        calc_lin_avg_setup.o \
        calc_lin_setup.o \
        calc_lin_spec.o \
        calc_lin_spec_dens.o \
        calc_lin_spec_dens_setup.o \
        calc_lin_spec_setup.o \
        calc_monitor.o \
        calc_opa.o \
        calc_opa_setup.o \
        calc_opd.o \
        calc_opd_setup.o \
        calc_pbc.o \
        calc_pbc_unfold.o \
        calc_read.o \
        calc_read_setup.o \
        calc_read_species.o \
        calc_tri.o \
        calc_tri_setup.o \
        calc_xla_spec_dens.o \
        calc_xla_spec_dens_setup.o \
        calc_xyz.o \
        calc_xyz_setup.o \
        calccycle.o \
        error_handling_calc.o \
        getdate_calc.o \
        main_calc.o \
        pbc_atom_calc.o \
        readinput_calc.o \
        search_tag.o \
        setparams_calc.o \
        setallocation_calc.o \
        setcondition_calc.o \
        setup_calc.o \
        testfile.o \
        det3.o \

OBJGAU  = \
        common_variables.o \
        gau.o \

OBJMOLPRO = \
        run_molpro.o \

OBJCHARMM = \
        convert_charmm.o \

OBJTINKER = \
        convert_tinker.o \

OBJPREPLIQUID = \
        common_variables.o \
        boundary.o \
        det3.o \
        error_handling.o \
        init_molcomp.o \
        pbc_atom.o \
        prep_liquid.o \
        random.o \
        readinput.o \
        read_species.o \
        restart_box.o \
        setparams.o \
        setallocation.o \
        search_tag.o \
        testfile.o \

OBJPREPBEST = \
        prep_best.o

#-----------------------------------------------------------------------
#     compile all codes
#-----------------------------------------------------------------------

all:    $(LIBSMASH) \
        $(LIBSMASHMPI) \
        $(PROGPIMD) \
        $(PROGPIMPI) \
        $(PROGPOLY) \
        $(PROGCALC) \
        $(PROGGAU) \
        $(PROGMOLPRO) \
        $(PROGCHARMM) \
        $(PROGTINKER) \
        $(PROGPREPLIQUID) \
        $(PROGPREPBEST)

#-----------------------------------------------------------------------
#     compile each code
#-----------------------------------------------------------------------

$(PROGPIMD): $(OBJPIMD)
	$(FCMP) $(SMASHOPT) $(FLAGMP) -o $(PROGPIMD) $(OBJPIMD) $(LIB)

$(PROGPIMPI): $(OBJPIMPI)
	$(FCMP) $(SMASHOPTMPI) $(FLAGMP) -o $(PROGPIMPI) $(OBJPIMPI) $(LIBMPI)

$(PROGPOLY): $(OBJPOLY)
	$(FCMP) $(SMASHOPTMPI) $(FLAGMP) -o $(PROGPOLY) $(OBJPOLY) $(LIBMPI)

$(PROGCALC): $(OBJCALC)
	$(FCMP) $(FLAGMP) -o $(PROGCALC) $(OBJCALC)

$(PROGGAU): $(OBJGAU)
	$(FCMP) $(FLAGMP) -o $(PROGGAU) $(OBJGAU)

$(PROGMOLPRO): $(OBJMOLPRO)
	$(FCMP) $(FLAGMP) -o $(PROGMOLPRO) $(OBJMOLPRO)

$(PROGCHARMM): $(OBJCHARMM)
	$(FCMP) $(FLAGMP) -o $(PROGCHARMM) $(OBJCHARMM)

$(PROGTINKER): $(OBJTINKER)
	$(FCMP) $(FLAGMP) -o $(PROGTINKER) $(OBJTINKER)

$(PROGPREPLIQUID): $(OBJPREPLIQUID)
	$(FCMP) $(FLAGMP) -o $(PROGPREPLIQUID) $(OBJPREPLIQUID)

$(PROGPREPBEST): $(OBJPREPBEST)
	$(FCMP) $(FLAGMP) -o $(PROGPREPBEST) $(OBJPREPBEST)

#-----------------------------------------------------------------------
#     macro
#-----------------------------------------------------------------------

.SUFFIXES: .o .F90

.F90.o:
	$(FCMP) -c $(FLAGMP) $<

lbfgs.o: lbfgs.F
	$(FCMP) -c $(FLAGMP) $<  

diag_nolapack.o: diag_nolapack.F
	$(FCMP) -c $(FLAGMP) $<  

diag_nolapack_MPI.o: diag_nolapack_MPI.F
	$(FCMP) -c $(FLAGMP) $<  

ifdef AENET
ioutils_s.o: ioutils_s.c
	$(CC) ioutils_s.c -c

predict_aenet_MPI.o: predict_aenet_MPI.F90
	$(FCMP) -c $(FLAGMP) $(LIBAENET) $<
endif

ifdef n2p2
predict_n2p2_MPI.o: predict_n2p2_MPI.F90
	$(FCMP) -c $(FLAGMP) $(LIBN2P2) $<
endif

#-----------------------------------------------------------------------
#     clean
#-----------------------------------------------------------------------

clean:
	rm -f *.o *.x *.mod *.f90 *.f *~
	rm -f $(PROGPIMD)
	rm -f $(PROGPIMPI)
	rm -f $(PROGPOLY)
	rm -f $(PROGCALC)
	rm -f $(PROGGAU)
	rm -f $(PROGMOLPRO)
	rm -f $(PROGCHARMM)
	rm -f $(PROGTINKER)
	rm -f $(PROGPREPLIQUID)
	rm -f $(PROGPREPBEST)

veryclean:
	rm -f *.o *.x *.mod *.f90 *.f *~
	rm -f $(PROGPIMD)
	rm -f $(PROGPIMPI)
	rm -f $(PROGPOLY)
	rm -f $(PROGCALC)
	rm -f $(PROGGAU)
	rm -f $(PROGMOLPRO)
	rm -f $(PROGCHARMM)
	rm -f $(PROGTINKER)
	rm -f $(PROGPREPLIQUID)
	rm -f $(PROGPREPBEST)

ifdef SMASH
	rm -f $(SMASHDIR)/*.o $(SMASHDIR)/*.mod
	rm -f ../lib/libsmash.a ../lib/libsmashmpi.a
endif

#ifdef AENET
#	rm -f $(AENETSRCDIR)/*.o $(AENETSRCDIR)/ext/*.o 
#   rm -f $(AENETSRCDIR)/*.mod $(AENETSRCDIR)/ext/*.mod
#	rm -f $(LBFGSSRCDIR)/*.o
#	rm -f ../lib/libaenet.a ../lib/liblbfgs.a
#endif
