#///////////////////////////////////////////////////////////////////////
#
#      Author:          Y. Nagai, M. Shiga
#      Last updated:    March 12, 2019 by M. Shiga
#      Description:     makefile for the PIMD code with AENET
#
#///////////////////////////////////////////////////////////////////////

########################################################################
ifdef AENET
########################################################################

#-----------------------------------------------------------------------
#     define LBFGS variables
#-----------------------------------------------------------------------

OBJLBFGS= \
    $(LBFGSSRCDIR)/lbfgsb.o \
    $(LBFGSSRCDIR)/linpack.o \
    $(LBFGSSRCDIR)/blas.o \
    $(LBFGSSRCDIR)/timer.o

#-----------------------------------------------------------------------
#     compile LBFGS
#-----------------------------------------------------------------------

$(LBFGSSRCDIR)/%.o : $(LBFGSSRCDIR)/%.f
	$(FCMP) $(FLAGMP) $(LBFGSOPT) -o $@ -c $<

$(LIBLBFGS) : $(OBJLBFGS)
	ar -cr $(LIBLBFGS) $(OBJLBFGS)

#-----------------------------------------------------------------------
#     define AENET variables
#-----------------------------------------------------------------------

OBJAENET = \
	$(AENETSRCDIR)/ext/io.o \
	$(AENETSRCDIR)/ext/feedforward.o \
	$(AENETSRCDIR)/ext/sortlib.o \
	$(AENETSRCDIR)/ext/lclist.o \
	$(AENETSRCDIR)/ext/xsflib.o \
	$(AENETSRCDIR)/ext/chebyshev.o \
	$(AENETSRCDIR)/ext/symmfunc.o \
	$(AENETSRCDIR)/ext/sfbasis.o \
	$(AENETSRCDIR)/ext/timing.o \
	$(AENETSRCDIR)/ext/unittest.o \
	$(AENETSRCDIR)/constants.o \
	$(AENETSRCDIR)/aeio.o \
	$(AENETSRCDIR)/sfsetup.o \
	$(AENETSRCDIR)/geometry.o \
	$(AENETSRCDIR)/trainset.o \
	$(AENETSRCDIR)/potential.o \
	$(AENETSRCDIR)/aenet.o \
	$(AENETSRCDIR)/input.o \
	$(AENETSRCDIR)/random.o \
	$(AENETSRCDIR)/generate.o \
	$(AENETSRCDIR)/parallel.o \
	$(AENETSRCDIR)/optimize.o \
	$(AENETSRCDIR)/predict.o \
	$(AENETSRCDIR)/train.o \
	$(AENETSRCDIR)/ext/arglib.o \
	$(AENETSRCDIR)/aenet_predict.o

#    $(AENETSRCDIR)/aenet_predict.o \
#    $(AENETSRCDIR)/aenet_mpimodule.o \

#-----------------------------------------------------------------------
#     compile AENET
#-----------------------------------------------------------------------

$(AENETSRCDIR)/ext/%.o : $(AENETSRCDIR)/ext/%.f90
	$(FCMP) $(FLAGMP) $(AENETOPT) -o $@ -c $<

$(AENETSRCDIR)/%.o : $(AENETSRCDIR)/%.f90
	$(FCMP) $(FLAGMP) $(AENETOPT) -o $@ -c $<

$(AENETSRCDIR)/parallel.o : $(AENETSRCDIR)/parallel.F90
	$(FCMP) $(FLAGMP) $(AENETOPT) -o common_variables.o -c common_variables.F
	$(FCMP) $(FLAGMP) $(AENETOPT) -o $@ -c $<

$(AENETSRCDIR)/predict.o : $(AENETSRCDIR)/predict.F90
	$(FCMP) $(AENETOPT) -o $@ -c $<

$(AENETSRCDIR)/aenet_predict.o : $(AENETSRCDIR)/aenet_predict.F90
	$(FCMP) $(AENETOPT) -o $@ -c $<

$(LIBAENET) : $(OBJAENET)
	ar -cr $(LIBAENET) $(OBJAENET)

########################################################################
endif
########################################################################
