#! /bin/csh

set exedir=$PWD

echo
echo ==============================
echo STEP 1: PREPARE FFTW
echo $PWD
echo ==============================
echo

# if you need fftw3 for QE, please get one.
#
# cp ~/Downloads/fftw-3.3.8/libfftw3.la .

echo
echo ==============================
echo STEP 2: PREPARE QE
echo $PWD
echo ==============================
echo

cd ../lib/qe
rm -r q-e-qe-6.2.1
unzip q-e-qe-6.2.1.zip
patch -p0 < qe-6.2.1_to_pimdlib.patch
cd q-e-qe-6.2.1; ./configure; cd ..

echo
echo ==============================
echo STEP 3: MAKE COMMON_VARIABLES
echo $PWD
echo ==============================
echo

cd $exedir
# make pimd.mpi.x
# rm ./pimd.mpi.x

make clean
make common_variables.o
cp -p common_variables.o common_variables.mod ../lib/qe/q-e-qe-6.2.1/Modules/
cp -p common_variables.o common_variables.mod ../lib/qe/q-e-qe-6.2.1/PW/src/

echo
echo ==============================
echo STEP 4: INITIALIZE QE LIBRARY
echo $PWD
echo ==============================
echo

rm ../lib/qe/q-e-qe-6.2.1/PW/src/lib*.a
cp -p ../lib/qe/Makefile_libqe_pwsrc   ../lib/qe/q-e-qe-6.2.1/PW/src/Makefile
cp -p ../lib/qe/Makefile_libqe_modules ../lib/qe/q-e-qe-6.2.1/Modules/Makefile

echo
echo ==============================
echo STEP 5: MAKE PW
echo $PWD
echo ==============================
echo

cd ../lib/qe/q-e-qe-6.2.1
./configure
make pw

#
# Do not worry about this error here:
#
# ../../Modules/libqemod.a(xml_io_base.o):/home/user/pimd/lib/qe/q-e-qe-6.2.1/Modules/xml_io_base.f90:444: 
# more undefined references to `__common_variables_MOD_myrank_main' follow
# collect2: error: ld returned 1 exit status
# Makefile:313: recipe for target 'pw.x' failed
# make[2]: *** [pw.x] Error 1
# make[2]: Leaving directory '/home/user/pimd/lib/qe/q-e-qe-6.2.1/PW/src'
# Makefile:9: recipe for target 'pw' failed
# make[1]: *** [pw] Error 1
# make[1]: Leaving directory '/home/user/pimd/lib/qe/q-e-qe-6.2.1/PW'
# Makefile:69: recipe for target 'pw' failed
# make: *** [pw] Error 1
#

echo
echo ==============================
echo STEP 6: MAKE MODULES
echo $PWD
echo ==============================
echo

cd ./Modules
make

echo
echo ==============================
echo STEP 7: MAKE LIBQE
echo $PWD
echo ==============================
echo

cd ../PW/src
make
make default

echo
echo ==============================
echo STEP 8: MAKE PIMD 2ND TRIAL
echo $PWD
echo ==============================
echo

cd $exedir
make pimd.mpi.x

echo
echo ==============================
echo END
echo ==============================
echo

exit
